
-- mb1600
-- Specialization for mb1600 mod
-- Date 28/02/2015
-- Copyright (C) Unguided


mb1600 = {};

function mb1600.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function mb1600:load(xmlFile)
	self.frontLinkageBottomArmRotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontBottomArm#visNode"));
	setVisibility(self.frontLinkageBottomArmRotNode, false) ; 
end;

function mb1600:delete()
end;

function mb1600:readStream(streamId, connection)
end;

function mb1600:writeStream(streamId, connection)
end;

function mb1600:mouseEvent(posX, posY, isDown, isUp, button)
end;

function mb1600:keyEvent(unicode, sym, modifier, isDown)
end;

function mb1600:update(dt)
end;

function mb1600:updateTick(dt)
end;

function mb1600:draw()
end;

function mb1600:onLeave()
end;

function mb1600:onEnter()
end;

function mb1600:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = math.max(self.implementCount - 1, 0);
		end;
		if jointIndex == 2 then
			setVisibility(self.frontLinkageBottomArmRotNode, true); 
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 3 then
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 4 then
		end;
	end;

	self.updateJoint = true;
end;

function mb1600:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;

	if implement.object.attacherJoint.jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = self.implementCount + 1;
		end;
		if jointIndex == 2 then
			setVisibility(self.frontLinkageBottomArmRotNode, false); 
		end;
	else
	end;
	
	self.updateJoint = true;
end;

function mb1600:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;
