--
-- DtP Map
--
-- @author  Stefan Geiger
-- @date  12/07/10
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

DtP = {}

local DtP_mt = Class(DtP, Mission00);


function DtP:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = DtP_mt;
    end;
    local self = DtP:superClass():new(baseDirectory, mt);

    return self;
end;

function DtP:delete()
    DtP:superClass().delete(self);
end;

function DtP:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableGoldCoinsObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;
	self.AnimationMapConfig = {"scripts/AnimationMap.xml", self.baseDirectory};
    self:loadMap(Utils.getFilename("map/DtP.i3d", self.baseDirectory), true, self.loadCareerDtPFinished, self);
end;

function DtP:loadCareerDtPFinished(node, arguments)
    if self.cancelLoading then
        return;
    end
    local startedRepeat = startFrameRepeatMode();
    trcScreenFlip();
    self:loadMapXMLFile(Utils.getFilename("DtP.xml", self.baseDirectory));
    trcScreenFlip();
    self:loadTyreTrackSystem(Utils.getFilename("$data/vehicles/shared/tyreTrackMaterialHolder.i3d", self.baseDirectory));
    trcScreenFlip();
    self:loadI3D("$data/vehicles/particleAnimations/particle_materialHolder.i3d");
    trcScreenFlip();
	
	self:loadI3D("vehicles/particleAnimations/fertilizer/fertilizer_particleAnimations.i3d"); -- Dünger
    trcScreenFlip();
    self:loadI3D("vehicles/particleAnimations/kalk/kalk_particleAnimations.i3d"); -- Kalk
    trcScreenFlip();
    self:loadI3D("vehicles/particleAnimations/seeds/seeds_particleAnimations.i3d"); -- seeds
    trcScreenFlip();
    self:loadI3D("vehicles/particleAnimations/compost_soil/compost_soil_particleAnimations.i3d"); -- CompostErde 
    trcScreenFlip();
	
    self:loadI3D("$data/vehicles/fillPlanes/fillPlane_materialHolder.i3d");
	trcScreenFlip();
	
	self:loadI3D("vehicles/fillPlanes/fertilizer/fertilizer.i3d"); -- Düngerplane
	trcScreenFlip();
    self:loadI3D("vehicles/fillPlanes/kalk/kalk.i3d"); -- Kalkplane
	trcScreenFlip();
	self:loadI3D("vehicles/fillPlanes/seeds/seeds.i3d"); -- SeedsPlane
	trcScreenFlip();
	self:loadI3D("vehicles/fillPlanes/compost_soil/compost_soil.i3d"); -- CompostPlane
	trcScreenFlip();
	
    self.ingameMap:loadMap(Utils.getFilename("map_pda.png", self.baseDirectory), 2048, 2048);

	trcScreenFlip();
    g_statisticView:setMapViewsMap(Utils.getFilename("map_pda.png", self.baseDirectory), 2048, 2048);

	trcScreenFlip();
    -- ATMs
    self.ingameMap:createMapHotspot("Bank", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_bank.png", self.baseDirectory), 180, -790, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Bank", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_bank.png", self.baseDirectory), -192.5, -190, nil, nil, false, false, false, 0, true);

    -- shops
    self.ingameMap:createMapHotspot("Shop", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_shop.png", self.baseDirectory), -250, -175, nil, nil, false, false, false, 0, true);
    local gardenCenterHotspot = self.ingameMap:createMapHotspot("Shop", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_shop.png", self.baseDirectory), -572, 366, nil, nil, false, false, true, 0, true);
    gardenCenterHotspot.fullViewName = g_i18n:getText("gardenCenter");

    -- egg sellpoints
    self.ingameMap:createMapHotspot("Eggs", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_eggs.png", self.baseDirectory), 281.5, -704.5, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Eggs", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_eggs.png", self.baseDirectory), -741.5, -187, nil, nil, false, false, false, 0, true);
    
    -- farm silos
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), 161, -25, nil, nil, false, false, false, 0, true);
    
    -- bga
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlace.png", self.baseDirectory), 10, 730, nil, nil, false, false, false, 0, true);
    
    -- grass heaps
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -500, 500, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -730.5, 140, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -144.5, 264.5, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("TipPlace", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_tipPlaceGreen.png", self.baseDirectory), -297, -595.5, nil, nil, false, false, false, 0, true);
    
    -- livestock
    self.ingameMap:createMapHotspot("Cows", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_cows.png", self.baseDirectory), 159, -15.7, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Sheep", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_sheep.png", self.baseDirectory), 91.362, -27.465, nil, nil, false, false, false, 0, true);
    self.ingameMap:createMapHotspot("Chickens", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_chickens.png", self.baseDirectory), 236.5, 118.5, nil, nil, false, false, false, 0, true);
    
    -- spinnery
    self.ingameMap:createMapHotspot("woolDeliveryHotspot", Utils.getFilename("$dataS2/menu/hud/hud_pda_spot_spinnery.png", self.baseDirectory), -63, 45, nil, nil, false, false, false, 0, true);

	trcScreenFlip();
    DtP:superClass().load(self);

	trcScreenFlip();

    if startedRepeat then
        endFrameRepeatMode();
    end
    self:finishLoadingTask();
	if _G["AnimationMapTrigger"] == nil then print("  AnimationMapTrigger - Notice: The mod AnimationMapTrigger is missing from your mods folder, get your copy at http://vertexdezign.net/"); 
	end;
end;

function DtP:onStartMission()
    DtP:superClass().onStartMission(self);
end;

function DtP:mouseEvent(posX, posY, isDown, isUp, button)
    DtP:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function DtP:keyEvent(unicode, sym, modifier, isDown)
    DtP:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function DtP:update(dt)
    DtP:superClass().update(self, dt);
end;

function DtP:draw()
    DtP:superClass().draw(self);
end;
