SpecializationUtil.registerSpecialization("addMultiFruit", "addMultiFruit", g_currentModDirectory.."addMultiFruit.lua")

addMultiFruit_Register = {};

function addMultiFruit_Register:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		print("--- loading addMultiFruit mod V3.0 --- (by upsidedown)")

		
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					if vs ~= nil and (vs == SpecializationUtil.getSpecialization("drivable") or vs == SpecializationUtil.getSpecialization("attachable")) then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							if rawget(SpecializationUtil.specializations, string.format("%s.addMultiFruit", _name)) ~= nil then
								allowInsertion = false;								
							end;							
						end;
						if allowInsertion then	
							table.insert(v.specializations, SpecializationUtil.getSpecialization("addMultiFruit"));
						end;
						
					end;
				end;
			end;	
		end;
	end;
end;

function addMultiFruit_Register:deleteMap()
  
end;

function addMultiFruit_Register:keyEvent(unicode, sym, modifier, isDown)

end;

function addMultiFruit_Register:mouseEvent(posX, posY, isDown, isUp, button)

end;

function addMultiFruit_Register:update(dt)
	
end;

function addMultiFruit_Register:draw()
  
end;

addModEventListener(addMultiFruit_Register);