--
-- Additional license plates specialization 
-- Script by Blacky_BPG
-- Version 1.1.1
-- Last Change: 23.12.2013 by Blacky_BPG
-- Version 1.0.0	initial version
-- Version 1.1.1	added Austria license plate
-- 

numberPlatesConnect = {};
numberPlatesConnect.modDir = g_currentModDirectory;

function numberPlatesConnect.prerequisitesPresent(specializations)
    return true;
end;

function numberPlatesConnect:load(xmlFile)
	self.platesC = {};
	self.platesC.registered = false;
	self.platesC.hasRegistered = false;

	self.platesC.sign1Char = 32;
	self.platesC.sign2Char = 32;
	self.platesC.sign3Char = 32;
	self.platesC.sign4Char = 32;
	self.platesC.sign5Char = 32;
	self.platesC.sign6Char = 32;
	self.platesC.sign7Char = 32;
	self.platesC.sign8Char = 32;
	self.platesC.signMinusChar = 32;

	self.platesC.tuevChar = 0;
	self.platesC.stateChar = 0;
	self.platesC.isAustria = false;

	self.resetPlate = SpecializationUtil.callSpecializationsFunction("resetPlate");
	local i = 0;
	local platePath = string.format("vehicle.numberplatesConnect.plate(%d)",i);
	local plateFound = getXMLString(xmlFile, platePath .. "#index");
	if plateFound ~= nil then
		self.isSelectable = true;
		while true do
			local platePath = string.format("vehicle.numberplatesConnect.plate(%d)",i);
			local plateIndex = getXMLString(xmlFile, platePath .. "#index");
			if plateIndex == nil then
				break;
			end;
			local index = Utils.indexToObject(self.components, plateIndex);
			if index == nil or index == 0 then
				print(" Error: No plate index "..tostring(platePath).." found in vehicle "..tostring(self.name));
				break;
			end;
			self.platesC[i+1] = {};
			self.platesC[i+1].id = index;
			local plateId = getUserAttribute(index, "plateId");
			if plateId == nil then
				print(" Error: Plate index not assigned for plate "..tostring(i+1).." for vehicle "..tostring(self.name));
				break;
			end;
			local indexPlateId = Utils.indexToObject(index, plateId);
			if indexPlateId == nil or indexPlateId == 0 then
				print(" Error: PlateId index for plate "..tostring(i+1).." not found in vehicle "..tostring(self.name));
				break;
			end;
			self.platesC[i+1].plateId = indexPlateId;

			local isAustria = Utils.getNoNil(getUserAttribute(index, "isAustria"),false);
			self.platesC[i+1].isAustria = isAustria;
			self.platesC.isAustria = isAustria;

			local sealStateId = getUserAttribute(index, "sealStateId");
			if sealStateId == nil then
				print(" Error: State Seal index not assigned for plate "..tostring(i+1).." for vehicle "..tostring(self.name));
				break;
			end;
			local indexSealStateId = Utils.indexToObject(index, sealStateId);
			if indexSealStateId == nil or indexSealStateId == 0 then
				print(" Error: State Seal Id index for plate "..tostring(i+1).." not found in vehicle "..tostring(self.name));
				break;
			end;
			self.platesC[i+1].stateId = indexSealStateId;

			if not self.platesC[i+1].isAustria then
				local sealTuevId = getUserAttribute(index, "sealTuevId");
				if sealTuevId == nil then
					print(" Error: TUEV Seal index not assigned for plate "..tostring(i+1).." for vehicle "..tostring(self.name));
					break;
				end;
				local indexSealTuevId = Utils.indexToObject(index, sealTuevId);
				if indexSealTuevId == nil or indexSealTuevId == 0 then
					print(" Error: TUEV Seal Id index for plate "..tostring(i+1).." not found in vehicle "..tostring(self.name));
					break;
				end;
				self.platesC[i+1].tuevId = indexSealTuevId;
			end;

			local sign1Id = getUserAttribute(index, "sign1Id");
			if sign1Id == nil then
				print(" Error: Sign1 index not assigned for plate "..tostring(i+1).." for vehicle "..tostring(self.name));
				break;
			end;
			local indexSign1Id = Utils.indexToObject(index, sign1Id);
			if indexSign1Id == nil or indexSign1Id == 0 then
				print(" Error: Sign1 Id index for plate "..tostring(i+1).." not found in vehicle "..tostring(self.name));
				break;
			end;
			self.platesC[i+1].sign1 = indexSign1Id;

			local sign2Id = getUserAttribute(index, "sign2Id");
			if sign2Id == nil then
				print(" Error: Sign2 index not assigned for plate "..tostring(i+1).." for vehicle "..tostring(self.name));
				break;
			end;
			local indexsign2Id = Utils.indexToObject(index, sign2Id);
			if indexsign2Id == nil or indexsign2Id == 0 then
				print(" Error: Sign2 Id index for plate "..tostring(i+1).." not found in vehicle "..tostring(self.name));
				break;
			end;
			self.platesC[i+1].sign2 = indexsign2Id;

			local sign3Id = getUserAttribute(index, "sign3Id");
			if sign3Id == nil then
				print(" Error: sign3 index not assign3ed for plate "..tostring(i+1).." for vehicle "..tostring(self.name));
				break;
			end;
			local indexsign3Id = Utils.indexToObject(index, sign3Id);
			if indexsign3Id == nil or indexsign3Id == 0 then
				print(" Error: sign3 Id index for plate "..tostring(i+1).." not found in vehicle "..tostring(self.name));
				break;
			end;
			self.platesC[i+1].sign3 = indexsign3Id;

			local sign4Id = getUserAttribute(index, "sign4Id");
			if sign4Id == nil then
				print(" Error: sign4 index not assigned for plate "..tostring(i+1).." for vehicle "..tostring(self.name));
				break;
			end;
			local indexsign4Id = Utils.indexToObject(index, sign4Id);
			if indexsign4Id == nil or indexsign4Id == 0 then
				print(" Error: sign4 Id index for plate "..tostring(i+1).." not found in vehicle "..tostring(self.name));
				break;
			end;
			self.platesC[i+1].sign4 = indexsign4Id;

			local sign5Id = getUserAttribute(index, "sign5Id");
			if sign5Id == nil then
				print(" Error: sign5 index not assigned for plate "..tostring(i+1).." for vehicle "..tostring(self.name));
				break;
			end;
			local indexsign5Id = Utils.indexToObject(index, sign5Id);
			if indexsign5Id == nil or indexsign5Id == 0 then
				print(" Error: sign5 Id index for plate "..tostring(i+1).." not found in vehicle "..tostring(self.name));
				break;
			end;
			self.platesC[i+1].sign5 = indexsign5Id;

			local sign6Id = getUserAttribute(index, "sign6Id");
			if sign6Id == nil then
				print(" Error: sign6 index not assigned for plate "..tostring(i+1).." for vehicle "..tostring(self.name));
				break;
			end;
			local indexsign6Id = Utils.indexToObject(index, sign6Id);
			if indexsign6Id == nil or indexsign6Id == 0 then
				print(" Error: sign6 Id index for plate "..tostring(i+1).." not found in vehicle "..tostring(self.name));
				break;
			end;
			self.platesC[i+1].sign6 = indexsign6Id;

			local sign7Id = getUserAttribute(index, "sign7Id");
			if sign7Id == nil then
				print(" Error: sign7 index not assigned for plate "..tostring(i+1).." for vehicle "..tostring(self.name));
				break;
			end;
			local indexsign7Id = Utils.indexToObject(index, sign7Id);
			if indexsign7Id == nil or indexsign7Id == 0 then
				print(" Error: sign7 Id index for plate "..tostring(i+1).." not found in vehicle "..tostring(self.name));
				break;
			end;
			self.platesC[i+1].sign7 = indexsign7Id;

			if not self.platesC[i+1].isAustria then
				local sign8Id = getUserAttribute(index, "sign8Id");
				if sign8Id == nil then
					print(" Error: sign8 index not assigned for plate "..tostring(i+1).." for vehicle "..tostring(self.name));
					break;
				end;
				local indexsign8Id = Utils.indexToObject(index, sign8Id);
				if indexsign8Id == nil or indexsign8Id == 0 then
					print(" Error: sign8 Id index for plate "..tostring(i+1).." not found in vehicle "..tostring(self.name));
					break;
				end;
				self.platesC[i+1].sign8 = indexsign8Id;
			end;

			self.platesC[i+1].hasLight = Utils.getNoNil(getUserAttribute(index, "hasLight"), false);
			self.platesC[i+1].stateSealActive = false;
			self.platesC[i+1].tuevSealActive = false;

			local signMinusId = getUserAttribute(index, "signMinusId");
			local indexsignMinusId = nil;
			if signMinusId ~= nil then
				indexsignMinusId = Utils.indexToObject(index, signMinusId);
				if indexsignMinusId == nil or indexsignMinusId == 0 then
					indexsignMinusId = nil;
				end;
			end;
			self.platesC[i+1].signMinus = indexsignMinusId;

			if self.platesC[i+1].hasLight then
				local plateLightId = getUserAttribute(index, "plateLightId");
				local indexplateLightId = nil;
				if plateLightId ~= nil then
					indexplateLightId = Utils.indexToObject(index, plateLightId);
					if indexplateLightId == nil or indexplateLightId == 0 then
						indexplateLightId = nil;
					end;
				end;
				self.platesC[i+1].plateIdLight = indexplateLightId;
			end;
			i=i+1
		end;

		self:resetPlate();
	end;
end;

function numberPlatesConnect:resetPlate()
	if table.getn(self.platesC) > 0 then
		self.platesC.registered = false;
		self.platesC.hasRegistered = false;
		for a=1, table.getn(self.platesC) do
			setVisibility(self.platesC[a].id, true);
			setVisibility(self.platesC[a].plateId, false);
			setVisibility(self.platesC[a].sign1, false);
			setVisibility(self.platesC[a].sign2, false);
			setVisibility(self.platesC[a].sign3, false);
			setVisibility(self.platesC[a].sign4, false);
			setVisibility(self.platesC[a].sign5, false);
			setVisibility(self.platesC[a].sign6, false);
			setVisibility(self.platesC[a].sign7, false);
			if self.platesC[a].sign8 ~= nil then
				setVisibility(self.platesC[a].sign8, false);
			end;
			setVisibility(self.platesC[a].stateId, false);
			if self.platesC[a].tuevId ~= nil then
				setVisibility(self.platesC[a].tuevId, false);
			end;
			if self.platesC[a].signMinus ~= nil then
				setVisibility(self.platesC[a].signMinus, false);
			end;
			if self.platesC[a].plateIdLight ~= nil then
				setVisibility(self.platesC[a].plateIdLight, false);
			end;
		end;
	end;
end;

function numberPlatesConnect:onDetach()
	self:resetPlate();
end;

function numberPlatesConnect:update(dt)
	if self.attacherVehicle ~= nil then
		if not self.platesC.registered then
			if self.attacherVehicle.plates ~= nil and self.attacherVehicle.plates.sign1Char ~= nil and self.attacherVehicle.plates.registered then
				if self.attacherVehicle.plates.isAustria and not self.platesC.isAustria then
					self.platesC.sign1Char = 32;
					self.platesC.sign2Char = self.attacherVehicle.plates.sign1Char;
					self.platesC.sign3Char = self.attacherVehicle.plates.sign2Char;
					self.platesC.sign4Char = self.attacherVehicle.plates.sign3Char;
					self.platesC.sign5Char = self.attacherVehicle.plates.sign4Char;
					self.platesC.sign6Char = self.attacherVehicle.plates.sign5Char;
					self.platesC.sign7Char = self.attacherVehicle.plates.sign6Char;
					self.platesC.sign8Char = self.attacherVehicle.plates.sign7Char;
					self.platesC.registered = true;
				else
					self.platesC.sign1Char = self.attacherVehicle.plates.sign1Char;
					self.platesC.sign2Char = self.attacherVehicle.plates.sign2Char;
					self.platesC.sign3Char = self.attacherVehicle.plates.sign3Char;
					self.platesC.sign4Char = self.attacherVehicle.plates.sign4Char;
					self.platesC.sign5Char = self.attacherVehicle.plates.sign5Char;
					self.platesC.sign6Char = self.attacherVehicle.plates.sign6Char;
					self.platesC.sign7Char = self.attacherVehicle.plates.sign7Char;
					self.platesC.sign8Char = self.attacherVehicle.plates.sign8Char;
					self.platesC.registered = true;
				end;
			elseif self.attacherVehicle.platesC ~= nil and self.attacherVehicle.platesC.sign1Char ~= nil and self.attacherVehicle.platesC.registered then
				if self.attacherVehicle.plates.isAustria and not self.platesC.isAustria then
					self.platesC.sign1Char = 32;
					self.platesC.sign2Char = self.attacherVehicle.platesC.sign1Char;
					self.platesC.sign3Char = self.attacherVehicle.platesC.sign2Char;
					self.platesC.sign4Char = self.attacherVehicle.platesC.sign3Char;
					self.platesC.sign5Char = self.attacherVehicle.platesC.sign4Char;
					self.platesC.sign6Char = self.attacherVehicle.platesC.sign5Char;
					self.platesC.sign7Char = self.attacherVehicle.platesC.sign6Char;
					self.platesC.sign8Char = self.attacherVehicle.platesC.sign7Char;
					self.platesC.registered = true;
				else
					self.platesC.sign1Char = self.attacherVehicle.platesC.sign1Char;
					self.platesC.sign2Char = self.attacherVehicle.platesC.sign2Char;
					self.platesC.sign3Char = self.attacherVehicle.platesC.sign3Char;
					self.platesC.sign4Char = self.attacherVehicle.platesC.sign4Char;
					self.platesC.sign5Char = self.attacherVehicle.platesC.sign5Char;
					self.platesC.sign6Char = self.attacherVehicle.platesC.sign6Char;
					self.platesC.sign7Char = self.attacherVehicle.platesC.sign7Char;
					self.platesC.sign8Char = self.attacherVehicle.platesC.sign8Char;
					self.platesC.registered = true;
				end;
			end;
		end;
	else
		if self.platesC.registered then
			self:resetPlate();
		end;
	end;
end;

function numberPlatesConnect:setLightsTypesMask(lightsTypesMask)
	if lightsTypesMask ~= nil then
		if lightsTypesMask > 0 then
			if table.getn(self.platesC) > 0 then
				for a=1, table.getn(self.platesC) do
					if self.platesC[a].hasLight then
						setVisibility(self.platesC[a].plateId, false);
						if self.platesC[a].plateIdLight ~= nil then
							setVisibility(self.platesC[a].plateIdLight, true);
						end;
					end;
				end;
			end;
		else
			if table.getn(self.platesC) > 0 then
				for a=1, table.getn(self.platesC) do
					if self.platesC[a].hasLight then
						setVisibility(self.platesC[a].plateId, true);
						if self.platesC[a].plateIdLight ~= nil then
							setVisibility(self.platesC[a].plateIdLight, false);
						end;
					end;
				end;
			end;
		end;
	end;
end;

function numberPlatesConnect:updateTick(dt)
	if self.platesC.registered and not self.platesC.hasRegistered then
		self.platesC.hasRegistered = true;
		if table.getn(self.platesC) > 0 then
			for a=1, table.getn(self.platesC) do
				setVisibility(self.platesC[a].id, true);
				setVisibility(self.platesC[a].plateId, true);
				setVisibility(self.platesC[a].sign1, true);
				setVisibility(self.platesC[a].sign2, true);
				setVisibility(self.platesC[a].sign3, true);
				setVisibility(self.platesC[a].sign4, true);
				setVisibility(self.platesC[a].sign5, true);
				setVisibility(self.platesC[a].sign6, true);
				setVisibility(self.platesC[a].sign7, true);
				if self.platesC[a].sign8 ~= nil then
					setVisibility(self.platesC[a].sign8, true);
				end;
				if self.platesC[a].signMinus ~= nil then
					setVisibility(self.platesC[a].signMinus, true);
				end;
				if self.platesC[a].plateIdLight ~= nil then
					setVisibility(self.platesC[a].plateIdLight, false);
				end;
				setShaderParameter(self.platesC[a].sign1, "TexturePosition", 0 - (getTexPos(self.platesC.sign1Char) * 0.02417), 0, 0, 0, false);
				setShaderParameter(self.platesC[a].sign2, "TexturePosition", 0 - (getTexPos(self.platesC.sign2Char) * 0.02417), 0, 0, 0, false);
				setShaderParameter(self.platesC[a].sign3, "TexturePosition", 0 - (getTexPos(self.platesC.sign3Char) * 0.02417), 0, 0, 0, false);
				setShaderParameter(self.platesC[a].sign4, "TexturePosition", 0 - (getTexPos(self.platesC.sign4Char) * 0.02417), 0, 0, 0, false);
				setShaderParameter(self.platesC[a].sign5, "TexturePosition", 0 - (getTexPos(self.platesC.sign5Char) * 0.02417), 0, 0, 0, false);
				setShaderParameter(self.platesC[a].sign6, "TexturePosition", 0 - (getTexPos(self.platesC.sign6Char) * 0.02417), 0, 0, 0, false);
				setShaderParameter(self.platesC[a].sign7, "TexturePosition", 0 - (getTexPos(self.platesC.sign7Char) * 0.02417), 0, 0, 0, false);
				if self.platesC[a].sign8 ~= nil then
					setShaderParameter(self.platesC[a].sign8, "TexturePosition", 0 - (getTexPos(self.platesC.sign8Char) * 0.02417), 0, 0, 0, false);
				end;

				if self.platesC[a].signMinus ~= nil then
					setShaderParameter(self.platesC[a].signMinus, "TexturePosition", 0 - (26 * 0.02417), 0, 0, 0, false);
				end;
			end;
		end;
	end;
end;

function numberPlatesConnect:draw()
end;

function getTexPos(char)
	if char == 32 then
		char = -1;
	elseif char > 64 and char < 91 then
		char = char - 65;
	elseif char > 47 and char < 58 then
		char = char - 21;
	elseif char == 45 then
		char = 26;
	elseif char == 142 then
		char = 38;
	elseif char == 154 then
		char = 37;
	elseif char == 153 then
		char = 39;
	else
		char = -1;
	end;
	return char;
end;

function numberPlatesConnect:delete()
end;

function numberPlatesConnect:mouseEvent(posX, posY, isDown, isUp, button)
end;

function numberPlatesConnect:keyEvent(unicode, sym, modifier, isDown)
end;

