local metadata = {
"## Interface: 2.1.0.2 RC3",
"## Title: AllInOneSilo",
"## Notes: one SiloTrigger for all FillTypes",
"## Author: Marhu",
"## Version: 1.0.3",
"## Date: 16.07.2014",
}
   
PSDunkel = {
      ["nitrogenSolid"] = true,
      ["phosphorSolid"] = true,
      ["potassiumSolid"] = true,
      ["npkSolid"] = true,
   };
 
local function Debug(printDebug,...)
	if false then
		local text, TITLE, VERSION = "","Marhus Mod",""
		for i = 1, select("#", ...) do
			if type(select(i, ...)) == "boolean" then
				text = text..(select(i, ...) and "true" or "false").." ";
			else text = text..(select(i, ...) or "nil").." "; end;
		end
		for i = 1, table.getn(metadata) do
			local nBeginn, nEnde = string.find(metadata[i],"## Title: ");
			if nEnde then TITLE = string.sub (metadata[i], nEnde); end;
			local nBeginn, nEnde = string.find(metadata[i],"## Version: ");
			if nEnde then VERSION = " v"..string.sub (metadata[i], nEnde); end;
		end;
		print(TITLE..VERSION..": "..text);
	end;
end;
 
AllInOneSilo = {};

local AllInOneSilo_mt = Class(AllInOneSilo, Object);

InitObjectClass(AllInOneSilo, "AllInOneSilo");

function AllInOneSilo.onCreate(id)
	local trigger = AllInOneSilo:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(trigger);
    trigger:load(id);
    trigger:register(true);
	
	--print("created AllInOneSilo, id: ", id);
end;

function AllInOneSilo:new(isServer, isClient)
	local self = Object:new(isServer, isClient, AllInOneSilo_mt);
	self.siloTriggerfillDoneDirtyFlag = self:getNextDirtyFlag();
    return self;
end;

function AllInOneSilo:load(id)
			
	self.FillTypes = {};
    local SiloFillTypes = getUserAttribute(id, "FillTypes");
    if SiloFillTypes ~= nil and SiloFillTypes ~= "" then
        local types = Utils.splitString(" ", SiloFillTypes);
        for _,v in pairs(types) do
            local FillTypeInt = Fillable.fillTypeNameToInt[v];
            if FillTypeInt ~= nil  then
                table.insert(self.FillTypes, FillTypeInt);
            else
                print("Warning: has invalid FillTypes '"..v.."'.");
            end;
        end;
	else
		for _,v in pairs(Fillable.fillTypeNameToInt) do
			if v ~= Fillable.FILLTYPE_UNKNOWN then
				table.insert(self.FillTypes, v);
			end;
		end;
    end;
	
	self.SiloBuyAuto = Utils.getNoNil(getUserAttribute(id, "SiloBuyAuto"), 2);
	if self.SiloBuyAuto ~= 1 and self.SiloBuyAuto ~= 2 and self.SiloBuyAuto ~= 3 then
		self.SiloBuyAuto = 2;
	elseif self.SiloBuyAuto == 3 then
		self.OrgSiloBuyAuto = 3 ;
		self.SiloBuyAuto = 1;
	end;
		
	if self.SiloBuyAuto == 2 or self.OrgSiloBuyAuto then
		local priceMultiplers = getUserAttribute(id, "priceMultiplers");
		if priceMultiplers ~= nil then
			local Multiplers = Utils.splitString(" ", priceMultiplers);
			self.priceMultiplers = {};
			for i = 1 , table.getn(self.FillTypes) do
				local multipler = 1;
				if table.getn(Multiplers) == 1 then
					multipler = Multiplers[1];
				elseif Multiplers[i] then
					multipler = Multiplers[i];
				end	;
				self.priceMultiplers[self.FillTypes[i]] = multipler;
				Debug(true,string.format("load %s Multipler %s",Fillable.fillTypeIndexToDesc[self.FillTypes[i]].nameI18N,tostring(multipler)));
			end;
		end;
	end;
	
	self.OnlyFillFromAir = Utils.getNoNil(getUserAttribute(id, "OnlyFillFromAir"), true);
	self.reverseDifficulty = getUserAttribute(id, "reverseDifficulty");	
	
	local trigger = SiloTrigger:new(g_server ~= nil, g_client ~= nil);
	local index = g_currentMission:addOnCreateLoadedObject(trigger);
	trigger:load(id);
	trigger:register(true);
	if trigger.isServer then
		for i=1, table.getn(trigger.triggerIds) do
			removeTrigger(trigger.triggerIds[i]);
		end;
	end;
	trigger.triggerIds = {};

	local triggerRoot = Utils.indexToObject(id, getUserAttribute(id, "triggerIndex"));
	if triggerRoot == nil then
		triggerRoot = id;
	end;

	table.insert(trigger.triggerIds, triggerRoot);
	addTrigger(triggerRoot, "triggerCallback", self);
	for i=1, 3 do
		local child = getChildAt(triggerRoot, i-1);
		table.insert(trigger.triggerIds, child);
		addTrigger(child, "triggerCallback", self);
	end;

	trigger.fillType = self.FillTypes[1];
	self.Trigger = trigger;
	self.Ori_update = self.Trigger.update;
	function self.Trigger:update(dt) end;
	
	self.PSOrginal = trigger.dropParticleSystems;
	local psData = {};
	psData.psFile = "map/particleSystems/particleLongDuenger.i3d";
	psData.posX, psData.posY, psData.posZ = self.PSOrginal.posX,self.PSOrginal.posY,self.PSOrginal.posZ;
    self.PSDunkel = {};
    Utils.loadParticleSystemFromData(psData, self.PSDunkel, nil, false, nil, g_currentMission.baseDirectory, id);
	
	self.SelectetFillType = 1;
		
end;
  
function AllInOneSilo:delete()
	AllInOneSilo:superClass().delete(self);
	if self.PSOrginal and self.PSOrginal ~= self.Trigger.dropParticleSystems then 
		Utils.deleteParticleSystem(self.PSOrginal);
    end;
	if self.PSDunkel and self.PSDunkel ~= self.Trigger.dropParticleSystems then
		Utils.deleteParticleSystem(self.PSDunkel);
	end;
	if not self.isServer then
        for i=1, table.getn(self.Trigger.triggerIds) do
            removeTrigger(self.Trigger.triggerIds[i]);
        end
    end
end;
  
function AllInOneSilo:readStream(streamId, connection)
	AllInOneSilo:superClass().readStream(self, streamId);
	if connection:getIsServer() then
		self.SelectetFillType = streamReadInt8(streamId);
		self.SiloBuyAuto = streamReadInt8(streamId);
		self.IsFilling = streamReadBool(streamId);
	end;
end;

function AllInOneSilo:writeStream(streamId, connection)
	AllInOneSilo:superClass().writeStream(self, streamId);
	if not connection:getIsServer() then
		streamWriteInt8(streamId, self.SelectetFillType);
		streamWriteInt8(streamId, self.SiloBuyAuto);
		streamWriteBool(streamId, self.IsFilling);
	end;
end;

function AllInOneSilo:readUpdateStream(streamId, timestamp, connection)
	AllInOneSilo:superClass().readUpdateStream(self, streamId, timestamp, connection);
	if connection:getIsServer() then
        self.Trigger.fillDone = streamReadBool(streamId);
	end;
end;
  
function AllInOneSilo:writeUpdateStream(streamId, connection, dirtyMask)
	AllInOneSilo:superClass().writeUpdateStream(self, streamId, connection, dirtyMask);
	if not connection:getIsServer() then
         streamWriteBool(streamId, self.Trigger.fillDone);
    end;
end;
 
function AllInOneSilo:update(dt)
	
	local trailer = self.Trigger.siloTrailer;
	
	if g_currentMission:getIsClient() then
		if self.Trigger.fill >= 4 and trailer ~= nil then
				
			if trailer:getIsActiveForInput(false) then	
				
				local SelectetFillType = self.SelectetFillType;
				if InputBinding.hasEvent(InputBinding.ALLINONESILO_FRUCHTS) then
					SelectetFillType = SelectetFillType + 1;
				end;
				
				self:SetFillType(SelectetFillType); -- Suche next FillType
				
				---- Text Frucht Sorte ----
				local t = Fillable.fillTypeIndexToDesc[self.Trigger.fillType].nameI18N;
				local v,s = 0,"["..g_i18n:getText("fluid_unit_short").."]";
				if self.SiloBuyAuto == 1 then
					v = g_currentMission:getSiloAmount(self.Trigger.fillType);
				elseif self.SiloBuyAuto == 2 then
					local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1);
					if self.reverseDifficulty then
						difficultyMultiplier = math.floor(Utils.lerp(1, 4, (g_currentMission.missionStats.difficulty - 1) / 2))
					end
					local priceMultipler = 1;
					if self.priceMultiplers and self.priceMultiplers[self.Trigger.fillType] then
						priceMultipler = self.priceMultiplers[self.Trigger.fillType];
						Debug(true,string.format("update %s Multipler %s",Fillable.fillTypeIndexToDesc[self.Trigger.fillType].nameI18N,tostring(priceMultipler)));
					end;
					v = (Fillable.fillTypeIndexToDesc[self.Trigger.fillType].pricePerLiter * priceMultipler * difficultyMultiplier) * 1000;
					s = g_i18n:getText("PricePerTon");
					
				end;
				
				g_currentMission:addHelpButtonText(string.format("%d %s %s",v,s,t),InputBinding.ALLINONESILO_FRUCHTS);
				
				---- Text Silo/Kaufen ----
				if self.OrgSiloBuyAuto then
					if self.SiloBuyAuto == 1 then
						g_currentMission:addHelpButtonText(g_i18n:getText("AioSilos") ,InputBinding.ALLINONESILO_SILOBUYS);
					elseif self.SiloBuyAuto == 2 then
						g_currentMission:addHelpButtonText(g_i18n:getText("Button_Buy") ,InputBinding.ALLINONESILO_SILOBUYS);
					end 
					if InputBinding.hasEvent(InputBinding.ALLINONESILO_SILOBUYS) then
						self:SetSiloBuy(3 - self.SiloBuyAuto, noEventSend);
					end;
				end;
				
				---- Text Start/Stop ---
				if trailer:allowFillType(self.Trigger.fillType, false) and not self.Trigger.fillDone then
					
					if self.SiloBuyAuto ~= 1 or g_currentMission:getSiloAmount(self.Trigger.fillType) > 0 then
						if self.IsFilling then
							g_currentMission:addHelpButtonText(g_i18n:getText("siloStopFilling"),InputBinding.ALLINONESILO_STARTS);
						else
							g_currentMission:addHelpButtonText(g_i18n:getText("siloStartFilling"),InputBinding.ALLINONESILO_STARTS);
						end;
						if InputBinding.hasEvent(InputBinding.ALLINONESILO_STARTS) then
							self:SetIsFilling(not self.IsFilling);
						end; 
					end;
				else
					self:SetIsFilling(false);
				end;						
			end;
		end;
	end;
	
	if g_currentMission:getIsServer()  then
		
		if self.Trigger.fill >= 4 and trailer ~= nil then
			
			if self.IsFilling and not self.Trigger.fillDone then
				
				local fillLevel = trailer:getFillLevel(self.Trigger.fillType);
				if self.SiloBuyAuto == 1 then -- Silo 
					local siloAmount = g_currentMission:getSiloAmount(self.Trigger.fillType);
					if siloAmount > 0 and trailer:allowFillType(self.Trigger.fillType, false) then
						local deltaFillLevel = math.min(self.Trigger.fillLitersPerSecond*0.001*dt, siloAmount);
						trailer:setFillLevel(fillLevel+deltaFillLevel, self.Trigger.fillType);
						local newFillLevel = trailer:getFillLevel(self.Trigger.fillType);
	  
						if fillLevel ~= newFillLevel then
							g_currentMission:setSiloAmount(self.Trigger.fillType, math.max(siloAmount-(newFillLevel-fillLevel), 0));
							self.Trigger:startFill();
						else
							self:SetfillDone(); -- trailer is full	
						end;
					else
						self:SetfillDone(); -- silo is empty or trailer does not support fill type
					end;
				elseif self.SiloBuyAuto == 2 then	-- Kaufen											
					if trailer:allowFillType(self.Trigger.fillType, false) then
						local deltaFillLevel = self.Trigger.fillLitersPerSecond*0.001*dt;
						trailer:setFillLevel(fillLevel+deltaFillLevel, self.Trigger.fillType);
						local newFillLevel = trailer:getFillLevel(self.Trigger.fillType);

						if fillLevel ~= newFillLevel then
							local delta = math.max((newFillLevel-fillLevel), 0);
							local fillTypeDesc = Fillable.fillTypeIndexToDesc[self.Trigger.fillType]
							if fillTypeDesc ~= nil then
								local difficultyMultiplier = math.max(2 * (3 - g_currentMission.missionStats.difficulty), 1);
								if self.reverseDifficulty then
									difficultyMultiplier = math.floor(Utils.lerp(1, 4, (g_currentMission.missionStats.difficulty - 1) / 2))
								end
								local priceMultipler = 1
								if self.priceMultiplers and self.priceMultiplers[self.Trigger.fillType] then
									priceMultipler = self.priceMultiplers[self.Trigger.fillType]
								end
								local price = delta*fillTypeDesc.pricePerLiter * priceMultipler * difficultyMultiplier;
								g_currentMission:addSharedMoney(-price, "other");
							end;
							self.Trigger:startFill();
						else
							self:SetfillDone(); -- trailer is full
						end;
					else
						self:SetfillDone(); -- trailer does not support fill type
					end;
				end;
			else
				self:SetIsFilling(false)
			end;
		else
			self:SetIsFilling(false)
		end;
	end;
	
end;

function AllInOneSilo:updateTick(dt)
end;

function AllInOneSilo:SetFillType(SelectetFillType, noEventSend)
	
	if SelectetFillType > table.getn(self.FillTypes) then SelectetFillType = 1 end;
	local trailer = self.Trigger.siloTrailer;
	if trailer ~= nil then
		local i = 1;
		repeat
			if trailer:allowFillType(self.FillTypes[SelectetFillType], false) then					
				self.Trigger.fillType = self.FillTypes[SelectetFillType];
				break;
			else
				SelectetFillType = SelectetFillType + 1;
				if SelectetFillType > table.getn(self.FillTypes) then SelectetFillType = 1 end;
			end
			i = i + 1;
		until i > table.getn(self.FillTypes);
		if PSDunkel[Fillable.fillTypeIntToName[self.FillTypes[SelectetFillType]]] then
			self.Trigger.dropParticleSystems = self.PSDunkel;
		else
			self.Trigger.dropParticleSystems = self.PSOrginal;
		end
	end
	
	AllInOneSiloSelectetEvent.sendEvent(self, SelectetFillType, noEventSend);
	self.SelectetFillType = SelectetFillType;
end;

function AllInOneSilo:SetSiloBuy(SiloBuy, noEventSend)
		
	AllInOneSiloSiloBuyEvent.sendEvent(self, SiloBuy, noEventSend);
	self.Trigger.fillDone = false;
	self.Trigger:stopFill();
	self.SiloBuyAuto = SiloBuy;
end;

function AllInOneSilo:SetIsFilling(IsFilling, noEventSend)

	AllInOneSiloSetIsFillingEvent.sendEvent(self, IsFilling, noEventSend);
	self.IsFilling = IsFilling;
	if not self.IsFilling and self.Trigger.isFilling then
		self.Trigger:stopFill();
	end;
end;

function AllInOneSilo:SetfillDone()
	self.Trigger.fillDone = true;
	self.Trigger:stopFill();
	self:raiseDirtyFlags(self.siloTriggerfillDoneDirtyFlag);
end;
 
function AllInOneSilo:triggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
	
	if self.Trigger.isEnabled then
		local trailer = g_currentMission.objectToTrailer[otherShapeId];
        if trailer ~= nil and ((trailer.getAllowFillFromAir ~= nil and trailer:getAllowFillFromAir()) or not self.OnlyFillFromAir) then
            if onEnter then
                self.Trigger.fill = self.Trigger.fill+1;
                self.Trigger.siloTrailer = trailer;
                self.Trigger.fillDone = false;
            elseif onLeave then
                self.Trigger.fill = math.max(self.Trigger.fill-1, 0);
                self.Trigger.siloTrailer = nil;
                self.Trigger.fillDone = false;
                self.Trigger:stopFill();
            end;
        end;
    end;
end;

g_onCreateUtil.addOnCreateFunction("AllInOneSilo", AllInOneSilo.onCreate);
 
 
 -- Event set FillType --
 
AllInOneSiloSelectetEvent = {};
AllInOneSiloSelectetEvent_mt = Class(AllInOneSiloSelectetEvent, Event);

InitEventClass(AllInOneSiloSelectetEvent, "AllInOneSiloSelectetEvent");

function AllInOneSiloSelectetEvent:emptyNew()
    local self = Event:new(AllInOneSiloSelectetEvent_mt);
    return self;
end;
    
function AllInOneSiloSelectetEvent:new(object, Selectet)
	local self = AllInOneSiloSelectetEvent:emptyNew()
	self.object = object;
	self.Selectet = Selectet;
	return self;
end;

function AllInOneSiloSelectetEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.Selectet = streamReadInt8(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function AllInOneSiloSelectetEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.Selectet);
end;

function AllInOneSiloSelectetEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	if self.object ~= nil then
		self.object:SetFillType(self.Selectet, true);
	end;
end;

function AllInOneSiloSelectetEvent.sendEvent(silo, Selectet, noEventSend)
	if Selectet ~= silo.SelectetFillType then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(AllInOneSiloSelectetEvent:new(silo, Selectet), nil, nil, silo);
			else
				g_client:getServerConnection():sendEvent(AllInOneSiloSelectetEvent:new(silo, Selectet));
			end;
		end;
	end;
end;

 -- Event set SiloBuy --
 
AllInOneSiloSiloBuyEvent = {};
AllInOneSiloSiloBuyEvent_mt = Class(AllInOneSiloSiloBuyEvent, Event);

InitEventClass(AllInOneSiloSiloBuyEvent, "AllInOneSiloSiloBuyEvent");

function AllInOneSiloSiloBuyEvent:emptyNew()
    local self = Event:new(AllInOneSiloSiloBuyEvent_mt);
    return self;
end;
    
function AllInOneSiloSiloBuyEvent:new(object, SiloBuy)
	local self = AllInOneSiloSiloBuyEvent:emptyNew()
	self.object = object;
	self.SiloBuy = SiloBuy;
	return self;
end;

function AllInOneSiloSiloBuyEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.SiloBuy = streamReadInt8(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function AllInOneSiloSiloBuyEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.SiloBuy);
end;

function AllInOneSiloSiloBuyEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	if self.object ~= nil then
		self.object:SetSiloBuy(self.SiloBuy, true);
	end;
end;

function AllInOneSiloSiloBuyEvent.sendEvent(silo, SiloBuy, noEventSend)
	if SiloBuy ~= silo.SiloBuyAuto then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(AllInOneSiloSiloBuyEvent:new(silo, SiloBuy), nil, nil, silo);
			else
				g_client:getServerConnection():sendEvent(AllInOneSiloSiloBuyEvent:new(silo, SiloBuy));
			end;
		end;
	end;
end;

 -- Event Set IsFilling --
 
AllInOneSiloSetIsFillingEvent = {};
AllInOneSiloSetIsFillingEvent_mt = Class(AllInOneSiloSetIsFillingEvent, Event);

InitEventClass(AllInOneSiloSetIsFillingEvent, "AllInOneSiloSetIsFillingEvent");

function AllInOneSiloSetIsFillingEvent:emptyNew()
    local self = Event:new(AllInOneSiloSetIsFillingEvent_mt);
    return self;
end;
    
function AllInOneSiloSetIsFillingEvent:new(object, SetIsFilling)
	local self = AllInOneSiloSetIsFillingEvent:emptyNew()
	self.object = object;
	self.SetIsFilling = SetIsFilling;
	return self;
end;

function AllInOneSiloSetIsFillingEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.SetIsFilling = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function AllInOneSiloSetIsFillingEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.SetIsFilling);
end;

function AllInOneSiloSetIsFillingEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	if self.object ~= nil then
		self.object:SetIsFilling(self.SetIsFilling, true);
	end;
end;

function AllInOneSiloSetIsFillingEvent.sendEvent(silo, SetIsFilling, noEventSend)
	if SetIsFilling ~= silo.IsFilling then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(AllInOneSiloSetIsFillingEvent:new(silo, SetIsFilling), nil, nil, silo);
			else
				g_client:getServerConnection():sendEvent(AllInOneSiloSetIsFillingEvent:new(silo, SetIsFilling));
			end;
		end;
	end;
end;