--
-- fillerArm
-- Specialization for fillerArm
--
-- @author upsidedown
-- @date  13.07.2013


fillerArm = {};

function fillerArm.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;


function fillerArm:load(xmlFile)
		
		self.getIsPowerTakeoffActive = fillerArm.getIsPowerTakeoffActive;
		

		local x, y = getScreenModeInfo(getScreenMode())
		local aspectRatio = x / y


		self.fillerArmNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manureFillerArm#index"));
		--self.fillerArmTarget = nil;
		self.fillerArmReadyToOverload = false;
		self.fillerArmOverloadActive = false;
		self.manschetteCloseBy = false;
		self.fillerArmBlinkTimer = 0;
		self.fillerArmBlinkTimerSign = 1.0;
		
		local hudFactor = 0.95
		local path = Utils.getFilename("overlays/Befuellung_moeglich.dds", self.baseDirectory);
		self.fillerArmReadyOverlay = Overlay:new("hudReady", path, g_currentMission.fruitSymbolX, g_currentMission.fruitSymbolY+0.11, g_currentMission.fruitSymbolSizeX*hudFactor, g_currentMission.fruitSymbolSizeY*hudFactor, g_currentMission.fruitSymbolSizeX * aspectRatio*hudFactor, g_currentMission.fruitSymbolSizeY * aspectRatio*hudFactor); 
		path = Utils.getFilename("overlays/Befuellung_laeuft.dds", self.baseDirectory);
		self.fillerArmActiveOverlay = Overlay:new("hudActive", path, g_currentMission.fruitSymbolX, g_currentMission.fruitSymbolY+0.11, g_currentMission.fruitSymbolSizeX*hudFactor, g_currentMission.fruitSymbolSizeY*hudFactor, g_currentMission.fruitSymbolSizeX * aspectRatio*hudFactor, g_currentMission.fruitSymbolSizeY * aspectRatio*hudFactor); 
		path = Utils.getFilename("overlays/Kontakt.dds", self.baseDirectory);
		self.fillerArmContact = Overlay:new("hudActive", path, g_currentMission.fruitSymbolX, g_currentMission.fruitSymbolY+0.11, g_currentMission.fruitSymbolSizeX*hudFactor, g_currentMission.fruitSymbolSizeY*hudFactor, g_currentMission.fruitSymbolSizeX * aspectRatio*hudFactor, g_currentMission.fruitSymbolSizeY * aspectRatio*hudFactor); 
		path = Utils.getFilename("overlays/Befuellkreislauf_Blinkend.dds", self.baseDirectory);
		self.fillerArmActiveBlinkOverlay = Overlay:new("hudActive", path, g_currentMission.fruitSymbolX, g_currentMission.fruitSymbolY+0.11, g_currentMission.fruitSymbolSizeX*hudFactor, g_currentMission.fruitSymbolSizeY*hudFactor, g_currentMission.fruitSymbolSizeX * aspectRatio*hudFactor, g_currentMission.fruitSymbolSizeY * aspectRatio*hudFactor); 
		
		-- for anim = 6,10,1 do
				-- self:toggle(anim,false);
		-- end
		
end;

function fillerArm:update(dt)	
    if self:getIsActiveForInput(true) then
		if self.fillerArmReadyToOverload then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
				self.fillerArmOverloadActive = not self.fillerArmOverloadActive;
				if g_server ~= nil then
					g_server:broadcastEvent(fillerArmOverload_Event:new(self, self.fillerArmOverloadActive), nil, nil, self);
				else
					g_client:getServerConnection():sendEvent(fillerArmOverload_Event:new(self, self.fillerArmOverloadActive));
				end;			
			end;
		end
	end
end;

function fillerArm:updateTick(dt)	
        self.manschetteInRange = false;
		self.manschetteCloseBy = false;
        local nearestDistance = 0.5;
        local px, py, pz = getWorldTranslation(self.fillerArmNode);
        for i=1, table.getn(g_currentMission.attachables) do
            if g_currentMission.attachables[i].manschetteNode2 ~= nil then
				local vx, vy, vz = getWorldTranslation(g_currentMission.attachables[i].manschetteNode1);
				local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
				if distance < nearestDistance then--closer than 0.5m: nearby HUD
					self.manschetteCloseBy = true;
					nearestDistance = distance;
				
					if nearestDistance < 0.1 then--within 10cm: contact
						--local attachable = g_currentMission.attachables[i];		
						--renderText(.402+ 0.085,0.5238 + 0.010,0.022, "in range");
						self.manschetteInRange = true;
						
						self.manschette = {};
						self.manschette.vehicle = g_currentMission.attachables[i];
						self.manschette.manschetteNode = g_currentMission.attachables[i].manschetteNode1;					
					end;
				end
			end;
        end;
		
		local delta = 0;
		self.fillerArmReadyToOverload = false;
		if self.manschetteInRange then
			if self.manschette.vehicle.currentFillType == Fillable.FILLTYPE_LIQUIDMANURE then
				if self.capacity ~= self.fillLevel then
					if self.manschette.vehicle.fillLevel > 0 then
						self.fillerArmReadyToOverload = true;
						if self.fillerArmOverloadActive then 
							delta = self.fillLitersPerSecond*dt/770;
							if self.manschette.vehicle.fillLevel < delta then
							delta = self.manschette.vehicle.fillLevel;
							end
							if self.fillLevel + delta > self.capacity then
								delta = self.capacity - self.fillLevel
							end
						end						
					end
				end
			end
		end
		
		if delta > 0 then
			self:setFillLevel(self.fillLevel + delta,self.manschette.vehicle.currentFillType)
			self.manschette.vehicle:setFillLevel(self.manschette.vehicle.fillLevel - delta,self.manschette.vehicle.currentFillType)
		else		    
			self.fillerArmOverloadActive = false;
		end
		
		
	
	if self:getIsActive() then
		self.fillerArmBlinkTimer = self.fillerArmBlinkTimer + self.fillerArmBlinkTimerSign*dt;
		if self.fillerArmBlinkTimer > 750 then
			self.fillerArmBlinkTimerSign = -1.0;
		elseif self.fillerArmBlinkTimer < 0 then
			self.fillerArmBlinkTimerSign = 1.0;
		end
	end;
	
end;

--function fillerArm:fertilizerInRange(dt)
--end;

function fillerArm:delete()
	
end;

function fillerArm:mouseEvent(posX, posY, isDown, isUp, button)
end;

function fillerArm:keyEvent(unicode, sym, modifier, isDown)
end;

function fillerArm:draw()
	if self.manschetteCloseBy then
		if self.manschetteInRange then

			if self.fillerArmReadyToOverload then
				if self.fillerArmOverloadActive then
					self.fillerArmActiveOverlay:render();
					g_currentMission:addHelpButtonText(g_i18n:getText("fillerArmOverload"), InputBinding.IMPLEMENT_EXTRA3);
					if self.fillerArmBlinkTimerSign > 0 then
						self.fillerArmActiveBlinkOverlay:render();
					end;
					
					
					--g_currentMission:addHelpButtonText(g_i18n:getText("OVERCHARGE_3"), InputBinding.IMPLEMENT_EXTRA3);
				else
					g_currentMission:addHelpButtonText(g_i18n:getText("fillerArmOverload"), InputBinding.IMPLEMENT_EXTRA3);
					self.fillerArmActiveOverlay:render();
				end;
			else
				self.fillerArmContact:render();
			end;
		else
			self.fillerArmReadyOverlay:render();
		end;
		
		
	end;
		-- self.fillerArmReadyOverlay
		-- self.fillerArmActiveOverlay
		-- self.fillerArmContact
		-- self.fillerArmActiveBlinkOverlay	
end;

function fillerArm:onAttach()
end; 	

function fillerArm:onDetach()
end;



function fillerArm:writeStream(streamId, connection)
    streamWriteBool(streamId, self.fillerArmOverloadActive);
	
end;


function fillerArm:readStream(streamId, connection)
    self.fillerArmOverloadActive = streamReadBool(streamId);
   
end;




function fillerArm:getIsPowerTakeoffActive()
	return self.isTurnedOn or self.fillerArmOverloadActive;
end;



fillerArmOverload_Event = {};
  fillerArmOverload_Event_mt = Class(fillerArmOverload_Event, Event);
  
 
  InitEventClass(fillerArmOverload_Event, "fillerArmOverload_Event");
  
  function fillerArmOverload_Event:emptyNew()
      local self = Event:new(fillerArmOverload_Event_mt);
      return self;
  end;
  
  function fillerArmOverload_Event:new(object, data)
      local self = fillerArmOverload_Event:emptyNew()
      self.data = data;
	  
      self.object = object;
      return self;
  end;
  
  function fillerArmOverload_Event:readStream(streamId, connection)
      local id = streamReadInt32(streamId);
      self.data = streamReadBool(streamId);
      
	  
	  self.object = networkGetObject(id);
      self:run(connection);
  end;
  
  function fillerArmOverload_Event:writeStream(streamId, connection)
      streamWriteInt32(streamId, networkGetObjectId(self.object));
	  streamWriteBool(streamId, self.data);

  end;
  
  function fillerArmOverload_Event:run(connection)
	  self.object.fillerArmOverloadActive = self.data;
	  
	  
      if not connection:getIsServer() then
          g_server:broadcastEvent(fillerArmOverload_Event:new(self.object, self.data), nil, connection, self.object);
      end;
  end;
  