RoueEvent = {};
RoueEvent_mt = Class(RoueEvent, Event);

InitEventClass(RoueEvent, "RoueEvent");

function RoueEvent:emptyNew()
    local self = Event:new(RoueEvent_mt);
    self.className="RoueEvent";
    return self;
end;

function RoueEvent:new(object, data)
    local self = RoueEvent:emptyNew()
    self.object = object;
	self.data = data;
    return self;
end;

function RoueEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);
	
	self.data = streamReadInt8(streamId);
	self.object.changeWheel = self.data;
	if not connection:getIsServer() then
        g_server:broadcastEvent(RoueEvent:new(self.object, self.data), nil, connection, self.object);
    end;
end;

function RoueEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.data);
end;


function RoueEvent.sendEvent(vehicle, data)
	if g_server ~= nil then
		g_server:broadcastEvent(RoueEvent:new(vehicle, data), nil, nil, vehicle);
	else
		g_client:getServerConnection():sendEvent(RoueEvent:new(vehicle, data));
	end;
end;

