--
-- Addon for moveable Farmerarm
--
-- @author Aranea
-- @date 01/02/2013
-- 

FarmerArm = {};

function FarmerArm.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function FarmerArm:load(savegame)
    self.armNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.characterNode#armIndex"));
end;

function FarmerArm:postLoad(xmlFile)
    if self.armNode ~= nil then
        setVisibility(self.armNode, false);
    end;
end;

function FarmerArm:delete()
    -- if self.armNode ~= nil then
          -- delete(self.armNode);
    -- end;
end;

function FarmerArm:readStream(streamId, connection)
end;

function FarmerArm:writeStream(streamId, connection)
end;


function FarmerArm:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FarmerArm:keyEvent(unicode, sym, modifier, isDown)
end;

function FarmerArm:update(dt)
end;

function FarmerArm:updateTick(dt)
end;

function FarmerArm:draw()
end;

function FarmerArm:onEnter()
    
    if self.armNode ~= nil then
        setVisibility(self.armNode, true);
    end;
    
end;

function FarmerArm:onLeave()
    if self.armNode ~= nil then
        if self.disableCharacterOnLeave then
            setVisibility(self.armNode, false);
        else
            setVisibility(self.armNode, true);
        end;
    end;

end;
