OilChangeEvent = {};
OilChangeEvent_mt = Class(OilChangeEvent, Event);

InitEventClass(OilChangeEvent, "OilChangeEvent");

function OilChangeEvent:emptyNew()
    local self = Event:new(OilChangeEvent_mt);
    self.className="OilChangeEvent";
    return self;
end;

function OilChangeEvent:new(vehicle, oilChangeVehicle)
    local self = OilChangeEvent:emptyNew()
    self.vehicle = vehicle;
    self.oilChangeVehicle = oilChangeVehicle;
    return self;
end;

function OilChangeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    local attacherId = streamReadInt32(streamId);
    self.oilChangeVehicle = networkGetObject(attacherId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function OilChangeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
    streamWriteInt32(streamId, networkGetObjectId(self.oilChangeVehicle));
end;

function OilChangeEvent:run(connection)
    self.vehicle:changeOil(self.oilChangeVehicle, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(OilChangeEvent:new(self.vehicle, self.oilChangeVehicle), nil, connection, self.object);
    end;
end;


function OilChangeEvent.sendEvent(vehicle, oilChangeVehicle, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(OilChangeEvent:new(vehicle, oilChangeVehicle), nil, nil, vehicle);
        else
            g_client:getServerConnection():sendEvent(OilChangeEvent:new(vehicle, oilChangeVehicle));
        end;
    end;
end;
