--
-- AdditionalBackupCam
-- Specialization for AdditionalBackupCam
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:        03/03/11
-- @version:    v1.1
-- @history:    v1.0 - initial implementation
--
-- free for noncommerical-usage
--

AdditionalBackupCam = {};

function AdditionalBackupCam.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function AdditionalBackupCam:load(savegame)
    self.additionalCams = {};

    local i = 0;
    while true do        
        local key = string.format("vehicle.backupCams.cam(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local cam = VehicleCamera:new(self);
        cam:loadFromXML(xmlFile, key);
        table.insert(self.additionalCams, cam);
        i = i + 1;
    end;
    
    self.camAttacherBackup = nil;
end;

function AdditionalBackupCam:delete()
end;

function AdditionalBackupCam:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AdditionalBackupCam:keyEvent(unicode, sym, modifier, isDown)
end;

function AdditionalBackupCam:update(dt)
end;

function AdditionalBackupCam:draw()
end;

function AdditionalBackupCam:onAttach(attacherVehicle)
    self.camAttacherBackup = attacherVehicle;
    if attacherVehicle.addBackupCam ~= nil then
        for _,cam in pairs(self.additionalCams) do
            attacherVehicle:addBackupCam(cam);
        end;
    end;
end;

function AdditionalBackupCam:onDetach()
    if self.camAttacherBackup.removeBackupCam ~= nil then
        for _, cam in pairs(self.additionalCams) do
            self.camAttacherBackup:removeBackupCam(cam);
        end;
    end;
end;

