-- indoorSound15.lua
-- Author RivalBomb
--
-- 06/09/15


indoorSound15 = {};

function indoorSound15.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations); -- and SpecializationUtil.hasSpecialization(TurnOnVehicle, specializations)
end;

function indoorSound15:load(xmlFile)
	self.swapSounds = SpecializationUtil.callSpecializationsFunction("swapSounds");

	--self.stopMotorSoundsOnThreshing = true;	-- set this to false if the normal motor sounds should be played while threshing
	self.soundSwitched = false;
	self.volume = 1;
	
	self.motorStartSoundOutside = Utils.loadSample(xmlFile, {}, "vehicle.motorStartSound", nil, self.baseDirectory, self.components[1].node);
	self.motorIdleSoundOutside = Utils.loadSample(xmlFile, {}, "vehicle.motorSound", nil, self.baseDirectory, self.components[1].node);
	self.motorSoundRunOutside = Utils.loadSample(xmlFile, {}, "vehicle.motorSoundRun", nil, self.baseDirectory, self.components[1].node);
	self.motorStopSoundOutside = Utils.loadSample(xmlFile, {}, "vehicle.motorStopSound", nil, self.baseDirectory, self.components[1].node);
	--self.threshingStartSoundOutside = Utils.loadSample(xmlFile, {}, "vehicle.threshingStartSound", nil, self.baseDirectory, self.components[1].node);
	--self.threshingSoundOutside = Utils.loadSample(xmlFile, {}, "vehicle.threshingSound", nil, self.baseDirectory, self.components[1].node);
	--self.threshingStopSoundOutside = Utils.loadSample(xmlFile, {}, "vehicle.threshingStopSound", nil, self.baseDirectory, self.components[1].node);

	self.motorStartSoundInside = Utils.loadSample(xmlFile, {}, "vehicle.motorStartSoundInside", nil, self.baseDirectory, self.components[1].node);
	self.motorIdleSoundInside = Utils.loadSample(xmlFile, {}, "vehicle.motorSoundInside", nil, self.baseDirectory, self.components[1].node);
	self.motorSoundRunInside = Utils.loadSample(xmlFile, {}, "vehicle.motorSoundRunInside", nil, self.baseDirectory, self.components[1].node);
	self.motorStopSoundInside = Utils.loadSample(xmlFile, {}, "vehicle.motorStopSoundInside", nil, self.baseDirectory, self.components[1].node);
	self.threshingStartSoundInside = Utils.loadSample(xmlFile, {}, "vehicle.threshingStartSoundInside", nil, self.baseDirectory, self.components[1].node);
	self.threshingSoundInside = Utils.loadSample(xmlFile, {}, "vehicle.threshingSoundInside", nil, self.baseDirectory, self.components[1].node);
	self.threshingStopSoundInside = Utils.loadSample(xmlFile, {}, "vehicle.threshingStopSoundInside", nil, self.baseDirectory, self.components[1].node);
end;

function indoorSound15:delete()
end;

function indoorSound15:mouseEvent(posX, posY, isDown, isUp, button)
end;

function indoorSound15:keyEvent(unicode, sym, modifier, isDown)
end;

function indoorSound15:update(dt)
	if self.isEntered then
		if g_currentMission.driveControl ~= nil and g_currentMission.driveControl.useModules.inDoorSound then
			g_currentMission.driveControl.useModules.inDoorSound = false;
		end;
	end;
	if self:getIsActive() then
		--[[if self.stopMotorSoundsOnThreshing then
			if self:getIsTurnedOn() then
				if self.volume > 0 then
					self.volume = self.volume - dt/1000;
				else
					self.volume = 0;
				end;
				Utils.setSampleVolume(self.sampleMotor, self.sampleMotor.volume*self.volume);
				Utils.setSampleVolume(self.sampleMotorRun, self.sampleMotorRun.volume*self.volume);
			else
				if self.volume < 1 then
					self.volume = self.volume + dt/1000;
				else
					self.volume = 1;
				end;
				Utils.setSampleVolume(self.sampleMotor, self.sampleMotor.volume*self.volume);
				Utils.setSampleVolume(self.sampleMotorRun, self.sampleMotorRun.volume*self.volume);
			end;
		end;]]
		if (self.cameras[self.camIndex].isInside) and (not self.soundSwitched) and (self.isEntered) then
			self:swapSounds("inside");
			self.soundSwitched = true;
		elseif (not self.cameras[self.camIndex].isInside and self.soundSwitched) or (self.isEntered == false and self.soundSwitched) then
			self:swapSounds("outside");
			self.soundSwitched = false;
		end;
	end;
	if self.isHired and not self.isEntered then
		self:swapSounds("outside");
		self.soundSwitched = false;
	end;
end;

function indoorSound15:updateTick(dt)
end;

function indoorSound15:draw()
end;

function indoorSound15:swapSounds(camInOut)
	--[[if Utils.isSamplePlaying(self.sampleThreshing) then
		Utils.stopSample(self.sampleThreshing, true);
	end;
	if Utils.isSamplePlaying(self.sampleThreshingStart) then
		Utils.stopSample(self.sampleThreshingStart, true);
	end;
	if Utils.isSamplePlaying(self.sampleThreshingStop) then
		Utils.stopSample(self.sampleThreshingStop, true);
	end;]]
	if Utils.isSamplePlaying(self.sampleMotor) then
		Utils.stopSample(self.sampleMotor, true);
	end;
	if Utils.isSamplePlaying(self.sampleMotorStart) then
		Utils.stopSample(self.sampleMotorStart, true);
	end;
	if Utils.isSamplePlaying(self.sampleMotorStop) then
		Utils.stopSample(self.sampleMotorStop, true);
	end;
	if Utils.isSamplePlaying(self.sampleMotorRun) then
		Utils.stopSample(self.sampleMotorRun, true);
	end;

	if camInOut == "outside" then
		-- self.sampleThreshingStart = self.threshingStartSoundOutside;
		-- self.sampleThreshingStop = self.threshingStopSoundOutside;
		-- self.sampleThreshing = self.threshingSoundOutside;
		self.sampleMotorStart = self.motorStartSoundOutside;
		self.sampleMotorStop = self.motorStopSoundOutside;
		self.sampleMotor = self.motorIdleSoundOutside;
		self.sampleMotorRun = self.motorSoundRunOutside;
	elseif camInOut == "inside" then
		-- self.sampleThreshingStart = self.threshingStartSoundInside;
		-- self.sampleThreshingStop = self.threshingStopSoundInside;
		-- self.sampleThreshing = self.threshingSoundInside;
		self.sampleMotorStart = self.motorStartSoundInside;
		self.sampleMotorStop = self.motorStopSoundInside;
		self.sampleMotor = self.motorIdleSoundInside;
		self.sampleMotorRun = self.motorSoundRunInside;
	end;
	if self.isClient and self.isEntered and self.isMotorStarted then
		-- if self:getIsTurnedOn() then
			-- Utils.playSample(self.sampleThreshing, 0, 0, nil);
		-- end;
		Utils.playSample(self.sampleMotor, 0,0,nil);
		Utils.playSample(self.sampleMotorRun, 0,0,nil);
	end;
	if self.isClient and not self.isEntered then
		Utils.stopSample(self.motorIdleSoundInside, true);
		Utils.stopSample(self.motorSoundRunInside, true);
		-- Utils.stopSample(self.threshingSoundInside, true);
	end;
end;