
-- Fendt900er
-- Specialization for Fendt900er mod
-- Date 14/03/2015
-- Copyright (C) Unguided


Fendt900er = {};

function Fendt900er.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Fendt900er:load(xmlFile)
	self.frontLinkageBottomArmRotNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.frontLinkageBottomArm#rotationNode"));
	setRotation(self.frontLinkageBottomArmRotNode, math.rad(-50), math.rad(0), math.rad(0)); 
end;

function Fendt900er:delete()
end;

function Fendt900er:readStream(streamId, connection)
end;

function Fendt900er:writeStream(streamId, connection)
end;

function Fendt900er:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Fendt900er:keyEvent(unicode, sym, modifier, isDown)
end;

function Fendt900er:update(dt)
end;

function Fendt900er:updateTick(dt)
end;

function Fendt900er:draw()
end;

function Fendt900er:onLeave()
end;

function Fendt900er:onEnter()
end;

function Fendt900er:attachImplement(implement)
	local jointType = implement.object.attacherJoint.jointType;
	local jointIndex = implement.jointDescIndex;

	if jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = math.max(self.implementCount - 1, 0);
		end;
		if jointIndex == 2 then
			setRotation(self.frontLinkageBottomArmRotNode, math.rad(0), math.rad(0), math.rad(0)); 
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILER then
		if jointIndex == 3 then
		end;
	elseif jointType == Vehicle.JOINTTYPE_TRAILERLOW then
		if jointIndex == 4 then
		end;
	end;

	self.updateJoint = true;
end;

function Fendt900er:detachImplement(implementIndex)
	local implement = self.attachedImplements[implementIndex];
	local jointIndex = implement.jointDescIndex;

	if implement.object.attacherJoint.jointType == Vehicle.JOINTTYPE_IMPLEMENT then
		if implement.object.needsLowering then
			self.implementCount = self.implementCount + 1;
		end;
		if jointIndex == 2 then
			setRotation(self.frontLinkageBottomArmRotNode, math.rad(-50), math.rad(0), math.rad(0)); 
		end;
	else
	end;
	
	self.updateJoint = true;
end;

function Fendt900er:validateAttacherJoint(implement, jointDesc, dt)
    if self.updateJoint then
        self.updateJoint = false;
        return true;
    end;
    return false;
end;
