mechanism = {};
mechanism.modDir = g_currentModDirectory;

local animator_input;

function mechanism.prerequisitesPresent(specializations)
    return true;
end;

function mechanism:load(xmlFile)
	local i = 0;
	self.rotatorsTable = {};
	while true do
		local stringRotatorParts = string.format("vehicle.rotators.rotatorPart(%d)#", i);
		local rotatorIndex = Utils.indexToObject(self.components, getXMLString(self.xmlFile, stringRotatorParts .. "index"));
		if rotatorIndex ~= nil then
			local rotatorInfo = {};
			rotatorInfo.rotatorIndex = rotatorIndex;
			rotatorInfo.rotatorAxis = Utils.getNoNil(getXMLFloat(self.xmlFile, stringRotatorParts .. "rotatorAxis"), 1);
			rotatorInfo.rotatorSpeed = Utils.getNoNil(getXMLFloat(self.xmlFile, stringRotatorParts .. "rotatorSpeed"), 1);
			rotatorInfo.rotatorRpmDepend = Utils.getNoNil(getXMLBool(self.xmlFile, stringRotatorParts .. "rotatorRpmDepend"), true);
			table.insert(self.rotatorsTable, rotatorInfo);
		else
			break;
		end;
		i = i + 1;
	end;
	
	local a = 0;
	self.animatorsTable = {};
	while true do
		local stringAnimatorParts = string.format("vehicle.animators.animatorPart(%d)#", a);
		local animatorName = getXMLString(self.xmlFile, stringAnimatorParts .. "animatorName");
		local animatorHelpText = getXMLBool(self.xmlFile, stringAnimatorParts .. "animatorHelpText")
		local animatorLoop = getXMLBool(self.xmlFile, stringAnimatorParts .. "animatorLoop")
		local animatorIsEngine = getXMLBool(self.xmlFile, stringAnimatorParts .. "animatorIsEngine")
		if animatorName ~= nil and animatorHelpText ~= nil and animatorLoop ~= nil and animatorIsEngine ~= nil then
			local animatorInfo = {};
			animatorInfo.animatorName = animatorName;
			animatorInfo.animatorHelpText = animatorHelpText;
			animatorInfo.animatorLoop = animatorLoop;
			animatorInfo.animatorIsEngine = animatorIsEngine;
			animatorInfo.animatorState = false;
			table.insert(self.animatorsTable, animatorInfo);
		else
			break;
		end;
		a = a + 1;
	end;
end;

function mechanism:delete()
end;

function mechanism:mouseEvent(posX, posY, isDown, isUp, button)
end;

function mechanism:keyEvent(unicode, sym, modifier, isDown)
end;

function mechanism:update(dt)
	for _, rotatorInfo in pairs(self.rotatorsTable) do
		if rotatorInfo.rotatorIndex ~= nil then
			if self.isMotorStarted then
				if rotatorInfo.rotatorRpmDepend then
					self.rotSpeed = self.motor.lastMotorRpm*0.0003*rotatorInfo.rotatorSpeed;
				else
					self.rotSpeed = dt*0.01*rotatorInfo.rotatorSpeed;
				end;
				if rotatorInfo.rotatorAxis == 1 then
					rotate(rotatorInfo.rotatorIndex, self.rotSpeed, 0, 0);
				elseif rotatorInfo.rotatorAxis == 2 then
					rotate(rotatorInfo.rotatorIndex, 0, self.rotSpeed, 0);
				elseif rotatorInfo.rotatorAxis == 3 then
					rotate(rotatorInfo.rotatorIndex, 0, 0, self.rotSpeed);
				end;
			end;
		end;
	end;
	
	if g_currentMission.controlledVehicle == self then
		for _, animatorInfo in pairs(self.animatorsTable) do
			if animatorInfo.animatorName ~= nil and animatorInfo.animatorHelpText ~= nil and animatorInfo.animatorLoop ~= nil and animatorInfo.animatorIsEngine ~= nil then
				if InputBinding.hasEvent(InputBinding[animatorInfo.animatorName]) then
					if animatorInfo.animatorLoop then
						animatorInfo.animatorState = not animatorInfo.animatorState;
					else
						if animatorInfo.animatorState == false then
							self:playAnimation(animatorInfo.animatorName, 1, nil, true);
							animatorInfo.animatorState = true;
						else
							self:playAnimation(animatorInfo.animatorName, -1, nil, true);
							animatorInfo.animatorState = false;
						end;
					end;
				end;
				if animatorInfo.animatorLoop then
					if animatorInfo.animatorState then
						self:playAnimation(animatorInfo.animatorName, 1, nil, true);
					end;
				end;
				if animatorInfo.animatorLoop and animatorInfo.animatorIsEngine then
					if self.isMotorStarted then
						self:playAnimation(animatorInfo.animatorName, 1, nil, true);
					end;
				end;
			end;
		end;
	end;
end;

function mechanism:draw()
	if g_currentMission.controlledVehicle == self then
		for _, animatorInfo in pairs(self.animatorsTable) do
			if animatorInfo.animatorName ~= nil and animatorInfo.animatorHelpText ~= nil and animatorInfo.animatorLoop ~= nil and animatorInfo.animatorIsEngine ~= nil then
				if animatorInfo.animatorHelpText then
					g_currentMission:addHelpButtonText(g_i18n:getText(animatorInfo.animatorName), InputBinding[animatorInfo.animatorName]);
				end;
			end;
		end;
	end;
end;