--
-- 
--
-- 
--

FaecherOpener = {};

FaecherOpener.modDir = g_currentModDirectory;

function FaecherOpener.prerequisitesPresent(specializations)
    return true; 
end;

function FaecherOpener:load(savegame)

    self.playerCallbackFaecher = SpecializationUtil.callSpecializationsFunction("playerCallbackFaecher"); 
    
    self.FaecherO = {};
    
    local trigger = Utils.indexToObject( self.components, getXMLString(xmlFile, string.format("vehicle.FaecherOpener#trigger")) );
    if trigger == nil then
        print("[Error::FaecherOpener] node is OK, but trigger could not be located. Check line "..tostring(i+1).." in your vehicle.xml");
    end;
    
    local icIndex = getXMLInt(xmlFile, string.format("vehicle.FaecherOpener#icIndex", i));
    
    self.FaecherO.icIndex = icIndex;
    self.FaecherO.trigger = trigger;
    self.FaecherO.plIR = false;
        
    addTrigger( trigger, "playerCallbackFaecher", self );                
    
end;

function FaecherOpener:delete()
    if self.FaecherO.trigger ~= nil then
        removeTrigger(self.FaecherO.trigger);
    end;
end;

function FaecherOpener:readStream(streamId, connection)
end;

function FaecherOpener:writeStream(streamId, connection)
end;

function FaecherOpener:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FaecherOpener:keyEvent(unicode, sym, modifier, isDown)
end;

function FaecherOpener:update(dt)
    
    if self.FaecherO.plIR then
        g_currentMission:addHelpButtonText( g_i18n:getText("SET_FaecherOPENER"), InputBinding.SET_FaecherOPENER );    
        setTextColor(1.0, 1.0, 1.0, 1.0);
        setTextAlignment(RenderText.ALIGN_LEFT);                 
        renderText( 0.5, 0.06, 0.02, g_i18n:getText("SET_FaecherOPENER") );
        if InputBinding.hasEvent(InputBinding.SET_FaecherOPENER)then
            local obj = self.interactiveObjects[self.FaecherO.icIndex];
            if obj ~= nil then
                --self.setFaecher(not obj.isOpen);
                self:doActionOnObject(self.FaecherO.icIndex);
            end;
            
            --self.vehicle:playAnimation(self.animation, dir, Utils.clamp(self.vehicle:getAnimationTime(self.animation), 0, 1), true);
        end
    end;
end;

function FaecherOpener:onLeave()
end;

function FaecherOpener:draw()
end;

function FaecherOpener:playerCallbackFaecher(triggerId, otherId, onEnter, onLeave, onStay)
    
    if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.FaecherO.plIR = true;
    elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.FaecherO.plIR = false;
    end;
    
end;

