

keilriemen = {};

function keilriemen.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function keilriemen:load(savegame)

    keilriemen.loadkeilriemens(self, xmlFile);

    --[[local keilriemenSound = getXMLString(xmlFile, "vehicle.keilriemenSound#file");
    if keilriemenSound ~= nil and keilriemenSound ~= "" then
        keilriemenSound = Utils.getFilename(keilriemenSound, self.baseDirectory);
        self.keilriemenSound = createSample("keilriemenSound");
        self.keilriemenSoundEnabled = false;
        loadSample(self.keilriemenSound, keilriemenSound, false);
        self.keilriemenSoundPitch = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.keilriemenSound#pitchOffset"), 1);
        self.keilriemenSoundVolume = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.keilriemenSound#volume"), 1);
    else
        self.keilriemenSoundPitch = 1;
        self.keilriemenSoundVolume = 1;
    end;]]

end;

function keilriemen:loadkeilriemens(xmlFile)
    self.keilriemens = {};
    local i = 0;
    while true do
        local key = string.format("vehicle.keilriemen.keilriemen(%d)", i);
        if not hasXMLProperty(xmlFile, key) then
            break;
        end;
        local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
        local speedRefNode = Utils.getNoNil(Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#speedRefNode")), node);
        local scrollSpeed = Utils.getNoNil(getXMLFloat(xmlFile, key.."#scrollSpeed"), 1);
        local shaderParameterName = Utils.getNoNil(getXMLString(xmlFile, key.."#shaderParameterName"), "scrollPosition");
        local shaderParameterComponent = Utils.getNoNil(getXMLInt(xmlFile, key.."#shaderParameterComponent"), 1);
        local scrollLength = Utils.getNoNil(getXMLFloat(xmlFile, key.."#scrollLength"), 1);
        local constSpeed = Utils.getNoNil(getXMLBool(xmlFile, key.."#constSpeed"),false);
        if node ~= nil then
            local rotatingParts = {};
            local j = 0;
            while true do
                local keyRotation = key..string.format(".rotatingPart(%d)", j);
                if not hasXMLProperty(xmlFile, keyRotation) then
                    break;
                end;
                local rotationNode = Utils.indexToObject(self.components, getXMLString(xmlFile, keyRotation.."#index"));
                local speedScale = getXMLFloat(xmlFile, keyRotation.."#speedScale");
                
                if speedScale == nil then
                    speedScale = 1.0/Utils.getNoNil(getXMLFloat(xmlFile, keyRotation.."#radius"), 1);
                end;
                if rotationNode ~= nil then
                    table.insert(rotatingParts, {node=rotationNode, speedScale=speedScale});
                end;
                j = j + 1;
            end;

            table.insert(self.keilriemens, {node=node, scrollSpeed=scrollSpeed, scrollPosition=0, scrollLength=scrollLength, shaderParameterName=shaderParameterName, shaderParameterComponent=shaderParameterComponent, speedRefNode=speedRefNode, rotatingParts=rotatingParts,constSpeed=constSpeed});
        end;
        i = i + 1;
    end;
end;

function keilriemen:delete()

    --[[if self.keilriemenSound ~= nil then
        delete(self.keilriemenSound);
    end;]]

end;

function keilriemen:mouseEvent(posX, posY, isDown, isUp, button)
end;

function keilriemen:keyEvent(unicode, sym, modifier, isDown)

end;

function keilriemen:update(dt)


    if self:getIsActive() and self.isMotorStarted then
    

        for _, keilriemen in pairs(self.keilriemens) do
            -- local newX, newY, newZ = getWorldTranslation(keilriemen.speedRefNode);
            -- if keilriemen.lastPosition == nil then
                -- keilriemen.lastPosition = {newX, newY, newZ};
            -- end;
            -- local dx, dy, dz = worldDirectionToLocal(keilriemen.speedRefNode, newX-keilriemen.lastPosition[1], newY-keilriemen.lastPosition[2], newZ-keilriemen.lastPosition[3]);
            -- local movingDirection = 0;
            -- if dz > 0.0001 then
                -- movingDirection = 1;
            -- elseif dz < -0.0001 then
                -- movingDirection = -1;
            -- end;
            -- local movedDistance = Utils.vector3Length(dx, dy, dz);
            -- keilriemen.lastPosition[1] = newX;
            -- keilriemen.lastPosition[2] = newY;
            -- keilriemen.lastPosition[3] = newZ;
            
            local movedDistance = 0;

            if keilriemen.constSpeed then
                    movedDistance = 1.0;
            elseif self.isMotorStarted then                
                    movedDistance = self.motor.lastMotorRpm;                
            end;

            keilriemen.scrollPosition = (keilriemen.scrollPosition + movedDistance*keilriemen.scrollSpeed) % keilriemen.scrollLength;
            if keilriemen.shaderParameterComponent == 1 then
                setShaderParameter(keilriemen.node, keilriemen.shaderParameterName, keilriemen.scrollPosition,0,0,0, false);
            else
                setShaderParameter(keilriemen.node, keilriemen.shaderParameterName, 0,keilriemen.scrollPosition,0,0, false);
            end;

            for _, rotatingPart in pairs(keilriemen.rotatingParts) do
                rotate(rotatingPart.node, 0,0, rotatingPart.speedScale * movedDistance);
            end;
        end;

        --[[if not self.keilriemenSoundEnabled then
            playSample(self.keilriemenSound, 0, 0, 0);
            self.keilriemenSoundEnabled = true;
        end;

        if self.keilriemenSound ~= nil then
            local maxDistance  = 0.15;
            if self.keilriemenSoundEnabled then
                local keilriemenVolume = Utils.clamp(( math.abs(movedDistance) / maxDistance), 0.0, 1.0);
                setSampleVolume(self.keilriemenSound, keilriemenVolume-0.75);
            end;
        end;]]

    end;

end;

function keilriemen:draw()
end;