-- by Bayerbua
-- by Mogli

XerionSaddleTrac = {};

function XerionSaddleTrac.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function XerionSaddleTrac:load(savegame)

    -- callbacks for IC control
    self.xerionSaddleTrac = {}
    -- handbrake
    self.xerionSaddleTrac.set4WD          = XerionSaddleTrac.set4WD
    self.xerionSaddleTrac.get4WD          = XerionSaddleTrac.get4WD
    self.xerionSaddleTrac.setHandbrake  = XerionSaddleTrac.setHandbrake
    self.xerionSaddleTrac.getHandbrake  = XerionSaddleTrac.getHandbrake
    self.xerionSaddleTrac.setHupe       = XerionSaddleTrac.setHupe
    self.xerionSaddleTrac.getHupe       = XerionSaddleTrac.getHupe
    self.xerionSaddleTrac.setMotorStart = XerionSaddleTrac.setMotorStart
    self.xerionSaddleTrac.getMotorStart = XerionSaddleTrac.getMotorStart
    self.xerionSaddleTrac.setTLHazard   = XerionSaddleTrac.setTLHazard
    self.xerionSaddleTrac.getTLHazard   = XerionSaddleTrac.getTLHazard
    self.xerionSaddleTrac.setTurnLight  = XerionSaddleTrac.setTurnLight
    self.xerionSaddleTrac.getTurnLight  = XerionSaddleTrac.getTurnLight
    self.xerionSaddleTrac.setEGas       = XerionSaddleTrac.setEGas
    self.xerionSaddleTrac.getEGas       = XerionSaddleTrac.getEGas
    
    local steeringModes = {}
    steeringModes["StreetMode"] = "XerionSteerV2Mode"
    steeringModes["MSSLi"]      = "XerionSteerV2LeftCrab"
    steeringModes["MSSRe"]      = "XerionSteerV2RightCrab"
    steeringModes["All"]        = "XerionSteerV2All"
    
    for name,textId in pairs( steeringModes ) do
        self.xerionSaddleTrac["set"..name] = function( self, bool )
            XerionSaddleTrac.setComplexSteeringMode( self, textId, bool )
        end
        self.xerionSaddleTrac["get"..name] = function( self )
            return XerionSaddleTrac.getComplexSteeringMode( self, textId )
        end
    end
    
    self.xerionSaddleTrac.lockSemiTrailer = false
    self.xerionSaddleTrac.lockFrontAxis   = false
    self.xerionSaddleTrac.frontAxisLimit  = math.rad( 6 )
    self.xerionSaddleTrac.eGas            = { 0.6, 0 }
    self.xerionSaddleTrac.setEGasRPM      = XerionSaddleTrac.setEGasRPM
    self.xerionSaddleTrac.crabSteer       = 0.6666667
    self.xerionSaddleTrac.setCrabSteer    = XerionSaddleTrac.setCrabSteer
    self.xerionSaddleTrac.wiperF          = false
    self.xerionSaddleTrac.wiperS          = false
    self.xerionSaddleTrac.wiperB          = false
    self.xerionSaddleTrac.lastSteeringMode= 1
    
    self.xerionSaddleTrac.honkTime     = 0

    self.xerionSaddleTracHupe = true
    
    -- Zapfwellenstummel / Powershaft rotation
    self.stummelIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac#zapfwellenStummelIndex"));
    
    -- Ladezeichen /  rotation
    self.LCDLadezeichen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.LCDLadezeichen#index"));
    
    -- Temperaturzeiger / Oeldruck
    self.temperaturZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.TemperaturZeiger#zeigerIndex"));
    self.temperaturZeigerMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.XerionSaddleTrac.TemperaturZeiger#maxRotation"));
    self.tempCnt = 0;

    -- Temperaturzeiger2 / Wassertemperatur
    self.temperaturZeiger2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.TemperaturZeiger2#zeigerIndex"));
    self.temperaturZeigerMaxRot2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.XerionSaddleTrac.TemperaturZeiger2#maxRotation"));
    self.tempCnt2 = 0;
        
    -- Ladekontrollleuchte / Batterie 
    self.ladeLeuchte = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.LadeKontrollLeuchte#index"));
    setVisibility(self.ladeLeuchte, false);
    self.ladeLeuchteOn = 0;
    self.ladeTimer = 1500;
    
    -- Ladekontrollleuchte1 / Bremsdruck
    self.ladeLeuchte1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.LadeKontrollLeuchte1#index"));
    setVisibility(self.ladeLeuchte1, false);
    self.ladeLeuchte1On = 0;
    self.ladeTimer1 = 3500;
    
    -- LCD_AUS / Deckflaeche
    self.LCD_AUS = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.LCD_AUS#index"));
    
    setVisibility(self.LCD_AUS, true);
    self.LCD_Deckflaeche = 1;

    -- LCD_Startbild
    self.LCD_Startbild = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.LCD_Startbild#index"));
    setVisibility(self.LCD_Startbild, false);
    self.LCD_StartbildOn = 0;
    self.ladeTimer2 = 3000;
    
    -- LED Warnblinker
    self.LED_warnBlink = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.LED_Warnblink#index"));
    self.LED_refLinks = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.LED_Warnblink#refLinksIndex"));
    self.LED_refRechts = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.LED_Warnblink#refRechtsIndex"));
        
    -- Led Gruen / Solitronic
    self.LED_Gruen = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.LED_Gruen#index"));
    setVisibility(self.LED_Gruen, false);
    
    -- LCD_Solitronic / Deckflaeche
    self.LCD_Solitronic_AUS = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.LCD_Solitronic_AUS#index"));
    setVisibility(self.LCD_Solitronic_AUS, true);
    
    -- FM103
    self.FM103 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.FM103#index"));
    setVisibility(self.FM103, false);
    
    -- AntenneBayern
    self.AntenneBayern = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.AntenneBayern#index"));
    setVisibility(self.AntenneBayern, false);
    
    -- Klimaanlage
    self.Klimaanlage = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.Klimaanlage#index"));
    setVisibility(self.Klimaanlage, false);
    
    
    -- Led_blau_ob_Punktvoll_ON
    self.Led_blau_ob_Punktvoll_ON = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.Led_blau_ob_Punktvoll_ON#index"));
    setVisibility(self.Led_blau_ob_Punktvoll_ON, false);
    -- Led_blau_un_Punktvoll_ON
    self.Led_blau_un_Punktvoll_ON = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.Led_blau_un_Punktvoll_ON#index"));
    setVisibility(self.Led_blau_un_Punktvoll_ON, false);
    -- Led_gruen_ob_Punktvoll_ON
    self.Led_gruen_ob_Punktvoll_ON = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.Led_gruen_ob_Punktvoll_ON#index"));
    setVisibility(self.Led_gruen_ob_Punktvoll_ON, false);
    -- Led_gruen_un_Punktvoll_ON
    self.Led_gruen_un_Punktvoll_ON = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.Led_gruen_un_Punktvoll_ON#index"));
    setVisibility(self.Led_gruen_un_Punktvoll_ON, false);
    -- Led_gelb_ob_Punktvoll_ON
    self.Led_gelb_ob_Punktvoll_ON = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.Led_gelb_ob_Punktvoll_ON#index"));
    setVisibility(self.Led_gelb_ob_Punktvoll_ON, false);
    -- Led_gelb_un_Punktvoll_ON
    self.Led_gelb_un_Punktvoll_ON = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.Led_gelb_un_Punktvoll_ON#index"));
    setVisibility(self.Led_gelb_un_Punktvoll_ON, false);
    -- Led_rot_ob_Punktvoll_ON
    self.Led_rot_ob_Punktvoll_ON = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.Led_rot_ob_Punktvoll_ON#index"));
    setVisibility(self.Led_rot_ob_Punktvoll_ON, false);
    -- Led_rot_un_Punktvoll_ON
    self.Led_rot_un_Punktvoll_ON = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.Led_rot_un_Punktvoll_ON#index"));
    setVisibility(self.Led_rot_un_Punktvoll_ON, false);    
    -- Schalter14_LED_Rot_ON
    self.Schalter14_LED_Rot_ON = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.Schalter14_LED_Rot_ON#index"));
    setVisibility(self.Schalter14_LED_Rot_ON, false);    
    -- Schalter11_LED_Gruen_ON
    self.Schalter11_LED_Gruen_ON = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.Schalter11_LED_Gruen_ON#index"));
    setVisibility(self.Schalter11_LED_Gruen_ON, false);    
    -- Schalter6_Ledzusammenfassung
    self.Schalter6_Ledzusammenfassung = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.Schalter6_Ledzusammenfassung#index"));
    setVisibility(self.Schalter6_Ledzusammenfassung, false);
    -- Schalter5_Ledzusammenfassung
    self.Schalter5_Ledzusammenfassung = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.Schalter5_Ledzusammenfassung#index"));
    setVisibility(self.Schalter5_Ledzusammenfassung, false);
    -- Schalter4_Ledzusammenfassung
    self.Schalter4_Ledzusammenfassung = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.Schalter4_Ledzusammenfassung#index"));
    setVisibility(self.Schalter4_Ledzusammenfassung, false);

    self.motorStartAnim    = getXMLString(xmlFile, "vehicle.XerionSaddleTrac.MotorStart#animation" )
    self.joystickAnim   = getXMLString(xmlFile, "vehicle.XerionSaddleTrac.Joystick#animation" )
    
    --RDS
    self.RDSDisplay_Black_Aus = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.RDSDisplay_Black_Aus#index"));
    setVisibility(self.RDSDisplay_Black_Aus, true);
    self.RDSLedPower = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.RDSLedPower#index"));
    setVisibility(self.RDSLedPower, false);
    --SC_Display_AUS
    self.SC_Display_AUS = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.XerionSaddleTrac.SC_Display_AUS#index"));
    setVisibility(self.SC_Display_AUS , true);
end;

function XerionSaddleTrac:delete()
end;
function XerionSaddleTrac:mouseEvent(posX, posY, isDown, isUp, button)
end;
function XerionSaddleTrac:keyEvent(unicode, sym, modifier, isDown)
end;

function XerionSaddleTrac:update(dt)

    if     self.xerionSaddleTrac.lockFrontAxis 
            or self.xerionSaddleTrac.getStreetMode(self) then
            
        if self.componentJoints[1].rotLimit[3] > 1e-4 then
            self.xerionSaddleTrac.frontAxisLimit = self.componentJoints[1].rotLimit[3]
            Vehicle.setComponentJointRotLimit(self, self.componentJoints[1], 3, 0, 0)
        end
    else
        if self.componentJoints[1].rotLimit[3] < self.xerionSaddleTrac.frontAxisLimit - 1e-4 then
            Vehicle.setComponentJointRotLimit(self, self.componentJoints[1], 3, -self.xerionSaddleTrac.frontAxisLimit, self.xerionSaddleTrac.frontAxisLimit)
        end
    end
    
end;

function XerionSaddleTrac:updateTick(dt)

    if self:getIsActive() then
        if self.isMotorStarted then
                        
            -- Ladekontrollleuchte / Batterie load light
            if self.ladeLeuchteOn == 1 then
                setVisibility(self.ladeLeuchte, true);
                if self.ladeLeuchteOn == 1 then
                    self.timerTrue = true;
                end;
                if self.timerTrue then
                    self.ladeTimer = math.max(self.ladeTimer - dt, 0);
                end;
                if self.ladeTimer == 0 then
                    setVisibility(self.ladeLeuchte, false);
                    self.timerTrue = nil;
                    self.ladeLeuchteOn = 0;
                    self.ladeTimer = 1500;
                end;
            end;
            
            -- Ladekontrollleuchte1 / Bremsdruck load light
            if self.ladeLeuchte1On == 1 then
                setVisibility(self.ladeLeuchte1, true);
                if self.ladeLeuchte1On == 1 then
                    self.timerTrue1 = true;
                end;
                if self.timerTrue1 then
                    self.ladeTimer1 = math.max(self.ladeTimer1 - dt, 0);
                end;
                if self.ladeTimer1 == 0 then
                    setVisibility(self.ladeLeuchte1, false);
                    self.timerTrue1 = nil;
                    self.ladeLeuchte1On = 0;
                    self.ladeTimer1 = 3500;
                end;
            end;
            
            -- LCD_Startbild
            if self.LCD_StartbildOn == 1 then
                setVisibility(self.LCD_Startbild, true);
                if self.LCD_StartbildOn == 1 then
                self.timerTrue2 = true;
                end;
                if self.timerTrue2 then
                    self.ladeTimer2 = math.max(self.ladeTimer2 - dt, 0);
                end;
                if self.ladeTimer2 == 0 then
                    setVisibility(self.LCD_Startbild, false);
                    self.timerTrue2 = nil;
                    self.LCD_StartbildOn = 0;
                    self.ladeTimer2 = 3000;
                end;
            end;
            
            -- LCD_AUS
            if self.LCD_Deckflaeche == 1 then
                setVisibility(self.LCD_AUS, false);
                setVisibility(self.RDSDisplay_Black_Aus , false);
                setVisibility(self.SC_Display_AUS , false);
                setVisibility(self.RDSLedPower , true);
                setVisibility(self.LED_Gruen, true);
                setVisibility(self.LCD_Solitronic_AUS, false);
                setVisibility(self.FM103, true);
                setVisibility(self.AntenneBayern, true);
                setVisibility(self.Klimaanlage, true);                
                setVisibility(self.Led_blau_ob_Punktvoll_ON, true);
                setVisibility(self.Led_blau_un_Punktvoll_ON, true);
                setVisibility(self.Led_gruen_ob_Punktvoll_ON, true);
                setVisibility(self.Led_gruen_un_Punktvoll_ON, true);
                setVisibility(self.Led_gelb_ob_Punktvoll_ON, true);
                setVisibility(self.Led_gelb_un_Punktvoll_ON, true);
                setVisibility(self.Led_rot_ob_Punktvoll_ON, true);
                setVisibility(self.Led_rot_un_Punktvoll_ON, true);                
                setVisibility(self.Schalter14_LED_Rot_ON, true);
                --setVisibility(self.Schalter11_LED_Gruen_ON, true);
                setVisibility(self.Schalter6_Ledzusammenfassung, true);
                setVisibility(self.Schalter5_Ledzusammenfassung, true);
                setVisibility(self.Schalter4_Ledzusammenfassung, true);
            end;

        -- Zapfwellenstummel / Powershaft rotation
        rotate(self.stummelIndex, 0,0,0.000*dt);
        
        -- LCD Ladezeichen / Powershaft rotation
        rotate(self.LCDLadezeichen, 0,-0.1,0*dt);
            
            -- Temperaturanzeiger / temperature display animation und / and berechnung / calculation
            if self.tempCnt < 3000 then
                setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
                self.tempCnt = self.tempCnt + 0.5;
            elseif self.tempCnt > 3000 and self.tempCnt < 6000 then
                setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
                self.tempCnt = math.min(self.tempCnt + 0.2, 10000);            
            else
                setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
                self.tempCnt = math.min(self.tempCnt + 0.05, 10000);
            end;
            if self.tempCnt2 < 3000 then
                setRotation(self.temperaturZeiger2, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2), 0);
                self.tempCnt2 = self.tempCnt2 + 0.8;
            elseif self.tempCnt2 > 3000 and self.tempCnt2 < 6000 then
                setRotation(self.temperaturZeiger2, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2), 0);
                self.tempCnt2 = math.min(self.tempCnt2 + 0.3, 10000);            
            else
                setRotation(self.temperaturZeiger2, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2), 0);
                self.tempCnt2 = math.min(self.tempCnt2 + 0.04, 10000);
            end;            
            setVisibility(self.LED_warnBlink,getVisibility(self.LED_refLinks) and getVisibility(self.LED_refRechts));            
        end;
    
        local curAnimTime = Utils.clamp( self:getAnimationTime(self.joystickAnim), 0, 1 )
        local tgtAnimTime = 0.5 * ( 1 + Utils.getNoNil(self.axisForward,0) )
        
        if self.axisForwardIsAnalog then
            self:setAnimationTime( self.joystickAnim, tgtAnimTime, true )
        else
            local dir = 0
            if     tgtAnimTime < curAnimTime then
                dir = -1
            elseif tgtAnimTime > curAnimTime then
                dir = 1
            end
            if dir ~= 0 then
                self:playAnimation(self.joystickAnim, dir, curAnimTime, true);
                self:setAnimationStopTime(self.joystickAnim, tgtAnimTime );
            end
        end
    else
        self.tempCnt = math.max(self.tempCnt - 0.08, 0);
        self.tempCnt2 = math.max(self.tempCnt2 - 0.1, 0);
    end;
    
    if self.xerionSaddleTrac.wiperF and not self:getIsAnimationPlaying( "Wiper_Front_1" ) then
        self:playAnimation( "Wiper_Front_1" )
    end
    if self.xerionSaddleTrac.wiperS and not self:getIsAnimationPlaying( "Wiper_Side_1" ) then
        self:playAnimation( "Wiper_Side_1" )
    end
    if self.xerionSaddleTrac.wiperB and not self:getIsAnimationPlaying( "Wiper_Back_1" ) then
        self:playAnimation( "Wiper_Back_1" )
    end    
end;

function XerionSaddleTrac:draw()

    --if      self.mrGbMGetIsOn          ~= nil
    --        and self:mrGbMGetIsOn()
    --        and self.mrGbMGetModeShortText ~= nil then
    --    
    --    setTextBold(false)
  --
    --    local w = math.floor(0.0095 * g_screenWidth) / g_screenWidth
  --  local x = 1 - 0.25*w
    --    local t = g_currentMission.speedUnitTextSize*2
    --    local d = 0.25*t
  --  local y = g_currentMission.speedHud.y
    --    
    --    local text = self:mrGbMGetModeShortText()
    --    
    --    if text ~= nil and text ~= "" then
    --        setTextAlignment(RenderText.ALIGN_RIGHT) 
    --        renderText( x, y, t, text )
    --    end
    --    
    --    if     self:mrGbMGetNeutralActive() then
    --        text = "N"
    --    elseif self:mrGbMGetReverseActive() then
    --        text = "R"
    --    else
    --        text = "F"
    --    end
    --    
    --    x = g_currentMission.speedHud.x - 0.25*w
    --    y = g_currentMission.speedHud.y + g_currentMission.speedHud.height - d
    --    setTextAlignment(RenderText.ALIGN_LEFT) 
    --    renderText( x, y, t, text )
    --end
end;

function XerionSaddleTrac:onEnter()
    self.ladeLeuchteOn = 1;
    self.ladeLeuchte1On = 1;
    self.LCD_Deckflaeche = 1;
    self.LCD_StartbildOn = 1;
end;

function XerionSaddleTrac:onLeave()
    self.ladeTimer = 0
    self.ladeTimer1 = 0
    self.ladeTimer2 = 0
end;

function XerionSaddleTrac:startMotor()
    self.LCD_Deckflaeche = 1;
        
    self:playAnimation(self.motorStartAnim, 1, Utils.clamp(self:getAnimationTime(self.motorStartAnim), 0, 1), true)
end;

function XerionSaddleTrac:stopMotor()
    self.ladeLeuchteOn = 1;
    self.ladeLeuchte1On = 1;
    self.LCD_StartbildOn = 1;
    self.LCD_Deckflaeche = 0;
    
    -- LCD_AUS
    if self.LCD_Deckflaeche == 0 then
        setVisibility(self.LCD_AUS, true);
        setVisibility(self.RDSDisplay_Black_Aus, true);
        setVisibility(self.SC_Display_AUS , true);
        setVisibility(self.RDSLedPower , false);
        setVisibility(self.LED_Gruen, false);
        setVisibility(self.LCD_Solitronic_AUS, true);
        setVisibility(self.FM103, false);
        setVisibility(self.AntenneBayern, false);
        setVisibility(self.Klimaanlage, false);        
        setVisibility(self.Led_blau_ob_Punktvoll_ON, false);
        setVisibility(self.Led_blau_un_Punktvoll_ON, false);
        setVisibility(self.Led_gruen_ob_Punktvoll_ON, false);
        setVisibility(self.Led_gruen_un_Punktvoll_ON, false);
        setVisibility(self.Led_gelb_ob_Punktvoll_ON, false);
        setVisibility(self.Led_gelb_un_Punktvoll_ON, false);
        setVisibility(self.Led_rot_ob_Punktvoll_ON, false);
        setVisibility(self.Led_rot_un_Punktvoll_ON, false);        
        setVisibility(self.Schalter14_LED_Rot_ON, false);
        setVisibility(self.Schalter11_LED_Gruen_ON, false);
        setVisibility(self.Schalter6_Ledzusammenfassung, false);
        setVisibility(self.Schalter5_Ledzusammenfassung, false);
        setVisibility(self.Schalter4_Ledzusammenfassung, false);
    end;
    
    self:playAnimation(self.motorStartAnim, -1, Utils.clamp(self:getAnimationTime(self.motorStartAnim), 0, 1), true)    

end;

function XerionSaddleTrac.getRelativeTranslation(root,node)
    if root == nil or node == nil then
        return 0,0,0
    end
    local x,y,z;
    if getParent(node)==root then
        x,y,z = getTranslation(node);
    else
        x,y,z = worldToLocal(root,getWorldTranslation(node));
    end;
    return x,y,z;
end

function XerionSaddleTrac:getHandbrake()
    if      self.dCcheckModule ~=  nil 
            and self.driveControl  ~= nil
            and self:dCcheckModule("handBrake")
            and self.driveControl.handBrake ~= nil then
        return self.driveControl.handBrake.isActive
    elseif  self.mrGbMGetNeutralActive ~= nil then
        return self:mrGbMGetNeutralActive()
    end
    return false
end

function XerionSaddleTrac:setHandbrake(bool)
    if      self.dCcheckModule ~=  nil 
            and self.driveControl  ~= nil
            and self:dCcheckModule("handBrake")
            and self.driveControl.handBrake ~= nil then
        self.driveControl.handBrake.isActive = bool
    elseif  self.mrGbMSetNeutralActive ~= nil then
        self:mrGbMSetNeutralActive(bool)
    elseif bool then
        g_currentMission:showBlinkingWarning("Neither zzzDriveControl, nor zzzGearboxAddon handBrake are available", 6000)
    end
end

function XerionSaddleTrac:get4WD()
    if      self.dCcheckModule ~=  nil 
            and self.driveControl  ~= nil
            and self:dCcheckModule("fourWDandDifferentials")
            and self.driveControl.fourWDandDifferentials ~= nil then
        return self.driveControl.fourWDandDifferentials.isSurpressed
    end
    return false
end

function XerionSaddleTrac:set4WD(bool)
    if      self.dCcheckModule ~=  nil 
            and self.driveControl  ~= nil
            and self:dCcheckModule("fourWDandDifferentials")
            and self.driveControl.fourWDandDifferentials ~= nil then
        self.driveControl.fourWDandDifferentials.isSurpressed = bool
        local enable 
        if force == nil then
            enable = not ( self.driveControl.fourWDandDifferentials.fourWheel )
        else
            enable = force
        end
        self.driveControl.fourWDandDifferentials.fourWheel = enable
        driveControlInputEvent.sendEvent(self)
    elseif bool then
        g_currentMission:showBlinkingWarning("mod ZZZ_driveControl is missing!", 6000)
    end
end

function XerionSaddleTrac:getEGas()
    if self.mrGbMGetHandThrottle ~= nil then
        return self:mrGbMGetHandThrottle() > 0.001
    end
    return false
end

function XerionSaddleTrac:setEGas(bool)
    if self.mrGbMSetHandThrottle ~= nil then
        if bool then
            if self.xerionSaddleTrac.eGas[1] < 0.01 then
                self.xerionSaddleTrac.eGas[1] = 0.6
            end
            self:mrGbMSetHandThrottle(self.xerionSaddleTrac.eGas[1])
        else
            self:mrGbMSetHandThrottle(0)
        end
    elseif bool then
        g_currentMission:showBlinkingWarning("zzzGearboxAddon is not available", 6000)
    end
end

function XerionSaddleTrac:setEGasRPM(animTimeTab)
    self.xerionSaddleTrac.eGas = animTimeTab 
    if self.xerionSaddleTrac.getEGas(self) then
        self:mrGbMSetHandThrottle(self.xerionSaddleTrac.eGas[1])
    end
end

function XerionSaddleTrac:getHupe()
    if self.sampleHonk == nil then
        return false
    end
    return self.sampleHonk.isPlaying
end

function XerionSaddleTrac:setHupe(bool)
    if bool then
        self.xerionSaddleTrac.honkTime = g_currentMission.time + 1000
        if not self.sampleHonk.isPlaying then
            self:playHonk(true);
        end
    else
        self.xerionSaddleTrac.honkTime = 0
    end
end

function XerionSaddleTrac:getMotorStart()
    if      self.dCcheckModule ~= nil
            and self:dCcheckModule("manMotorStart") 
            and self.driveControl ~= nil
            and self.driveControl.manMotorStart ~= nil then
        return self.driveControl.manMotorStart.isMotorStarted
    end
    return self.isMotorStarted
end

function XerionSaddleTrac:setMotorStart(bool)
    if      self.dCcheckModule ~= nil
            and self:dCcheckModule("manMotorStart") 
            and self.driveControl ~= nil
            and self.driveControl.manMotorStart ~= nil then
        print("motor start via driveControl: "..tostring(self.driveControl.manMotorStart.isMotorStarted))
        if self.driveControl.manMotorStart.isMotorStarted ~= bool then
            self.driveControl.manMotorStart.isMotorStarted = bool
            driveControlInputEvent.sendEvent(self)
        end
    elseif self.setManualIgnitionMode ~= nil then
        print("motor start via manualIgnition: "..tostring(self.isMotorStarted))
        if bool ~= self.isMotorStarted then
            if bool then
                self:setManualIgnitionMode(2)
            else
                self:setManualIgnitionMode(0)
            end
        end
    end
end

function XerionSaddleTrac:getTLHazard()
    return self.turnSignalState == Vehicle.TURNSIGNAL_HAZARD
end

function XerionSaddleTrac:setTLHazard(bool)
    if bool then
        self.setTurnSignalState(self, Vehicle.TURNSIGNAL_HAZARD)
    elseif self.turnSignalState == Vehicle.TURNSIGNAL_HAZARD then
        self.setTurnSignalState(self, Vehicle.TURNSIGNAL_OFF)
    end
end

function XerionSaddleTrac:getTurnLight()
    if     self.turnSignalState == Vehicle.TURNSIGNAL_RIGHT then
        return 0
    elseif self.turnSignalState == Vehicle.TURNSIGNAL_LEFT  then
        return 1
    end
    return 0.5
end

function XerionSaddleTrac:setTurnLight(animTime)
    if animTime < 0.25 then
        self.setTurnSignalState(self, Vehicle.TURNSIGNAL_RIGHT)
    elseif animTime > 0.75 then
        self.setTurnSignalState(self, Vehicle.TURNSIGNAL_LEFT)
    elseif self.turnSignalState ~= Vehicle.TURNSIGNAL_HAZARD then
        self.setTurnSignalState(self, Vehicle.TURNSIGNAL_OFF)
    end
end

function XerionSaddleTrac:newPlayHonk(superFunc, isPlaying, noEventSend)
    if     isPlaying
            or self.xerionSaddleTrac          == nil
            or self.xerionSaddleTrac.honkTime == nil then
        return superFunc( self, isPlaying, noEventSend )
    elseif g_currentMission.time < self.xerionSaddleTrac.honkTime then
        return superFunc( self, true, noEventSend )
    end
    return superFunc( self, isPlaying, noEventSend )
end

Honk.playHonk = Utils.overwrittenFunction( Honk.playHonk, XerionSaddleTrac.newPlayHonk )

function XerionSaddleTrac:setComplexSteeringMode(textId, bool)
    if self.setComplexSteeringVehicleModeId == nil or textId == nil then    
    elseif bool then
        if textId == "XerionSteerV2Mode" then
            -- steering is not in street mode => remember current mode
            self.xerionSaddleTrac.lastSteeringMode = self.complexSteeringVehicle.mode
        elseif self:getComplexSteeringVehicleModeId() == "XerionSteerV2Mode" then
            -- steering is in street mode => remember current mode
            self.xerionSaddleTrac.lastSteeringMode = self.complexSteeringVehicle.mode
        else
            -- no toggle between other modes
            self.xerionSaddleTrac.lastSteeringMode = nil
        end
        self:setComplexSteeringVehicleModeId( textId )
    elseif self:getComplexSteeringVehicleModeId() == textId then
        if self.xerionSaddleTrac.lastSteeringMode ~= nil then
            self:setComplexSteeringVehicleModeNumber( self.xerionSaddleTrac.lastSteeringMode )
        else
            self:setComplexSteeringVehicleModeId( "XerionSteerV2All" )
        end
    end
end

function XerionSaddleTrac:getComplexSteeringMode(textId)
    if self.setComplexSteeringVehicleModeId == nil or textId == nil then    
    elseif self:getComplexSteeringVehicleModeId() == textId then
        return true
    end
    return false
end


function XerionSaddleTrac:setCrabSteer(animTimeTab)
    self.xerionSaddleTrac.crabSteer = animTimeTab[1]
    if self.xerionSaddleTrac.getMSSLi(self) then
        self.complexSteeringVehicle.curCrabAngle = self.complexSteeringBase.maxCrabAngle * self.xerionSaddleTrac.crabSteer
    end
    if self.xerionSaddleTrac.getMSSRe(self) then
        self.complexSteeringVehicle.curCrabAngle = self.complexSteeringBase.minCrabAngle * self.xerionSaddleTrac.crabSteer
    end
end

function XerionSaddleTrac:getCrabSteer()
    if self.xerionSaddleTrac.getMSSLi(self) then
        self.xerionSaddleTrac.crabSteer = math.max( 0.01, self.complexSteeringVehicle.curCrabAngle / self.complexSteeringBase.maxCrabAngle )
    end
    if self.xerionSaddleTrac.getMSSRe(self) then
        self.xerionSaddleTrac.crabSteer = math.max( 0.01, self.complexSteeringVehicle.curCrabAngle / self.complexSteeringBase.minCrabAngle )
    end
    return { self.xerionSaddleTrac.crabSteer, 0 }
end

function XerionSaddleTrac:newDetachingIsPossible( superFunc )
    if      self.xerionSaddleTrac  ~= nil
            and self.selectedImplement ~= nil
            and self.xerionSaddleTrac.lockSemiTrailer
            and self.selectedImplement.jointDescIndex == 5 then
        return false
    end
    return superFunc( self )
end

function XerionSaddleTrac:newHandleDetachAttachableEvent( superFunc )
    if      self.xerionSaddleTrac  ~= nil
            and self.selectedImplement ~= nil
            and self.xerionSaddleTrac.lockSemiTrailer
            and self.selectedImplement.jointDescIndex == 5 then
        self.showDetachingNotAllowedTime = 2000;
        return false
    end
    return superFunc( self )
end;

Vehicle.detachingIsPossible         = Utils.overwrittenFunction( Vehicle.detachingIsPossible,         XerionSaddleTrac.newDetachingIsPossible )
Vehicle.handleDetachAttachableEvent = Utils.overwrittenFunction( Vehicle.handleDetachAttachableEvent, XerionSaddleTrac.newHandleDetachAttachableEvent )

