----
-- upsidedown 20.08.2013

ZF_gear = {};
-- local ZF_gear_directory = g_currentModDirectory;

-- source(Utils.getFilename("ZF_gear_Event.lua", ZF_gear_directory));
-- source(Utils.getFilename("ZF_gear_SaveEvent.lua", ZF_gear_directory));

function ZF_gear:prerequisitesPresent(specializations)
    return true;
    --return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function ZF_gear:load(savegame)
    self.ZF_gear = {};
    self.ZF_gear.diffRatio = self.motor.differentialRatio;
    --self.lastSpeedLevel = 0;
    self.ZF_gear.autoMode = false;
    self.ZF_gear.minScale = 1;--1.25; --vmax
    self.ZF_gear.maxScale = 8; --vmin
    self.ZF_gear.manualFactor = 1.0;
end;





function ZF_gear:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ZF_gear:keyEvent(unicode, sym, modifier, isDown)
end;

function ZF_gear:postUpdate(dt)


end;
function ZF_gear:updateTick(dt)

end;

function ZF_gear:update(dt)
        local needEvent = false;

        if self:getIsActiveForInput(false) then
            if not Input.isKeyPressed(Input.KEY_lshift) then
                if InputBinding.hasEvent(InputBinding.ZF_gear_auto) then
                    self.ZF_gear.autoMode = not self.ZF_gear.autoMode;
                    needEvent = true;
                end;
                
                if InputBinding.isPressed(InputBinding.ZF_gear_plus) then
                    self.ZF_gear.manualFactor = self.ZF_gear.manualFactor + dt*0.0003;
                    self.ZF_gear.manualFactor = Utils.clamp(self.ZF_gear.manualFactor,0,1);
                    needEvent = true;
                end;
                
                if InputBinding.isPressed(InputBinding.ZF_gear_minus) then
                    self.ZF_gear.manualFactor = self.ZF_gear.manualFactor - dt*0.0003;
                    self.ZF_gear.manualFactor = Utils.clamp(self.ZF_gear.manualFactor,0,1);
                    needEvent = true;
                end;
            end;
            
            if needEvent then
                -- print(self.ZF_gear.autoMode);
                -- print(self.ZF_gear.manualFactor);                
                -- MP
            end;
        end;
        
        if self:getIsActive() then
            if self.ZF_gear.autoMode then
                local optRpm = 1800;            
                local lastRpm = self.motor.lastMotorRpm;            
                local delta = (lastRpm - optRpm)/optRpm;                
                --delta = math.max(delta,-0.15)                
                local newRatio = self.motor.differentialRatio - (0.05 + (1-self.ZF_gear.manualFactor)*0.2)*delta*dt;            
            
                --self.motor.differentialRatio = Utils.clamp(newRatio,self.ZF_gear.minScale*self.ZF_gear.diffRatio,self.ZF_gear.maxScale*self.ZF_gear.diffRatio);
                self.motor.differentialRatio = Utils.clamp(newRatio,(self.ZF_gear.minScale + (1-self.ZF_gear.manualFactor)*(self.ZF_gear.maxScale-self.ZF_gear.minScale))*self.ZF_gear.diffRatio,self.ZF_gear.maxScale*self.ZF_gear.diffRatio);
            else
                self.motor.differentialRatio = (self.ZF_gear.minScale + (1-self.ZF_gear.manualFactor)*(self.ZF_gear.maxScale-self.ZF_gear.minScale))*self.ZF_gear.diffRatio;
            end;
        end;        
end;



function ZF_gear:draw()
    local ratio = self.ZF_gear.manualFactor;
    g_currentMission:addHelpButtonText(g_i18n:getText("ZF_mode"), InputBinding.ZF_gear_auto); 
    if self.ZF_gear.autoMode then
        g_currentMission:addExtraPrintText(g_i18n:getText("ZF_isAuto"));
        
        ratio = 1-(self.motor.differentialRatio - self.ZF_gear.minScale)/(self.ZF_gear.maxScale-self.ZF_gear.minScale)
        g_currentMission:addExtraPrintText(g_i18n:getText("ZF_setting") .. ": " .. string.format("%d%%",ratio*100));
    else
        g_currentMission:addExtraPrintText(g_i18n:getText("ZF_isNotAuto"));
        g_currentMission:addHelpButtonText(g_i18n:getText("ZF_plus"), InputBinding.ZF_gear_plus);
        g_currentMission:addHelpButtonText(g_i18n:getText("ZF_minus"), InputBinding.ZF_gear_minus); 
    end;
    g_currentMission:addExtraPrintText(g_i18n:getText("ZF_setting") .. ": " .. string.format("%d%%",self.ZF_gear.manualFactor*100));
end;


function ZF_gear:getSaveAttributesAndNodes(nodeIdent)
    local attributes = "";
    
    
    return attributes
end;


function ZF_gear:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
    if not resetVehicles then
        
    
    end;
    return BaseMission.VEHICLE_LOAD_OK;
end

function ZF_gear:delete()    
end

