--
--
--
--
--

cabinOpener = {};

cabinOpener.modDir = g_currentModDirectory;

function cabinOpener.prerequisitesPresent(specializations)
    return true; 
end;

function cabinOpener:load(savegame)

    self.playerCallbackcabin = SpecializationUtil.callSpecializationsFunction("playerCallbackcabin"); 
    
    self.cabinO = {};
    
    local trigger = Utils.indexToObject( self.components, getXMLString(xmlFile, string.format("vehicle.cabinOpener#trigger")) );
    if trigger == nil then
        print("[Error::cabinOpener] node is OK, but trigger could not be located. Check line "..tostring(i+1).." in your vehicle.xml");
    end;
    
    local icIndex = getXMLInt(xmlFile, string.format("vehicle.cabinOpener#icIndex", i));
    
    self.cabinO.icIndex = icIndex;
    self.cabinO.trigger = trigger;
    self.cabinO.plIR = false;
        
    addTrigger( trigger, "playerCallbackcabin", self );                
    
end;

function cabinOpener:delete()
    if self.cabinO.trigger ~= nil then
        removeTrigger(self.cabinO.trigger);
    end;
end;

function cabinOpener:readStream(streamId, connection)
end;

function cabinOpener:writeStream(streamId, connection)
end;

function cabinOpener:mouseEvent(posX, posY, isDown, isUp, button)
end;

function cabinOpener:keyEvent(unicode, sym, modifier, isDown)
end;

function cabinOpener:update(dt)
    
    if self.cabinO.plIR then
        g_currentMission:addHelpButtonText( g_i18n:getText("SET_cabinOPENER"), InputBinding.SET_cabinOPENER );    
        setTextColor(1.0, 1.0, 1.0, 1.0);
        setTextAlignment(RenderText.ALIGN_LEFT);                 
        renderText( 0.5, 0.06, 0.02, g_i18n:getText("SET_cabinOPENER") );
        if InputBinding.hasEvent(InputBinding.SET_cabinOPENER)then
            local obj = self.interactiveObjects[self.cabinO.icIndex];
            if obj ~= nil then
                --self.setcabin(not obj.isOpen);
                self:doActionOnObject(self.cabinO.icIndex);
            end;
            
            --self.vehicle:playAnimation(self.animation, dir, Utils.clamp(self.vehicle:getAnimationTime(self.animation), 0, 1), true);
        end
    end;
end;

function cabinOpener:onLeave()
end;

function cabinOpener:draw()
end;

function cabinOpener:playerCallbackcabin(triggerId, otherId, onEnter, onLeave, onStay)
    
    if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.cabinO.plIR = true;
    elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
        self.cabinO.plIR = false;
    end;
    
end;

