--
-- slaveRotations
--
-- author: upsidedown
-- date: 26.12.2013

-- NO RELEASE CANDIDATE!


slaveRotations = {};

function slaveRotations.prerequisitesPresent(specializations)
    return true; --SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function slaveRotations:load(savegame)
    
    self.slaveRotations = {};
    local i=0;
    while true do
        local areaKey = string.format("vehicle.slaveRotations.part(%d)", i);
        if not hasXMLProperty(xmlFile, areaKey) then            
            break;
        end
        
        local slaveRotation = {};
        
        slaveRotation.master = Utils.indexToObject(self.components, getXMLString(xmlFile, areaKey .. "#master"));
        slaveRotation.master2 = Utils.indexToObject(self.components, getXMLString(xmlFile, areaKey .. "#master2"));
        slaveRotation.slave = Utils.indexToObject(self.components, getXMLString(xmlFile, areaKey .. "#slave"));    
        
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, areaKey .. "#offset"));
        
        local key_x, key_y, key_z = Utils.getVectorFromString(getXMLString(xmlFile, areaKey .. "#axisMap"));
        
        local rat_x, rat_y, rat_z = Utils.getVectorFromString(getXMLString(xmlFile, areaKey .. "#ratio"));
        
        slaveRotation.offset = {};
        slaveRotation.offset[1] = Utils.getNoNil(x,0);
        slaveRotation.offset[2] = Utils.getNoNil(y,0);
        slaveRotation.offset[3] = Utils.getNoNil(z,0);
        
        slaveRotation.axisMap = {};
        slaveRotation.axisMap[1] = Utils.getNoNil(key_x,1);
        slaveRotation.axisMap[2] = Utils.getNoNil(key_y,2);
        slaveRotation.axisMap[3] = Utils.getNoNil(key_z,3);
        
        slaveRotation.ratio = {};
        slaveRotation.ratio[1] = Utils.getNoNil(rat_x,1);
        slaveRotation.ratio[2] = Utils.getNoNil(rat_y,1);
        slaveRotation.ratio[3] = Utils.getNoNil(rat_z,1);
                
        i = i + 1;
        self.slaveRotations[i] = slaveRotation;        
    end
    --print("slaveRotations loaded: ",i)
end;

function slaveRotations:delete()
    
end;

function slaveRotations:mouseEvent(posX, posY, isDown, isUp, button)
end;

function slaveRotations:keyEvent(unicode, sym, modifier, isDown)
end;

function slaveRotations:update(dt)
    if self:getIsActive() then
        for i,slaveRotation in pairs(self.slaveRotations) do
            local r_slave = {getRotation(slaveRotation.master)};
            if slaveRotation.master_2 ~= nil then --take average for differential gears
                local master2_rot = {getRotation(slaveRotation.master2)};
                --print(i,"  ",table.getn(master2_rot))
                for k=1,3 do
                    r_slave[k] = (r_slave[k] + master2_rot[k])*0.5;
                end;
            end;
            
            --print(rx," ",ry," ",rz)
            local ox,oy,oz = unpack(slaveRotation.offset);
            
            local newRot = {slaveRotation.ratio[1]*(r_slave[slaveRotation.axisMap[1]]-ox), slaveRotation.ratio[2]*(r_slave[slaveRotation.axisMap[2]]-oy), slaveRotation.ratio[3]*(r_slave[slaveRotation.axisMap[3]]-oz)}
            
            setRotation(slaveRotation.slave,unpack(newRot));            
        end;
    end;    
end;

function slaveRotations:updateTick(dt)
    
end;


function slaveRotations:draw()
    
end;


function slaveRotations:onDeactivate()
    
end;