--
-- GroundResponse Registration
--
--
-- @author GIANTS Software
-- @date 15/10/2016
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.
RegistrationHelper_FRM03_GR = {};
RegistrationHelper_FRM03_GR.isLoaded = false;

if SpecializationUtil.specializations['groundResponse'] == nil then
    SpecializationUtil.registerSpecialization('groundResponse', 'GroundResponse', g_currentModDirectory .. 'GroundResponse.lua')
    RegistrationHelper_FRM03_GR.isLoaded = false;
    RegistrationHelper_FRM03_GR.modDirectory = g_currentModDirectory;
end

function RegistrationHelper_FRM03_GR:loadMap(name)
    if not g_currentMission.registrationHelper_FRM03_GR_isLoaded then
        if not RegistrationHelper_FRM03_GR.isLoaded then
            self:register();

            -- load additional particle system as reference
            g_currentMission.wheelDirt = {};
            g_currentMission.wheelDirt.referencePS = {};

            local worldSpace = false;

            --
            local psFile = Utils.getFilename("particleSystems/soilDry.i3d", RegistrationHelper_FRM03_GR.modDirectory)
            local psRoot = loadI3DFile(psFile, false, false, false)

            local psNode = Utils.indexToObject(psRoot, "0");
            local ps = {};
            ParticleUtil.loadParticleSystemFromNode(psNode, ps, false, worldSpace, false);
            g_currentMission.wheelDirt.referencePS["soilDry"] = ps;
            link(getRootNode(), g_currentMission.wheelDirt.referencePS["soilDry"].shape);

            --
            local psFile = Utils.getFilename("particleSystems/soilWet.i3d", RegistrationHelper_FRM03_GR.modDirectory)
            local psRoot = loadI3DFile(psFile, false, false, false)

            local psNode = Utils.indexToObject(psRoot, "0");
            local ps = {};
            ParticleUtil.loadParticleSystemFromNode(psNode, ps, false, worldSpace, false);
            g_currentMission.wheelDirt.referencePS["soilWet"] = ps;
            link(getRootNode(), g_currentMission.wheelDirt.referencePS["soilWet"].shape);

            delete(psRoot);


            local shapeRoot = Utils.loadSharedI3DFile("particleSystems/mudEmitShape.i3d", RegistrationHelper_FRM03_GR.modDirectory, false, false, false);
            g_currentMission.wheelDirt.referenceShape = getChildAt(shapeRoot, 0);
            link(getRootNode(), g_currentMission.wheelDirt.referenceShape);
            delete(shapeRoot);

        end
        g_currentMission.registrationHelper_FRM03_GR_isLoaded = true
    else
        print("Error: ForRealModule03_GroundResponse has been loaded already!");
    end
end

function RegistrationHelper_FRM03_GR:deleteMap()
    g_currentMission.registrationHelper_FRM03_GR_isLoaded = nil
    if g_currentMission.wheelDirt.referencePS ~= nil then
        ParticleUtil.deleteParticleSystems(g_currentMission.wheelDirt.referencePS);
    end
    if g_currentMission.wheelDirt.referenceShape ~= nil then
        delete(g_currentMission.wheelDirt.referenceShape);
    end
end

function RegistrationHelper_FRM03_GR:keyEvent(unicode, sym, modifier, isDown)
end

function RegistrationHelper_FRM03_GR:mouseEvent(posX, posY, isDown, isUp, button)
end

function RegistrationHelper_FRM03_GR:update(dt)
end

function RegistrationHelper_FRM03_GR:draw()
end

function RegistrationHelper_FRM03_GR:register()
    for _, vehicle in pairs(VehicleTypeUtil.vehicleTypes) do
        if vehicle ~= nil then
            table.insert(vehicle.specializations, SpecializationUtil.getSpecialization("groundResponse"))
        end
    end
    RegistrationHelper_FRM03_GR.isLoaded = true
end

addModEventListener(RegistrationHelper_FRM03_GR)