--[[
PickUp Particlesystem fr Pressen oder Ladewagen.

Vorlage war hier die Claas3200.lua von TTM!

Anpassungen:                Ifko[nator]
Erstellt/angepasst am:        25.06.2013

Fix: Nun wird kein PS mehr erzeugt wenn man einen Ladewagen entleert.

Gefixt von Ifko[nator] am:    03.07.2013

Edit: 18.08.2013
Gendert wurde: StaticParticleSystem fr die KronePickupParticleSystems direkt eigebunden damit keine extra lua mehr notwendig ist.

Edit 2: 14.02.2014
Gendert wurde: Particlesystem fr Maisstroh hinzugefgt.

Edit 3: 19.02.2014
Gendert wurde: Particlesystem fr Hanfstroh hinzugefgt.

Edit 4: 28.02.2014
Gendert wurde: Unntige Frchte entfernt.

Edit 5: 04.03.2014
Gendert wurde: Exrta Particlesystem beim Pressen hinzugefgt.

Alle nderungen von: Ifko[nator]

Dieses Script ist Freiverwendbar! Sollt es ja auch nutzen.. ^^

Fr fragen bin ich via PN: 

auf www.ls-mapsource.de als "Ifko" 

oder auf www.modding-welt.com als "Ifkonator" zu erreichen.
]]

KronePickupParticleSystems = {};

function KronePickupParticleSystems.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function KronePickupParticleSystems:load(savegame)
    self.KronePresse = SpecializationUtil.callSpecializationsFunction("KronePresse");
    
    self.wheatParticleSystems = {};
    local i=0;
    while true do
        local key = string.format("vehicle.KronePickupParticleSystems.Straw(%d)", i);
        local node = getXMLString(xmlFile, key.. "#node");
        if node == nil then
            break;
        end;
        node = Utils.indexToObject(self.components, node);
        if node ~= nil then
            local psFile = getXMLString(xmlFile, key.. "#file");
            local wheatParticleSystem = {};
            wheatParticleSystem.particleSystem = {};
            StaticParticleSystem.loadParticleSystem(xmlFile, wheatParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
            table.insert(self.wheatParticleSystems, wheatParticleSystem);
        end;
        i = i+1;
    end;
    
    self.grassParticleSystems = {};
    local i=0;
    while true do
        local key = string.format("vehicle.KronePickupParticleSystems.Grass(%d)", i);
        local node = getXMLString(xmlFile, key.. "#node");
        if node == nil then
            break;
        end;
        node = Utils.indexToObject(self.components, node);
        if node ~= nil then
            local psFile = getXMLString(xmlFile, key.. "#file");
            local grassParticleSystem = {};
            grassParticleSystem.particleSystem = {};
            StaticParticleSystem.loadParticleSystem(xmlFile, grassParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
            table.insert(self.grassParticleSystems, grassParticleSystem);
        end;
        i = i+1;
    end;
    
    self.dryGrassParticleSystems = {};
    local i=0;
    while true do
        local key = string.format("vehicle.KronePickupParticleSystems.dryGrass(%d)", i);
        local node = getXMLString(xmlFile, key.. "#node");
        if node == nil then
            break;
        end;
        node = Utils.indexToObject(self.components, node);
        if node ~= nil then
            local psFile = getXMLString(xmlFile, key.. "#file");
            local dryGrassParticleSystem = {};
            dryGrassParticleSystem.particleSystem = {};
            StaticParticleSystem.loadParticleSystem(xmlFile, dryGrassParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
            table.insert(self.dryGrassParticleSystems, dryGrassParticleSystem);
        end;
        i = i+1;
    end;
    
    self.extraParticleSystems = {};
    local i=0;
    while true do
        local key = string.format("vehicle.KronePickupParticleSystems.extraParticleSystem(%d)", i);
        local node = getXMLString(xmlFile, key.. "#node");
        if node == nil then
            break;
        end;
        node = Utils.indexToObject(self.components, node);
        if node ~= nil then
            local psFile = getXMLString(xmlFile, key.. "#file");
            local extraParticleSystem = {};
            extraParticleSystem.particleSystem = {};
            Utils.loadParticleSystem(xmlFile, extraParticleSystem.particleSystem, key, self.components, false, nil, self.baseDirectory);
            table.insert(self.extraParticleSystems, extraParticleSystem);
        end;
        i = i+1;
    end;
end;

function KronePickupParticleSystems:delete()
    for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
        Utils.setEmittingState(wheatParticleSystem.particleSystem, false);
    end;
    for k, grassParticleSystem in pairs(self.grassParticleSystems) do
        Utils.setEmittingState(grassParticleSystem.particleSystem, false);
    end;
    for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
        Utils.setEmittingState(dryGrassParticleSystem.particleSystem, false);
    end;
    for _, extraParticleSystem in pairs(self.extraParticleSystems) do
        Utils.deleteParticleSystem(extraParticleSystem.particleSystem);
    end;
end;

function KronePickupParticleSystems:mouseEvent(posX, posY, isDown, isUp, button)
end;

function KronePickupParticleSystems:keyEvent(unicode, sym, modifier, isDown)
end;

function KronePickupParticleSystems:update(dt)
end;

function KronePickupParticleSystems:updateTick(dt)
    if  self.previousLevel ~= self.fillLevel then
        self.previousLevel = self.fillLevel;
        self:KronePresse(4, true);
    else
        self:KronePresse(4, false);
    end;
end;
    
function KronePickupParticleSystems:draw()
end;

function KronePickupParticleSystems:KronePresse(mode, state, noEventSend)
    if  mode == 4 and self.isTurnedOn then
        if  state then
            for _, extraParticleSystem in pairs(self.extraParticleSystems) do
                Utils.setEmittingState(extraParticleSystem.particleSystem, true);
            end;
            if FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_WHEAT or FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_BARLEY or
               FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_OAT or FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_RYE or 
               FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_RAPE then
                for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
                    Utils.setEmittingState(wheatParticleSystem.particleSystem, true);
                end;
            elseif FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_GRASS then
                for k, grassParticleSystem in pairs(self.grassParticleSystems) do
                    Utils.setEmittingState(grassParticleSystem.particleSystem, true);
                end;
            elseif FruitUtil.fillTypeToFruitType[self.currentFillType] == FruitUtil.FRUITTYPE_DRYGRASS then
                for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
                    Utils.setEmittingState(dryGrassParticleSystem.particleSystem, true);
                end;
            end;
        else
            for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
                Utils.setEmittingState(wheatParticleSystem.particleSystem, false);
            end;
            for k, grassParticleSystem in pairs(self.grassParticleSystems) do
                Utils.setEmittingState(grassParticleSystem.particleSystem, false);
            end;
            for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
                Utils.setEmittingState(dryGrassParticleSystem.particleSystem, false);
            end;
            for _, extraParticleSystem in pairs(self.extraParticleSystems) do
                Utils.setEmittingState(extraParticleSystem.particleSystem, false);
            end;
        end;
    else
        for k, wheatParticleSystem in pairs(self.wheatParticleSystems) do
            Utils.setEmittingState(wheatParticleSystem.particleSystem, false);
        end;
        for k, grassParticleSystem in pairs(self.grassParticleSystems) do
            Utils.setEmittingState(grassParticleSystem.particleSystem, false);
        end;
        for k, dryGrassParticleSystem in pairs(self.dryGrassParticleSystems) do
            Utils.setEmittingState(dryGrassParticleSystem.particleSystem, false);
        end;
        for _, extraParticleSystem in pairs(self.extraParticleSystems) do
            Utils.setEmittingState(extraParticleSystem.particleSystem, false);
        end;
    end;    
end;

-------------------------------------------------------------------------------------------------------------------------------------
-- StaticParticleSystem fr die KronePickupParticleSystems

StaticParticleSystem = {};

function StaticParticleSystem.loadParticleSystem(xmlFile, particleSystemTable, baseString, component, currentEmittingState, defaultParticleSystem, directory)
    local defaultLinkNode = component;
    local isStatic = Utils.getNoNil(isStaticParticle, false);
    local posStr = getXMLString(xmlFile, baseString .. "#position");
    local rotStr = getXMLString(xmlFile, baseString .. "#rotation");
    if type(component) == "table" then
        defaultLinkNode = component[1].node;
    end;
    local linkNode = Utils.getNoNil(Utils.indexToObject(component, getXMLString(xmlFile, baseString .. "#node")), defaultLinkNode);
    local psFile = getXMLString(xmlFile, baseString .. "#file");
    if psFile == nil then
        psFile = defaultParticleSystem;
    end
    if psFile == nil then
        return;
    end
    psFile = Utils.getFilename(psFile, directory);
    local rootNode = loadI3DFile(psFile);
    if rootNode == 0 then
        print("[ERROR der KronePickupParticleSystems.lua]: Das ParticleSystem '"..psFile.."' konnte nicht geladen werden. Dieses ParticleSystem ist daher inakiv.");
        return;
    end
    link(linkNode, rootNode);
    if posStr ~= nil and rotStr ~= nil then
        local posX, posY, posZ = Utils.getVectorFromString(posStr);
        local rotX, rotY, rotZ = Utils.getVectorFromString(rotStr);
        if posStr ~= nil and rotStr ~= nil then
            rotX = Utils.degToRad(rotX);
            rotY = Utils.degToRad(rotY);
            rotZ = Utils.degToRad(rotZ);
            setTranslation(rootNode, posX, posY, posZ);
            setRotation(rootNode, rotX, rotY, rotZ);
        end;
    end;
    for i=0, getNumOfChildren(rootNode)-1 do
        local child = getChildAt(rootNode, i);
        if getClassName(child) == "Shape" then
            local geometry = getGeometry(child);
            if geometry ~= 0 then
                if getClassName(geometry) == "ParticleSystem" then
                    table.insert(particleSystemTable, {geometry = geometry, shape = child});
                    if currentEmittingState ~= nil then
                        setEmittingState(geometry, currentEmittingState);
                    end;
                end;
            end;
        end;
    end;
    return rootNode;
end;