-- 
-- Fredzaza
--

TerraTrac = {};

function TerraTrac.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function TerraTrac:load(xmlFile)
	self.indexTracRight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TracWheelsRight#index"));	
	self.charIdAnimR = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TracWheelsRight#node"));
	self.clipIndexAnimR = getXMLString(xmlFile, "vehicle.TracWheelsRight#animationClip");
	self.spedR = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.TracWheelsRight#sped"))
	self.TracWheelsRight = {}
	local i = 0
	while true do
		local baseName = string.format("vehicle.TracWheelsRight.rotatingPart(%d)", i)
		local index = getXMLString(xmlFile, baseName .. "#index")
		if index == nil then
			break
		end
		local node = Utils.indexToObject(self.components, index)
		if node ~= nil then
			local entry = {}
			entry.node = node
			entry.speedScale = getXMLFloat(xmlFile, baseName .. "#speedScale")
			if entry.speedScale == nil then
				entry.speedScale = 1 / Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#radius"), 1)
			end
			table.insert(self.TracWheelsRight, entry)
		end
		i = i + 1		
	end
	
	self.indexTracLeft = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TracWheelsLeft#index"));	
	self.charIdAnimL = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.TracWheelsLeft#node"));
	self.clipIndexAnimL = getXMLString(xmlFile, "vehicle.TracWheelsLeft#animationClip");
	self.spedL = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.TracWheelsLeft#sped"))		
	self.TracWheelsLeft = {}
	local i = 0
	while true do
		local baseName = string.format("vehicle.TracWheelsLeft.rotatingPart(%d)", i)
		local index = getXMLString(xmlFile, baseName .. "#index")
		if index == nil then
			break
		end
		local node = Utils.indexToObject(self.components, index)
		if node ~= nil then
			local entry = {}
			entry.node = node
			entry.speedScale = getXMLFloat(xmlFile, baseName .. "#speedScale")
			if entry.speedScale == nil then
				entry.speedScale = 1 / Utils.getNoNil(getXMLFloat(xmlFile, baseName .. "#radius"), 1)
			end
			table.insert(self.TracWheelsLeft, entry)
		end
		i = i + 1		
	end
end;

function TerraTrac:delete()
end;

function TerraTrac:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TerraTrac:keyEvent(unicode, sym, modifier, isDown)
end;

function TerraTrac:update(dt) 
	if self.isMotorStarted then
		local newX1, newY1, newZ1 = getWorldTranslation(self.indexTracLeft);
		if self.lastTranslationL == nil then
			self.lastTranslationL = {newX1, newY1, newZ1};
		end;
		local dx1, dy1, dz1 = worldDirectionToLocal(self.indexTracLeft, newX1-self.lastTranslationL[1], newY1-self.lastTranslationL[2], newZ1-self.lastTranslationL[3]);
  	  local movingDirectionL = 0
		if self.lastSpeedReal > 1.0E-5 then	
			if dz1 < 1.0E-4 then
				movingDirectionL = -1;
			elseif dz1 > 1.0E-4 then
				movingDirectionL = 1;	
			end;
		end;	
		local lastMovedDistanceL = Utils.vector3Length(dx1, dy1, dz1);
 	   self.lastTranslationL[1] = newX1
 	   self.lastTranslationL[2] = newY1
 	   self.lastTranslationL[3] = newZ1
	
		local charIdL = getAnimCharacterSet(self.charIdAnimL);
		local clipIndexL = getAnimClipIndex(charIdL, self.clipIndexAnimL);
	
		assignAnimTrackClip(charIdL , 0, clipIndexL);
		setAnimTrackLoopState(charIdL, 0, true);
		setAnimTrackSpeedScale(charIdL, 0, self.spedL*lastMovedDistanceL*movingDirectionL);
		enableAnimTrack(charIdL, 0);

		for _, v in pairs(self.TracWheelsLeft) do
			rotate(v.node, v.speedScale * lastMovedDistanceL*movingDirectionL, 0, 0)
		end	

		local newX2, newY2, newZ2 = getWorldTranslation(self.indexTracRight);
		if self.lastTranslationR == nil then
			self.lastTranslationR = {newX2, newY2, newZ2};
		end;
		local dx2, dy2, dz2 = worldDirectionToLocal(self.indexTracRight, newX2-self.lastTranslationR[1], newY2-self.lastTranslationR[2], newZ2-self.lastTranslationR[3]);
  	  local movingDirectionR = 0
		if self.lastSpeedReal > 1.0E-5 then	
			if dz2 < 1.0E-4 then
				movingDirectionR = -1;
			elseif dz2 > 1.0E-4 then
				movingDirectionR = 1;		
			end;
		end;	
		local lastMovedDistanceR = Utils.vector3Length(dx2, dy2, dz2);	
 	   self.lastTranslationR[1] = newX2
  	  self.lastTranslationR[2] = newY2
  	  self.lastTranslationR[3] = newZ2	
		
		local charIdR = getAnimCharacterSet(self.charIdAnimR);
		local clipIndexR = getAnimClipIndex(charIdR, self.clipIndexAnimR);		

		assignAnimTrackClip(charIdR , 0, clipIndexR);
		setAnimTrackLoopState(charIdR, 0, true);
		setAnimTrackSpeedScale(charIdR, 0, self.spedR*lastMovedDistanceR*movingDirectionR);
		enableAnimTrack(charIdR, 0);
	
		for _, v in pairs(self.TracWheelsRight) do
			rotate(v.node, v.speedScale * lastMovedDistanceR*movingDirectionR, 0, 0)
		end;	  
	end;

end;

function TerraTrac:updateTick()	
end;

function TerraTrac:draw()	
end;

function TerraTrac:onDetach()
end;

function TerraTrac:onAttach()
end; 

function TerraTrac:onLeave()
		local charIdL = getAnimCharacterSet(self.charIdAnimL);
		local clipIndexL = getAnimClipIndex(charIdL, self.clipIndexAnimL);
	
		assignAnimTrackClip(charIdL , 0, clipIndexL);
		setAnimTrackLoopState(charIdL, 0, true);
		setAnimTrackSpeedScale(charIdL, 0, 0);
		enableAnimTrack(charIdL, 0);
		
		local charIdR = getAnimCharacterSet(self.charIdAnimR);
		local clipIndexR = getAnimClipIndex(charIdR, self.clipIndexAnimR);		

		assignAnimTrackClip(charIdR , 0, clipIndexR);
		setAnimTrackLoopState(charIdR, 0, true);
		setAnimTrackSpeedScale(charIdR, 0, 0);
		enableAnimTrack(charIdR, 0);
end;