--
-- SpeedJoystick
--
-- written by fruktor, visit: www.eifok-team.de
--

SpeedJoystick = {};

SpeedJoystick.modDir = g_currentModDirectory;

function SpeedJoystick.prerequisitesPresent(specializations)
    return true; 
end;

function SpeedJoystick:load(savegame)
	self.sj = {};
	self.sj.node = Utils.indexToObject( self.components, getXMLString(self.xmlFile, "vehicle.speedJoystick#node") );
	self.sj.rotF = math.rad( getXMLFloat(self.xmlFile, "vehicle.speedJoystick#rotFront") );
	self.sj.rotB = math.rad( getXMLFloat(self.xmlFile, "vehicle.speedJoystick#rotBack") );
	self.sj.rotT = 0;
	self.sj.rotC = 0;
end;

function SpeedJoystick:delete()

end;

function SpeedJoystick:readStream(streamId, connection)
end;

function SpeedJoystick:writeStream(streamId, connection)
end;

function SpeedJoystick:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SpeedJoystick:keyEvent(unicode, sym, modifier, isDown)
end;

function SpeedJoystick:update(dt)

	if self.movingDirection > 0 and self.lastSpeed*3600 > 3 and self.sj.rotF == false then
		self.sj.rotF = true;
	elseif self.sj.rotF == true and (self.lastSpeed*3600 < 3 or self.movingDirection < 0) then
		self.sj.rotF = false;	
	end;
	if self.movingDirection < 0 and self.lastSpeed*3600 > 3 and self.sj.rotB == false then
		self.sj.rotB = true;
	elseif self.sj.rotB == true and (self.lastSpeed*3600 < 3 or self.movingDirection > 0) then
		self.sj.rotB = false;	
	end;
	if self.movingDirection < 0 then
				self.sj.rotT = -self.sj.rotF*self.movingDirection;
			elseif self.movingDirection > 0 then
				self.sj.rotT = self.sj.rotB*self.movingDirection;
			else
				self.sj.rotT = 0;
			end		
				
			if self.sj.rotC < self.sj.rotT then
				self.sj.rotC = self.sj.rotC + dt/1000;
				if self.sj.rotC > self.sj.rotT then
					self.sj.rotC = self.sj.rotT;
				end;
			elseif self.sj.rotC > self.sj.rotT then
				self.sj.rotC = self.sj.rotC - dt/1000;
				if self.sj.rotC < self.sj.rotT then
					self.sj.rotC = self.sj.rotT;
				end;
			end;
			
			setRotation( self.sj.node, self.sj.rotC, 0, 0 );
			if self.motor.speedLevel ~= 0 then
	end;
	
end;
	
--print("inputW="..tostring(axisForward).." self.movingDirection="..tostring(self.movingDirection).." "..tostring(self.lastSpeed).."   self.lastSpeedReal="..tostring(self.lastSpeedReal));


function SpeedJoystick:updateTick(dt)

end;

function SpeedJoystick:onLeave()
end;

function SpeedJoystick:draw()
end;





--
--
--
--
--
