
-- JohnDeere 8R
-- Date 6.11.2016
-- Copyright (C) Slavo LS Modding

johndeere8 = {};

function johndeere8.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function johndeere8:load(xmlFile)
	self.cu = false;
	self.uvg = false;
	self.m = 1;

	self.variogrip = true;
	self.hasVarioGrip = true;

	self.seatSusp = false;

	--self.podsvietenie = Utils.indexToObject(self.components, "0>4|1|4|1");

	self.GreenStarJazda = Utils.indexToObject(self.components, "0>19|1|0|8|0|5|0|0|0");
	self.GreenStarPraca = Utils.indexToObject(self.components, "0>19|1|0|13");

	self.svetla = Utils.indexToObject(self.components, "0>10");

	self.Panel = Utils.indexToObject(self.components, "0>19|1|0|12");
	self.PanelHudSpeed = Utils.indexToObject(self.components, "0>19|1|0|27");
	self.PanelHudRpm = Utils.indexToObject(self.components, "0>19|1|0|26");
	self.PanelHudTime = Utils.indexToObject(self.components, "0>19|1|0|29");
	self.PanelHudKMh = Utils.indexToObject(self.components, "0>19|1|0|10");
	self.PanelHudRpm1 = Utils.indexToObject(self.components, "0>19|1|0|11");

	print("  JohnDeere 6R von T0bi69");

	setVisibility(self.GreenStarJazda, false);
	setVisibility(self.GreenStarPraca, false);
	setVisibility(self.Panel, false);
	setVisibility(self.PanelHudSpeed, false);
	setVisibility(self.PanelHudRpm, false);
	setVisibility(self.PanelHudTime, false);
	setVisibility(self.PanelHudKMh, false);
	setVisibility(self.PanelHudRpm1, false);

	self.suspFront = self.wheels[1].suspTravel;
	self.suspBack = self.wheels[3].suspTravel;

	self.deformFront = self.wheels[1].maxDeformation;
	self.deformBack = self.wheels[3].maxDeformation;

	self.frictionFront = self.wheels[1].frictionScale;
	self.frictionBack = self.wheels[3].frictionScale;
end;

function johndeere8:delete()
end;

function johndeere8:readStream(streamId, connection)
end;

function johndeere8:writeStream(streamId, connection)
end;

function johndeere8:mouseEvent(posX, posY, isDown, isUp, button)
end;

function johndeere8:keyEvent(unicode, sym, modifier, isDown)
end;

function johndeere8:update(dt)

	if self.isMotorStarted then
		if(self.seatSusp) then
			setTranslation(self.seatID, self.startSeatXTranslation, self.startSeatYTranslation+self.wheels[4].deltaY, self.startSeatZTranslation);
		end;

		if InputBinding.hasEvent(InputBinding.VarioGrip) then
			if (self.hasVarioGrip) then
				self.variogrip = not self.variogrip;
				self.uvg = true;
				if (self.variogrip) then t = 3; else t = 1; end;
			end;
		end;

		if(self.uvg == true) then
		    for i, wheel in ipairs(self.wheels) do
		    	if(self.variogrip) then

		    		if(self.deformFront*t > wheel.maxDeformation) then
		    			self.m = self.m+0.001;

			    		if((i == 1) or (i == 2)) then
			    			wheel.maxDeformation = self.deformFront*self.m;
			    			wheel.frictionScale = self.frictionFront*self.m;
			    		else 
			    			wheel.maxDeformation = self.deformBack*self.m;
			    			wheel.frictionScale = self.frictionBack*self.m;
			    		end;
			    		wheel.suspTravel = wheel.suspTravel - (self.m / 10000);
			    		self:updateWheelTireFriction(wheel);
			    		self:updateWheelBase(wheel);
			    	else
			    		self.uvg = false;
		    		end;
		    	else
		    		if(self.deformFront*t < wheel.maxDeformation) then
		    			self.m = self.m-0.001;

			    		if((i == 1) or (i == 2)) then
			    			wheel.maxDeformation = self.deformFront*self.m;
			    			wheel.frictionScale = self.frictionFront*self.m;
			    		else 
			    			wheel.maxDeformation = self.deformBack*self.m;
			    			wheel.frictionScale = self.frictionBack*self.m;
			    		end;
			    		wheel.suspTravel = wheel.suspTravel + (self.m / 10000);
			    		self:updateWheelTireFriction(wheel);
			    		self:updateWheelBase(wheel);
		    		else 
						self.uvg = false;
		    		end;
		    	end;
			end;

		end;
	end;

end;

function johndeere8:updateTick(dt)

   if self:getIsActive() then
		if self.isMotorStarted then

			setVisibility(self.GreenStarJazda, true);
			setVisibility(self.GreenStarPraca, false);
			setVisibility(self.Panel, true);
			setVisibility(self.PanelHudSpeed, true);
			setVisibility(self.PanelHudRpm, true);
			setVisibility(self.PanelHudTime, true);
			setVisibility(self.PanelHudKMh, true);
			setVisibility(self.PanelHudRpm1, true);

			--if( getVisibility(self.svetla) == true ) then
			--	setVisibility(self.dashlight, true);
			--else
			--	setVisibility(self.dashlight, false);
			--end;
		else
			setVisibility(self.GreenStarJazda, false);
			setVisibility(self.GreenStarPraca, false);
			setVisibility(self.Panel, false);
			setVisibility(self.PanelHudSpeed, false);
			setVisibility(self.PanelHudRpm, false);
			setVisibility(self.PanelHudTime, false);
			setVisibility(self.PanelHudKMh, false);
			setVisibility(self.PanelHudRpm1, false);
		end;
	end;
end;

function johndeere8:draw()
end;

function johndeere8:onLeave()
end;

function johndeere8:onEnter()
end;