Roue = {};

function Roue.prerequisitesPresent(specializations)
    return true;
end;

function Roue:load(savegame)
    self.changeSteer = SpecializationUtil.callSpecializationsFunction("changeSteer");
	self.changeWheel =0;
	self.lastValidChangeWheel = -1;
end;

function Roue:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)  
   if not resetVehicles then
       self.changeWheel = Utils.getNoNil(getXMLFloat(self.xmlFile, key.."#steermode"),0);
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Roue:getSaveAttributesAndNodes(nodeIdent)
   local attributes = ' steermode="'..tonumber(self.changeWheel)..'"';
   return attributes, nil;
end;

function Roue:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Roue:keyEvent(unicode, sym, modifier, isDown)
end;

function Roue:update(dt)	
	if self.changeWheelsBackup == nil then
		self.changeWheelsBackup = {};
		for _,wheel in pairs(self.wheels) do
			backup = {};
			backup.rotSpeed = wheel.rotSpeed;
			backup.rotMin   = wheel.rotMin;
			backup.rotMax   = wheel.rotMax;
			table.insert(self.changeWheelsBackup,backup);
		end;
	end;
	
	if InputBinding.hasEvent(InputBinding.cw_for_xerion) and self:getIsActiveForInput() then
		self.changeWheel = self.changeWheel + 1 ;
	end; 
	
	if self.lastValidChangeWheel ~= self.changeWheel then			
		if self.changeWheel == 1 then
			self:changeSteer(1,1,0,0)
		elseif self.changeWheel == 2 then
			self:changeSteer(0,0,1,1)
		elseif self.changeWheel == 3 then
			self:changeSteer(1,1,-1,-1)
		else
			self.changeWheel = 0;
			self:changeSteer(1,1,1,1)
		end;
		self.lastValidChangeWheel = self.changeWheel;
	end;
end;

function Roue:draw()
	if self.changeWheel == 0 then
		g_currentMission:addHelpButtonText(g_i18n:getText("cw_for_xerion1"), InputBinding.cw_for_xerion); 
	elseif 	self.changeWheel == 1 then
		g_currentMission:addHelpButtonText(g_i18n:getText("cw_for_xerion2"), InputBinding.cw_for_xerion); 
	elseif 	self.changeWheel == 2 then
		g_currentMission:addHelpButtonText(g_i18n:getText("cw_for_xerion3"), InputBinding.cw_for_xerion); 
	elseif 	self.changeWheel == 3 then
		g_currentMission:addHelpButtonText(g_i18n:getText("cw_for_xerion4"), InputBinding.cw_for_xerion); 
	else	
		g_currentMission:addHelpButtonText(g_i18n:getText("cw_for_xerion"), InputBinding.cw_for_xerion); 
	end;	
end;

function Roue:changeSteer(f1,f2,f3,f4)
	local speed = 1;
	
	if     ( self.wheels[1].rotSpeed > 0 and self.changeWheelsBackup[1].rotSpeed > 0 )
		or ( self.wheels[1].rotSpeed < 0 and self.changeWheelsBackup[1].rotSpeed < 0 ) then
		speed = 1;
	elseif ( self.wheels[1].rotSpeed < 0 and self.changeWheelsBackup[1].rotSpeed > 0 )
		or ( self.wheels[1].rotSpeed > 0 and self.changeWheelsBackup[1].rotSpeed < 0 ) then
		speed = -1;
	elseif ( self.wheels[3].rotSpeed > 0 and self.changeWheelsBackup[3].rotSpeed > 0 )
		or ( self.wheels[3].rotSpeed < 0 and self.changeWheelsBackup[3].rotSpeed < 0 ) then
		speed = 1;
	elseif ( self.wheels[3].rotSpeed < 0 and self.changeWheelsBackup[3].rotSpeed > 0 )
 		or ( self.wheels[3].rotSpeed > 0 and self.changeWheelsBackup[3].rotSpeed < 0 ) then
		speed = -1;
	end;
	
	if f1 == 1 and f3 == 1 then
		speed = speed * 0.7;
	end;
	
	local f = {f1,f2,f3,f4};
	for i,wheel in pairs(self.wheels) do
		wheel.rotMin   = self.changeWheelsBackup[i].rotMin * math.abs( f[i] );
		wheel.rotMax   = self.changeWheelsBackup[i].rotMax * math.abs( f[i] );
		wheel.rotSpeed = self.changeWheelsBackup[i].rotSpeed * speed * f[i];

		if self.isRealistic then
			-- for realistic vehicle, adding minRotSpeed and maxRotSpeed
			wheel.realRotMaxSpeed = 0;
			wheel.realRotMinSpeed = 0;
	
			--print("RealisticVehicle.loadDynamicWheelDataFromXML - wheel.rotMax="..tostring(wheel.rotMax) .. " / wheel.rotMin="..tostring(wheel.rotMin) .. " /  wheel.rotSpeed="..tostring(wheel.rotSpeed));
	
			if wheel.rotMax~=0 and wheel.rotMin~=0 and wheel.rotSpeed~=0 then	
	
				if math.abs(wheel.rotMax)>math.abs(wheel.rotMin) then
					wheel.realRotMaxSpeed = wheel.rotSpeed;
					wheel.realRotMinSpeed = math.abs(wheel.rotMin/wheel.rotMax)*wheel.rotSpeed;
				else
					wheel.realRotMinSpeed = wheel.rotSpeed;
					wheel.realRotMaxSpeed = math.abs(wheel.rotMax/wheel.rotMin)*wheel.rotSpeed;
				end;
		
				if wheel.rotSpeed<0 then
					local tmp = wheel.realRotMaxSpeed;
					wheel.realRotMaxSpeed = wheel.realRotMinSpeed;
					wheel.realRotMinSpeed = tmp;
				end;
			end;
		end;
	end;
end;

function Roue:delete()
end;