-- displayFunctions
--
-- Author RivalBomb

displayFunctions = {};
function displayFunctions.prerequisitesPresent(specializations)
    return true;
end;

function displayFunctions:load(xmlFile)
	self.displayFunctions = {};
	
	local key = "vehicle.displayFunctions.";
	self.displayFunctions.warning = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."warnLight#index"));
	self.displayFunctions.forward = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."forward#index"));
	self.displayFunctions.reverse = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."reverse#index"));
	self.displayFunctions.preHeating = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."preHeating#index"));
	self.displayFunctions.battery = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."battery#index"));
	self.displayFunctions.blinker1 = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."blinker1#index"));
	self.displayFunctions.blinker2 = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."blinker2#index"));
	self.displayFunctions.handbrake = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."handbrake#index"));
	self.displayFunctions.WSH = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."wendeschalthebel#index"));
	self.displayFunctions.wshForRot = getXMLString(xmlFile, key.."wendeschalthebel#forwardRot");
	self.displayFunctions.wshBackRot = getXMLString(xmlFile, key.."wendeschalthebel#reverseRot");
	self.displayFunctions.piepSound = Utils.loadSample(xmlFile, {}, "vehicle.piepSound", nil, self.baseDirectory, self.components[1].node);
	
	self.displayFunctions.timer = 0; -- timer for warning light
	self.displayFunctions.warnBlinkSpeed = 500;	-- 0.5 sec
	self.displayFunctions.warningLightActive = true;
	self.hasAttachedTrailers = 0;
	
	-- interior turn lights
	self.interiorTS = {};
	self.interiorTS.t2 = 0;
	self.interiorTS.leftIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnSignals.interiorTurnSignals#left"));
	self.interiorTS.rightIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnSignals.interiorTurnSignals#right"));
	self.interiorTS.warnIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.turnSignals.interiorTurnSignals#hazard"));
	self.displayFunctions.t = 0;
	
	
	self.blinkerHebel = {};
	self.blinkerHebel.index = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."blinkerhebel#index"))
	self.blinkerHebel.rotLeft = getXMLString(xmlFile, key.."blinkerhebel#rotLeft");
	self.blinkerHebel.rotRight = getXMLString(xmlFile, key.."blinkerhebel#rotRight");
	self.blinkerHebel.rotNormal = getXMLString(xmlFile, key.."blinkerhebel#rotNormal");
	
	self.startUpAnimation = getXMLString(xmlFile, "vehicle.startUpAnimation#name");
	self.firstrun = false;
end;

function displayFunctions:delete()
	if self.displayFunctions.piepSound ~= nil then
		Utils.deleteSample(self.displayFunctions.piepSound);
	end;
end;

function displayFunctions:mouseEvent(posX, posY, isDown, isUp, button)
end;

function displayFunctions:keyEvent(unicode, sym, modifier, isDown)
end;

function displayFunctions:update(dt)
	self.interiorTS.t2=self.interiorTS.t2+dt;
	if self.interiorTS.t2 > self.displayFunctions.warnBlinkSpeed then
		self.displayFunctions.warningLightActive = not self.displayFunctions.warningLightActive;
		self.interiorTS.t2=0;
	end;
	
	local mFlickering=Utils.clamp(math.cos( 7.0 * (g_currentMission.time/1000) ) + 0.2, 0, 1);
	if self:getIsActive() then
		if (self.turnSignalState == 1 or self.turnSignalState == 3) and mFlickering == 0  then 	-- Blinker links
			if self.interiorTS.leftIndex ~= nil then
				setVisibility(self.interiorTS.leftIndex, true);
			end;
		else
			if self.interiorTS.leftIndex ~= nil then
				setVisibility(self.interiorTS.leftIndex, false);
			end;
		end;
		if (self.turnSignalState == 2 or self.turnSignalState == 3) and mFlickering == 0 then	-- Blinker rechts
			if self.interiorTS.rightIndex ~= nil then
				setVisibility(self.interiorTS.rightIndex, true);
			end;
		else
			if self.interiorTS.rightIndex ~= nil then
				setVisibility(self.interiorTS.rightIndex, false);
			end;
		end;
		if self.turnSignalState == 3 and mFlickering == 0 then	-- Warnblinker
			if self.interiorTS.warnIndex ~= nil then
				setVisibility(self.interiorTS.warnIndex, true);
			end;
		else
			if self.interiorTS.warnIndex ~= nil then
				setVisibility(self.interiorTS.warnIndex, false);
			end;
		end;
		
		if self.displayFunctions.handbrake ~= nil then
			if g_currentMission.driveControl ~= nil and g_currentMission.driveControl.useModules ~= nil and g_currentMission.driveControl.useModules.handBrake ~= nil and g_currentMission.driveControl.useModules.handBrake and self.driveControl ~= nil and self.driveControl.handBrake ~= nil and self.driveControl.handBrake.isActive ~= nil then
				if self.driveControl.handBrake.isActive then
					setVisibility(self.displayFunctions.handbrake, true);
				else
					setVisibility(self.displayFunctions.handbrake, false);
				end;
			end;
		end;
		
		
			-- Forward / Reverse --
		if self:getLastSpeed() * self.speedDisplayScale > 1 and self.movingDirection > 0 then
			if self.displayFunctions.forward ~= nil then
				setVisibility(self.displayFunctions.forward, true);
			end;
			if self.displayFunctions.WSH ~= nil then
				setRotation(self.displayFunctions.WSH, 0, math.rad(self.displayFunctions.wshForRot), 0);
			end;
		elseif self:getLastSpeed() * self.speedDisplayScale > 1 and self.movingDirection < 0 then
			if self.displayFunctions.reverse ~= nil then
				setVisibility(self.displayFunctions.reverse, true);
			end;
			if self.displayFunctions.WSH ~= nil then
				setRotation(self.displayFunctions.WSH, 0, math.rad(self.displayFunctions.wshBackRot), 0);
			end;
		else
			if self.displayFunctions.forward ~= nil then
				setVisibility(self.displayFunctions.forward, false);
			end;
			if self.displayFunctions.reverse ~= nil then
				setVisibility(self.displayFunctions.reverse, false);
			end;
			if self.displayFunctions.WSH ~= nil then
				setRotation(self.displayFunctions.WSH, 0, 0, 0);
			end;
		end;
		
		-- preHeating --
		if (self.ignitionMode ~= nil and self.ignitionMode == ManualIgnition.STAGE_PRE_HEAT) or (self.driveControl ~=nil and self.driveControl.manMotorStart.isMotorStarted ~= nil and self.driveControl.manMotorStart.isMotorStarted == false and self.driveControl.manMotorStart.startCnt ~= nil and self.driveControl.manMotorStart.startCnt < 800 and self.driveControl.manMotorStart.startCnt > 0) then 
			self.displayFunctions.t=self.displayFunctions.t+dt;
			if self.displayFunctions.preHeating ~= nil then
				if self.displayFunctions.t <= 2000 then
					setVisibility(self.displayFunctions.preHeating, true);
				else
					setVisibility(self.displayFunctions.preHeating, false);
				end;
			end;
			if self.displayFunctions.battery ~= nil then
				setVisibility(self.displayFunctions.battery, true);
			end;
			self.displayFunctions.timer = self.interiorTS.t2;
			if self.displayFunctions.timer >= self.displayFunctions.warnBlinkSpeed then
				self.displayFunctions.warningLightActive = not self.displayFunctions.warningLightActive;
				self.displayFunctions.timer=0;
			end;
			if self.displayFunctions.warning ~= nil then
				setVisibility(self.displayFunctions.warning, self.displayFunctions.warningLightActive);
				--setVisibility(self.displayFunctions.warning, true);
			end;
			if self.displayFunctions.piepSound ~= nil then
				if not Utils.isSamplePlaying(self.displayFunctions.piepSound) then
					Utils.playSample(self.displayFunctions.piepSound,0,1,nil);
				end;
			end;
			if self.startUpAnimation ~= nil and self.playAnimation ~= nil and not self.firstrun then
				self:playAnimation(self.startUpAnimation, 1, nil, true);
			end;
			self.firstrun = true;
		else
			self.firstrun = false;
			if self.displayFunctions.piepSound ~= nil then
				if Utils.isSamplePlaying(self.displayFunctions.piepSound) then
					Utils.stopSample(self.displayFunctions.piepSound, true);
				end;
			end;
			if self.displayFunctions.preHeating ~= nil then
				setVisibility(self.displayFunctions.preHeating, false);
				self.displayFunctions.t=0;
			end;
			if self.displayFunctions.battery ~= nil then
				setVisibility(self.displayFunctions.battery, false);
			end;
			if self.displayFunctions.warning ~= nil then
				self.displayFunctions.warningLightActive = false;
				setVisibility(self.displayFunctions.warning, self.displayFunctions.warningLightActive);
				--setVisibility(self.displayFunctions.warning, false);
			end;
		end;
		if (self.ignitionMode ~= nil and not self.ignitionMode == ManualIgnition.STAGE_OFF) or (self.driveControl ~=nil and self.driveControl.manMotorStart.isMotorStarted ~= nil and not self.driveControl.manMotorStart.isMotorStarted) then
			if self.startUpAnimation ~= nil and self.playAnimation ~= nil and (self.animations[self.startUpAnimation].currentTime > 0) and not self.firstrun then
				self:playAnimation(self.startUpAnimation, -100, nil, true);
			end;
		end;
	end;
end;

function displayFunctions:updateTick(dt)

	-- blinker light 1 and 2 --
	if table.getn(self.attachedImplements) > 0 or self.hasAttachedTrailers > 0 then
		self.hasAttachedTrailers = 0;
		for i=1, table.getn(self.attachedImplements) do  
			if self.attachedImplements[i].object.turnSignals.left[1] ~= nil and self.attachedImplements[i].object.turnSignals.right[1] ~= nil then 
				self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
			end;
			if table.getn(self.attachedImplements[i].object.attachedImplements) > 0 then
				for r=1, table.getn(self.attachedImplements[i].object.attachedImplements) do
					if self.attachedImplements[i].object.attachedImplements[r].object.turnSignals.left[1] ~= nil and self.attachedImplements[i].object.attachedImplements[r].object.turnSignals.right[1] ~= nil then 
						self.hasAttachedTrailers = 	self.hasAttachedTrailers +1;
					end;
				end;
			end;
		end;
	local mFlickering=Utils.clamp(math.cos( 7.0 * (g_currentMission.time/1000) ) + 0.2, 0, 1);
		if self.displayFunctions.blinker1 ~= nil and self.displayFunctions.blinker2 ~= nil then
			if self.turnSignalState ~= 0 then
				if self.hasAttachedTrailers == 0 then
					setVisibility(self.displayFunctions.blinker1, false);
					setVisibility(self.displayFunctions.blinker2, false);
				elseif self.hasAttachedTrailers == 1 then
					setVisibility(self.displayFunctions.blinker1, mFlickering == 0);
					setVisibility(self.displayFunctions.blinker2, false);
				elseif self.hasAttachedTrailers == 2 then
					setVisibility(self.displayFunctions.blinker1, mFlickering == 0);
					setVisibility(self.displayFunctions.blinker2, mFlickering == 0);
				end;
			else
				setVisibility(self.displayFunctions.blinker1, false);
				setVisibility(self.displayFunctions.blinker2, false);
			end;
		end;
	end;
	if self.turnSignalState~=nil then
		if self.turnSignalState==1 then	-- Blinker links
			setRotation(self.blinkerHebel.index, 0, 0, math.rad(self.blinkerHebel.rotLeft));
		elseif self.turnSignalState==2 then	-- Blinker rechts
			setRotation(self.blinkerHebel.index, 0, 0, math.rad(self.blinkerHebel.rotRight));
		else -- kein Blinker aktiv / Warnblinker
			setRotation(self.blinkerHebel.index, 0, 0, math.rad(self.blinkerHebel.rotNormal));
		end;
    end;
end;

function displayFunctions:draw()
end;