--edit hummel (modhoster.de)
moveZugmaul = {};

function moveZugmaul.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function moveZugmaul:load(savegame)
    self.setyZugmaul= SpecializationUtil.callSpecializationsFunction("setyZugmaul");
    self.moveableZugmaul = {};
    self.moveableZugmaul.index = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.moveableZugmaul#index"));
    self.moveableZugmaul.max = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableZugmaul#maxY"), 0); 
    self.moveableZugmaul.min = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.moveableZugmaul#minY"), 0); 
    
    if self.moveableZugmaul ~= nil then
        local _, yZugmaul, _ = getTranslation(self.moveableZugmaul.index);
        self.yZugmaul = yZugmaul
    end
    
end;

function moveZugmaul:delete()
end;

function moveZugmaul:mouseEvent(posX, posY, isDown, isUp, button)
end;

function moveZugmaul:keyEvent(unicode, sym, modifier, isDown)

end;

function moveZugmaul:update(dt)
    if self:getIsActiveForInput() then
        if self.moveableZugmaul ~= nil then
            local _, yZugmaul, _ = getTranslation(self.moveableZugmaul.index);
            local moveSpeed = 0.0002*dt;
            if InputBinding.isPressed(InputBinding.Zugmaul_auf) then
                if self.yZugmaul < self.moveableZugmaul.max then
                    self.yZugmaul = yZugmaul + moveSpeed;
                else
                    self.yZugmaul = self.moveableZugmaul.max;
                end;
                   self:setyZugmaul(self.yZugmaul);
            elseif InputBinding.isPressed(InputBinding.Zugmaul_ab)  then
                if self.yZugmaul > self.moveableZugmaul.min then
                    self.yZugmaul = yZugmaul - moveSpeed;
                else
                    self.yZugmaul = self.moveableZugmaul.min;
                end;
                   self:setyZugmaul(self.yZugmaul);
            end;
        end;
    end;            
end;

function moveZugmaul:setyZugmaul(value, noEventSend)
  local xZugmaul, yZugmaul, zZugmaul = getTranslation(self.moveableZugmaul.index);
  moveZugmaulEvent.sendEvent(self, value, noEventSend);
  self.yZugmaul = value
  setTranslation(self.moveableZugmaul.index, xZugmaul, self.yZugmaul, zZugmaul);
end

function moveZugmaul:readStream(streamId, connection)
    self.yZugmaul = streamReadFloat32(streamId);    
end;

function moveZugmaul:writeStream(streamId, connection)
    streamWriteFloat32(streamId, self.yZugmaul);
end;

function moveZugmaul:onLeave()
end;

function moveZugmaul:draw()
    g_currentMission:addExtraPrintText(string.format(g_i18n:getText("ATTACHER_CONTROLS_Z"), self.typeDesc) .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.Zugmaul_auf) .. "/" .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.Zugmaul_ab));
end;

function moveZugmaul:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;

moveZugmaulEvent = {};
moveZugmaulEvent_mt = Class(moveZugmaulEvent, Event);

InitEventClass(moveZugmaulEvent, "moveZugmaulEvent");

function moveZugmaulEvent:emptyNew()
    local self = Event:new(moveZugmaulEvent_mt);
    self.className="moveZugmaulEvent";
    return self;
end;

function moveZugmaulEvent:new(object, data)
    local self = moveZugmaulEvent:emptyNew()
    self.object = object;
    self.data = data;
    return self;
end;

function moveZugmaulEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.object = networkGetObject(id);    
    self.data = streamReadFloat32(streamId);
    self:run(connection);
end;

function moveZugmaulEvent:run(connection)
    self.object:setyZugmaul(self.data , true);
    if not connection:getIsServer() then  
      g_server:broadcastEvent(moveZugmaulEvent:new(self.object, self.data), nil, connection, self.object);
    end;
end;

function moveZugmaulEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteFloat32(streamId, self.data);
end;

              
function moveZugmaulEvent.sendEvent(vehicle, data, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(moveZugmaulEvent:new(vehicle, data), nil, nil, vehicle);
        else
            g_client:getServerConnection():sendEvent(moveZugmaulEvent:new(vehicle, data));
        end;
    end
end;



