
-- NHT9SmartTrax
-- Specialization for NHT9SmartTrax mod
-- Date 22/12/2014
-- Copyright (C) fozzy691
-- Contact via PM @ romuald.brun691@orange.fr

Joystick = {};

Joystick.modDir = g_currentModDirectory;

function Joystick.prerequisitesPresent(specializations)
    return true; 
end;

function Joystick:load(savegame)
    self.joystick = {};
    self.joystick.node = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.Joystick#node") );
    self.joystick.rotF = math.rad( getXMLFloat(xmlFile, "vehicle.Joystick#rotFront") );
    self.joystick.rotB = math.rad( getXMLFloat(xmlFile, "vehicle.Joystick#rotBack") );
    self.joystick.rotT = 0;
    self.joystick.rotC = 0;
    
    self.forceJoystick_time = 0;
end;

function Joystick:delete()

end;

function Joystick:readStream(streamId, connection)
end;

function Joystick:writeStream(streamId, connection)
end;

function Joystick:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Joystick:keyEvent(unicode, sym, modifier, isDown)
end;

function Joystick:update(dt)

    if self:getIsActive() then
        if self.isClient then
            
            local axisForward = 0;
            axisForward = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
            if InputBinding.isAxisZero(axisForward) then
                axisForward = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE)
            end;
            if axisForward < 0 then
                self.joystick.rotT = -self.joystick.rotF*axisForward;
            elseif axisForward > 0 then
                self.joystick.rotT = self.joystick.rotB*axisForward;
            else
                self.joystick.rotT = 0;
            end
            
            if self.forceJoystick_time > self.time then
                if self.forceJoystick == true then
                    self.joystick.rotT = self.joystick.rotF/2;
                else
                    self.joystick.rotT = self.joystick.rotB/2;
                end;
            end;
            
            
            if self.joystick.rotC < self.joystick.rotT then
                self.joystick.rotC = self.joystick.rotC + dt/1000;
                if self.joystick.rotC > self.joystick.rotT then
                    self.joystick.rotC = self.joystick.rotT;
                end;
            elseif self.joystick.rotC > self.joystick.rotT then
                self.joystick.rotC = self.joystick.rotC - dt/1000;
                if self.joystick.rotC < self.joystick.rotT then
                    self.joystick.rotC = self.joystick.rotT;
                end;
            end;
            
            setRotation( self.joystick.node, self.joystick.rotC, 0, 0 );
            
        end;
    end;
    
    if self.motor.speedLevel ~= 0 then
    end;
    
end;

function Joystick:updateTick(dt)

end;

function Joystick:onLeave()
end;

function Joystick:draw()
end;


function Joystick:realSetSpeedLimiterValue(increase)
    if increase then
        self.forceJoystick = true;
    else
        self.forceJoystick = false;
    end;    
    self.forceJoystick_time = self.time + 100;
end;