-- @author  FIAT80-90DT 
-- @date  	12.07.2013
-- @version initail version (1.0)
-- (C) MODCorp.de - Free for non commercial usage -

MaschioBisonte280 = {};

function MaschioBisonte280.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(MultipleAttacherJoints, specializations);
end;

function MaschioBisonte280:load(xmlFile)

	self.tubesCount = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.tubes#count"), 0);
	self.tube = {};
	self.tube.main = Utils.indexToObject(self.components, getXMLString(xmlFile,"vehicle.tubes#detached"));
	for i=1, self.tubesCount do
		local str = string.format("vehicle.tubes.tube%d", i)
		self.tube[i] = {};
		self.tube[i].index = Utils.indexToObject(self.components, getXMLString(xmlFile, str.."#index"));
	end;
	self.curTube = self.tube[self.currentAttacher];
end;

function MaschioBisonte280:delete()
end;

function MaschioBisonte280:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MaschioBisonte280:keyEvent(unicode, sym, modifier, isDown)
end;

function MaschioBisonte280:update(dt)
end;

function MaschioBisonte280:updateTick(dt)
	if self.isTurnedOn and self.movingDirection ~= 0 then
		if (self.lastSpeed*3600)> 1 then
			if self:getRealAnimationTime("chain") == 0 then
				self:playAnimation("chain", 1, nil);
			elseif self:getRealAnimationTime("chain") == self:getAnimationDuration("chain") then
				self:playAnimation("chain", -1, nil);
			end;
		end;
	end;
end;
 
function MaschioBisonte280:draw()
end;

function MaschioBisonte280:onAttach(attacherVehicle)
	setVisibility(self.tube[self.currentAttacher].index, true)
	setVisibility(self.tube.main, false);
end;

function MaschioBisonte280:onDetach()
	for k,v in ipairs(self.tube) do
		setVisibility(v.index, false);	
	end;	
	setVisibility(self.tube.main, true);
end;