--
-- GreenStarCutter.lua
--
-- @author  Alex2009(www.Alex2009.de)
-- @date    15.06.2011
-- @version 2.1
-- @changelog:
-- Fehler(attempt to index field 'attacherVehicle' (a nil value)) wurde behoben.

GreenStarCutter = {};

function GreenStarCutter.prerequisitesPresent(specializations)
    return true;
end;

function GreenStarCutter:load(savegame)
    self.oldvehicle = nil;
    self.GreenStarLeft = {};
    self.GreenStarLeft.startOutside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.GreenStar.GreenStarLeft#OutStart"));
    self.GreenStarLeft.widthOutside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.GreenStar.GreenStarLeft#OutWidth"));
    self.GreenStarLeft.heightOutside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.GreenStar.GreenStarLeft#OutHeight"));
    self.GreenStarLeft.startInside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.GreenStar.GreenStarLeft#InsideStart"));
    self.GreenStarLeft.widthInside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.GreenStar.GreenStarLeft#InsideWidth"));
    self.GreenStarLeft.heightInside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.GreenStar.GreenStarLeft#InsideHeight"));

    self.GreenStarRight = {};
    self.GreenStarRight.startOutside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.GreenStar.GreenStarRight#OutStart"));
    self.GreenStarRight.widthOutside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.GreenStar.GreenStarRight#OutWidth"));
    self.GreenStarRight.heightOutside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.GreenStar.GreenStarRight#OutHeight"));
    self.GreenStarRight.startInside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.GreenStar.GreenStarRight#InsideStart"));
    self.GreenStarRight.widthInside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.GreenStar.GreenStarRight#InsideWidth"));
    self.GreenStarRight.heightInside = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.GreenStar.GreenStarRight#InsideHeight"));    
end;

function GreenStarCutter:delete()
end;

function GreenStarCutter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function GreenStarCutter:keyEvent(unicode, sym, modifier, isDown)
end;

function GreenStarCutter:update(dt)
end;

function GreenStarCutter:updateTick(dt)
    if self.currentInputFruitType ~= nil and self.currentInputFruitType ~= FruitUtil.FRUITTYPE_UNKNOWN and self.attacherVehicle ~= nil then
        if self.attacherVehicle.autoPilotEnabled ~= nil then
            if self.attacherVehicle.autoPilotEnabled then
                self.oldvehicle.GSRlights = 0;
                self.oldvehicle.GSLlights = 0;
                self.oldvehicle.GSRlights = nil;
                self.oldvehicle.GSLlights = nil;
                return;                
            end;
        end;
        if self.attacherVehicle.isAIThreshing ~= nil then
            if self.attacherVehicle.isAIThreshing then
                self.oldvehicle.GSRlights = 0;
                self.oldvehicle.GSLlights = 0;
                self.oldvehicle.GSRlights = nil;
                self.oldvehicle.GSLlights = nil;
                return;                
            end;
        end;
        local x,y,z = getWorldTranslation(self.GreenStarRight.startOutside);--Rechts Start
        local x1,y1,z1 = getWorldTranslation(self.GreenStarRight.widthOutside);
        local x2,y2,z2 = getWorldTranslation(self.GreenStarRight.heightOutside);
        if x ~= nil and z ~= nil and x1 ~= nil and z1 ~= nil and x2 ~= nil and x2 ~= nil then
            self.GSRechtsOut = Utils.getFruitArea(self.currentInputFruitType, x, z, x1, z1, x2, z2);
        end;
        local x,y,z = getWorldTranslation(self.GreenStarRight.startInside);
        local x1,y1,z1 = getWorldTranslation(self.GreenStarRight.widthInside);
        local x2,y2,z2 = getWorldTranslation(self.GreenStarRight.heightInside);
        if x ~= nil and z ~= nil and x1 ~= nil and z1 ~= nil and x2 ~= nil and x2 ~= nil then
            self.GSRechtsIn = Utils.getFruitArea(self.currentInputFruitType, x, z, x1, z1, x2, z2);--Rechts Ende!
        end;
        local x,y,z = getWorldTranslation(self.GreenStarLeft.startOutside);--Links Start
        local x1,y1,z1 = getWorldTranslation(self.GreenStarLeft.widthOutside);
        local x2,y2,z2 = getWorldTranslation(self.GreenStarLeft.heightOutside);
        if x ~= nil and z ~= nil and x1 ~= nil and z1 ~= nil and x2 ~= nil and x2 ~= nil then
            self.GSLinksOut = Utils.getFruitArea(self.currentInputFruitType, x, z, x1, z1, x2, z2);
        end;
        local x,y,z = getWorldTranslation(self.GreenStarLeft.startInside);
        local x1,y1,z1 = getWorldTranslation(self.GreenStarLeft.widthInside);
        local x2,y2,z2 = getWorldTranslation(self.GreenStarLeft.heightInside);
        if x ~= nil and z ~= nil and x1 ~= nil and z1 ~= nil and x2 ~= nil and x2 ~= nil then
            self.GSLinksIn = Utils.getFruitArea(self.currentInputFruitType, x, z, x1, z1, x2, z2);--Links Ende
        end;
        if self.GSRechtsOut ~= nil and self.GSLinksOut ~= nil then 
            if self.GSRechtsOut < self.GSLinksOut then
                self.KornStandLinks = true;
            else
                self.KornStandLinks = false;
            end;
        end;
        if self.attacherVehicle ~= nil then
            self.attacherVehicle.GSLlights = 0;
            self.attacherVehicle.GSRlights = 0;
        end;    
        if self.GSLinksOut ~= nil and self.GSRechtsIn ~= nil then--Rechts
            if self.GSLinksOut >= self.GSRechtsIn and (self.KornStandLinks and self.GSRechtsOut <= 10) or (not self.KornStandLinks and self.GSRechtsOut >= 10) then
                local verhaeltnis = self.GSRechtsIn / self.GSLinksOut; 
                local lichter = 11 - math.ceil(11 * verhaeltnis);    
                if self.attacherVehicle ~= nil then
                    self.attacherVehicle.GSLlights = lichter;
                end;
            elseif (self.KornStandLinks and self.GSRechtsOut >= 5) or (not self.KornStandLinks and self.GSRechtsOut <= 10) then
                local verhaeltnis = self.GSRechtsOut / self.GSLinksOut; 
                local lichter = math.ceil(11 * verhaeltnis);    
                if self.attacherVehicle ~= nil then
                    self.attacherVehicle.GSRlights = lichter;
                end;                
            end;
        end;
        if self.GSRechtsOut ~= nil and self.GSLinksIn ~= nil then--Links
            if self.GSRechtsOut >= self.GSLinksIn and (self.KornStandLinks and self.GSLinksOut >= 10) or (not self.KornStandLinks and self.GSLinksOut <= 10) then
                local verhaeltnis = self.GSLinksIn / self.GSRechtsOut; 
                local lichter = 11 - math.ceil(11 * verhaeltnis);    
                if self.attacherVehicle ~= nil then
                    self.attacherVehicle.GSRlights = lichter;
                end;
            elseif (self.KornStandLinks and self.GSLinksOut <= 5) or (not self.KornStandLinks and self.GSLinksOut >= 10) then
                local verhaeltnis = self.GSLinksOut / self.GSRechtsOut; 
                local lichter = math.ceil(11 * verhaeltnis);    
                if self.attacherVehicle ~= nil then
                    self.attacherVehicle.GSLlights = lichter;
                end;                
            end;
        end;
    else
        if self.attacherVehicle ~= nil then
            self.attacherVehicle.GSRlights = 0;
            self.attacherVehicle.GSLlights = 0;
            self.attacherVehicle.GSRlights = nil;
            self.attacherVehicle.GSLlights = nil;
        end;
    end;
end;

function GreenStarCutter:draw()
end;


function GreenStarCutter:onAttach(attacherVehicle)
    attacherVehicle.GSRlights = 0;
    attacherVehicle.GSLlights = 0;
    self.oldvehicle = attacherVehicle;
end;

function GreenStarCutter:onDetach()
    if self.oldvehicle ~= nil then
        self.oldvehicle.GSRlights = 0;
        self.oldvehicle.GSLlights = 0;
        self.oldvehicle.GSRlights = nil;
        self.oldvehicle.GSLlights = nil;
    end;
end;




