--
-- Author: Martin Fabik (aka LoogleCZ)
--
-- version ID   - 1.1
-- version date - 21.2.2016 (21:11)
-- 
--    v. 1.1 - added support for cutters
--
-- Free for non-comerecial usage
--
--[[
    Example XML node:
    
    <threshingAnimation animName="threshing" animSpeed="5"/>
    
]]--

threshingAnimation = {};

function threshingAnimation.prerequisitesPresent(specializations)
    return true;
end;

function threshingAnimation:load(savegame)
    self.LTA = {};
    self.LTA.animation = getXMLString(xmlFile, "vehicle.threshingAnimation#animName");
    self.LTA.speed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingAnimation#animSpeed"), 1);
end;

function threshingAnimation:delete()
end;

function threshingAnimation:writeStream(streamId, connection)
end;

function threshingAnimation:readStream(streamId, connection)
end;

function threshingAnimation:mouseEvent(posX, posY, isDown, isUp, button)
end;

function threshingAnimation:keyEvent(unicode, sym, modifier, isDown)
end;

function threshingAnimation:update(dt)
end;

function threshingAnimation:onStartReel()
    if self.LTA.animation ~= nil then
        self:playAnimation(self.LTA.animation, self.LTA.speed, Utils.clamp(self:getAnimationTime(self.LTA.animation), 0, 1), true);
    end;
end;

function threshingAnimation:onStopReel()
    if self.LTA.animation ~= nil then
        self:stopAnimation(self.LTA.animation, true);
    end;
end;

function threshingAnimation:onTurnedOn()
    if self.LTA.animation ~= nil then
        self:playAnimation(self.LTA.animation, self.LTA.speed, Utils.clamp(self:getAnimationTime(self.LTA.animation), 0, 1), true);
    end;
end;

function threshingAnimation:onTurnedOff()
    if self.LTA.animation ~= nil then
        self:stopAnimation(self.LTA.animation, true);
    end;
end;

function threshingAnimation:updateTick(dt)
end;

function threshingAnimation:draw()
end;