-- EngineShaft = Motorwelle
-- Specialization for EngineShaft/Motorwelle
-- Motor shaft begins in response to the engine speed
-- to rotate when the motor starts

EngineShaft = {};

function EngineShaft.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function EngineShaft:load(savegame)
    self.shaftIndex = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.EngineShaft.shaft#componentIndex"));
    self.shaftRpmMultiplicator = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.EngineShaft.shaft#RpmMultiplicator"),10);
end;
function EngineShaft:delete()
end;
function EngineShaft:mouseEvent(posX, posY, isDown, isUp, button)
end;
function EngineShaft:keyEvent(unicode, sym, modifier, isDown)
end;

function EngineShaft:updateTick(dt)
end;
function EngineShaft:update(dt)
    if self:getIsActive() then
        if self.isMotorStarted then
            rotate(self.shaftIndex, self.motor.lastMotorRpm/10000*self.shaftRpmMultiplicator*dt,0,0);
        end;
    end;
end;
function EngineShaft:draw()
end;

function EngineShaft:onEnter()
end;
function EngineShaft:onLeave()
end;