﻿-- T174AnimationsV3
-- @Date: 05-12-2014    V2
--
-- animierte Gangschaltung
--
-- @Author  ieg53i and ( Bayrisch-Michl V1 )


T174AnimationsV3 = {};

function T174AnimationsV3.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;
function T174AnimationsV3:load(savegame)
    
    -- Gangschaltung / Gearlever
    self.Ganghebel = {};
    self.Ganghebel = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.T174AnimationsV3.Ganghebel#index"));
    if self.Ganghebel ~= nil then
        self.ForwRot =  math.rad(Utils.getNoNil(getXMLFloat(self.xmlFile,  "vehicle.T174AnimationsV3.Ganghebel#ForwRot")));
        self.BackwRot = math.rad(Utils.getNoNil(getXMLFloat(self.xmlFile,  "vehicle.T174AnimationsV3.Ganghebel#BackwRot")));
        self.RightRot = math.rad(Utils.getNoNil(getXMLFloat(self.xmlFile,  "vehicle.T174AnimationsV3.Ganghebel#RightRot")));
        self.LeftRot =  math.rad(Utils.getNoNil(getXMLFloat(self.xmlFile,  "vehicle.T174AnimationsV3.Ganghebel#LeftRot")));
        self.GangMoveSpeed =      Utils.getNoNil(getXMLFloat(self.xmlFile,  "vehicle.T174AnimationsV3.Ganghebel#moveSpeed"))/10000;
        self.NEUTRALSTELLUNG = false; self.Forwards = false; self.Gang1 = false; self.Gang2 = false; self.Gang3 = false; self.Gang4 = false; self.Gang3Mitte = false; self.Gang3RMitte = false; self.Gang3Rechts = false; self.GangLinks = false; self.GangRechts = false; self.Gang3RLinks = false; self.Backwards = false;    self.LEVEL1 = false; self.LEVEL2 = false; self.LEVEL3 = false; self.LEVEL4 = false; self.LEVEL1R = false; self.LEVEL2R = false;    self.LEVEL3R = false;
    end;
end;

function T174AnimationsV3:delete()
end;
function T174AnimationsV3:readStream(streamId, connection)
end;
function T174AnimationsV3:writeStream(streamId, connection)
end;
function T174AnimationsV3:mouseEvent(posX, posY, isDown, isUp, button)
end;
function T174AnimationsV3:keyEvent(unicode, sym, modifier, isDown)
end;

function T174AnimationsV3:update(dt)

     if self:getIsActive() then
     
-- GANGSCHALTUNG ---------------------------------------------------------------
     local Gx, Gy, Gz = getRotation(self.Ganghebel);
    
    ---------- HOCHSCHALTEN -------------------------------------------
            if self.lastRoundPerMinute /155 > 1 and self.movingDirection > 0 then
            self.Forwards = true;
            local inputW = self.lastRoundPerMinute /155 > 0 ;
            local kmh = self.lastSpeed*self.speedDisplayScale*3600;
            
                -- GANG 1 --------------------
                if kmh > 1 and inputW and self.Gang1 == false then
                    self.LEVEL1 = true;
                    Gx = Gx + (dt * self.GangMoveSpeed);     -- Gang nach vorne
                        if Gx >= self.ForwRot then
                            Gx = self.ForwRot;
                            self.Gang1 = true;
                            self.LEVEL1 = false;
                            
                        end;        
                -- GANG 2 --------------------
                elseif kmh > 10 and  inputW and self.Gang1 == true and self.Gang2 == false then
                    self.LEVEL2 = true;
                    Gx = Gx - (dt * self.GangMoveSpeed);    -- Gang nach hinten
                        if Gx <= self.BackwRot then
                            Gx = self.BackwRot;
                            self.Gang2 = true;
                            self.LEVEL2 = false;

                        end;
                -- GANG 3 --------------------
                elseif kmh > 18 and  inputW and self.Gang2 == true and self.Gang4 == false then
                    self.LEVEL3 = true;
                    if self.Gang3Mitte == false and self.Gang3 == false then
                            Gx = Gx + (dt * self.GangMoveSpeed);    -- Gang in Neutralstellung
                                if Gx >= 0 then
                                    Gx = 0;
                                    self.Gang3Mitte = true;
                                end;
                    elseif  self.Gang3Mitte == true and self.Gang3Rechts == false then
                            Gz = Gz + (dt * self.GangMoveSpeed);    -- Gang nach rechts
                                if Gz >= self.RightRot then
                                    Gz = self.RightRot;
                                    self.Gang3Rechts = true;
                                    self.Gang3Mitte = false;
                                end;
                    elseif  self.Gang3Rechts == true and self.Gang3 == false then    
                            Gx = Gx + (dt * self.GangMoveSpeed);    -- Gang nach vorne
                                if Gx >= self.ForwRot then
                                    Gx = self.ForwRot;
                                    self.Gang3Mitte = false;
                                    self.Gang3Rechts = false;                                    
                                    self.Gang3 = true;            
                                end;
                -- GANG 4 --------------------
                    elseif kmh > 24 and self.Gang3 == true and self.Gang4 == false then
                            Gx = Gx - (dt * self.GangMoveSpeed);    -- Gang nach hinten
                                if Gx <= self.BackwRot then
                                    Gx = self.BackwRot;
                                    self.Gang4 = true;
                                    self.Gang3 = false;
                                    self.Gang3Mitte = false;
                                    self.Gang3Rechts = false;
                                    self.LEVEL3 = false;
                                end;
                end;
    ---------- RUNTERSCHALTEN -------------------------------------------
                -- GANG 3 --------------------    
                elseif kmh < 24 and self.Gang4 == true and self.Gang3 == false then
                        Gx = Gx + (dt * self.GangMoveSpeed);    -- Gang nach vorne
                            if Gx >= self.ForwRot then
                                Gx = self.ForwRot;                        
                                self.Gang4 = false;
                                self.Gang3 = true;
                                self.Gang3RMitte = false;
                                self.Gang3RLinks = false;
                                end;
                -- GANG 2 --------------------
                elseif (self.LEVEL2R or kmh < 18) and self.Gang3 == true then
                self.LEVEL2R = true;
                    if self.Gang3RMitte == false then
                        Gx = Gx - (dt * self.GangMoveSpeed);    -- Gang nach hinten
                            if Gx <= 0 then
                                Gx = 0;
                                self.Gang3RMitte = true;
                                self.Gang3RLinks = false;
                            end;
                    elseif self.Gang3RMitte == true and self.Gang3RLinks == false then
                        Gz = Gz - (dt * self.GangMoveSpeed);    -- Gang nach links
                            if Gz <= 0 then
                                Gz = 0;
                                self.Gang3RLinks = true;
                                self.Gang3RMitte = false;                                
                                self.Gang2 = false;
                                self.Gang3 = false;
                                self.Gang4 = false;                                
                            end;
                    elseif self.Gang3RLinks == true and self.Gang2 == false then
                        Gx = Gx - (dt * self.GangMoveSpeed);    -- Gang nach hinten
                            if Gx <= self.BackwRot then
                                Gx = self.BackwRot;
                                self.Gang3RMitte = false;
                                self.Gang3RLinks = false;
                                self.Gang2 = true;
                                self.Gang3 = false;
                                if kmh < 10 then self.LEVEL1R = true;
                                end;
                            end;
                    end;
                -- GANG 1 --------------------
                elseif (self.LEVEL1R or kmh < 10)  and self.Gang2 == true then
                    self.LEVEL1R = true;
                    Gx = Gx + (dt * self.GangMoveSpeed);    -- Gang nach vorne
                        if Gx >= self.ForwRot then
                            Gx = self.ForwRot;
                            self.Gang2 = false;
                            self.LEVEL1R = false;
                        end;
                end;
            
    ---------- RÜCKWÄRTSGANG -------------------------------------------    
            elseif self.lastRoundPerMinute /155 > 1  and self.movingDirection < 0 then
                self.Backwards = true;
                if self.NEUTRALSTELLUNG == true then
                        if self.GangLinks == false then
                            Gz = Gz - (dt * self.GangMoveSpeed);    -- Gang nach links
                                if Gz <= self.LeftRot then
                                    Gz = self.LeftRot;
                                    self.GangLinks = true;
                                end;
                        elseif self.GangLinks == true then
                            Gx = Gx + (dt * self.GangMoveSpeed);    -- Gang nach vorne
                                if Gx >= self.ForwRot then
                                    Gx = self.ForwRot;
                                end;
                        end;
                else self.NEUTRALSTELLUNG = false;
                end;
                    
    ---------- NEUTRALSTELLUNG -------------------------------------------
            else
                    if Gx > 0 then
                        Gx = Gx - (dt * self.GangMoveSpeed);    -- Gang nach hinten
                                if Gx <= 0 then
                                    Gx = 0;
                                end;
                    elseif Gx < 0 then
                        Gx = Gx + (dt * self.GangMoveSpeed);    -- Gang nach hinten
                                if Gx >= 0 then
                                    Gx = 0;
                                end;
                    elseif Gx == 0 and Gz > 0 then
                        Gz = Gz - (dt * self.GangMoveSpeed);    -- Gang nach links
                                if Gz <= 0 then
                                    Gz = 0;
                                end;
                    elseif Gx == 0 and Gz < 0 then
                        Gz = Gz + (dt * self.GangMoveSpeed);    -- Gang nach rechts
                                if Gz >= 0 then
                                    Gz = 0;
                                end;
                    elseif Gx == 0 and Gz == 0 then
                        self.NEUTRALSTELLUNG = true; self.Forwards = false; self.Gang1 = false; self.Gang2 = false; self.Gang3 = false; self.Gang4 = false; self.Gang3Mitte = false; self.Gang3RMitte = false; self.Gang3Rechts = false; self.GangLinks = false; self.GangRechts = false; self.Gang3RLinks = false; self.Backwards = false; self.LEVEL1 = false; self.LEVEL2 = false; self.LEVEL3 = false; self.LEVEL4 = false; self.LEVEL1R = false; self.LEVEL2R = false; self.LEVEL3R = false;
                    end;
            end;

        setRotation(self.Ganghebel, Gx, Gy, Gz);
     
    end;
    
end;

function T174AnimationsV3:updateTick(dt)
end;
function T174AnimationsV3:draw()
end;
function T174AnimationsV3:onEnter()
end;
function T174AnimationsV3:onLeave()
end;