-- T174AnimationsV2 - Script by ===ieg53i===
-- date: 05.12.2014
-- Script zur Steuerung der Hebel und Pedale
T174AnimationsV2 = {};

function T174AnimationsV2.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function T174AnimationsV2:load(savegame)
    self.clutchPedal = {};
    self.clutchPedal.index = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.T174AnimationsV2.clutchPedal#index"));
    self.clutchPedal.maxTrans = math.rad(Utils.getNoNil(getXMLFloat(self.xmlFile,  "vehicle.T174AnimationsV2.clutchPedal#maxTrans"), 0));
    self.clutchPedal.minTrans = math.rad(Utils.getNoNil(getXMLFloat(self.xmlFile,  "vehicle.T174AnimationsV2.clutchPedal#minTrans"), 0));
    self.clutchPedal.movementSpeed = Utils.getNoNil(getXMLFloat(self.xmlFile,  "vehicle.T174AnimationsV2.clutchPedal#movementSpeed"), 0)/1000;
    
    self.brakePedal = {};
    self.brakePedal.index = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.T174AnimationsV2.brakePedal#index"));
    self.brakePedal.maxTrans = math.rad(Utils.getNoNil(getXMLFloat(self.xmlFile,  "vehicle.T174AnimationsV2.brakePedal#maxTrans"), 0));
    self.brakePedal.minTrans = math.rad(Utils.getNoNil(getXMLFloat(self.xmlFile,  "vehicle.T174AnimationsV2.brakePedal#minTrans"), 0));
    self.brakePedal.movementSpeed = Utils.getNoNil(getXMLFloat(self.xmlFile,  "vehicle.T174AnimationsV2.brakePedal#movementSpeed"), 0)/1000;
        
    self.Throttle = {};
    self.Throttle.index = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.T174AnimationsV2.Throttle#index"));
    self.Throttle.movementSpeed = Utils.getNoNil(getXMLFloat(self.xmlFile,  "vehicle.T174AnimationsV2.Throttle#movementSpeed"), 0)/10;

    self.workGear = {};
    self.workGear.index = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.T174AnimationsV2.workGear#index"));
    if self.workGear.index ~= nil then
        self.workGear.origRot = {getRotation(self.workGear.index)};
        self.workGear.speed1Rot = Utils.getRadiansFromString(getXMLString(self.xmlFile,  "vehicle.T174AnimationsV2.workGear#speed1Rot"), 3);
    end;

    self.mainArmLever = {};
    self.mainArmLever.index = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.T174AnimationsV2.mainArmLever#index"));
    if self.mainArmLever.index ~= nil then
        self.mainArmLever.origRot = Utils.getRadiansFromString(getXMLString(self.xmlFile,  "vehicle.T174AnimationsV2.mainArmLever#origRot"), 3);
    end;

    self.frontArmLever = {};
    self.frontArmLever.index = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.T174AnimationsV2.frontArmLever#index"));
    if self.frontArmLever.index ~= nil then
        self.frontArmLever.origRot = Utils.getRadiansFromString(getXMLString(self.xmlFile,  "vehicle.T174AnimationsV2.frontArmLever#origRot"), 3);
    end;

    self.turnerLever = {};
    self.turnerLever.index = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.T174AnimationsV2.turnerLever#index"));
    if self.turnerLever.index ~= nil then
        self.turnerLever.origRot = Utils.getRadiansFromString(getXMLString(self.xmlFile,  "vehicle.T174AnimationsV2.turnerLever#origRot"), 3);
    end;

    self.shovelLever = {};
    self.shovelLever.index = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.T174AnimationsV2.shovelLever#index"));
    if self.shovelLever.index ~= nil then
        self.shovelLever.origRot = Utils.getRadiansFromString(getXMLString(self.xmlFile,  "vehicle.T174AnimationsV2.shovelLever#origRot"), 3);
    end;

    self.turnLeftCartPedal = {};
    self.turnLeftCartPedal.index = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.T174AnimationsV2.turnLeftCartPedal#index"));
    if self.turnLeftCartPedal.index ~= nil then
        self.turnLeftCartPedal.origTrans = Utils.getRadiansFromString(getXMLString(self.xmlFile,  "vehicle.T174AnimationsV2.turnLeftCartPedal#origTrans"), 3);
    end;

    self.turnRightCartPedal = {};
    self.turnRightCartPedal.index = Utils.indexToObject(self.components, getXMLString(self.xmlFile, "vehicle.T174AnimationsV2.turnRightCartPedal#index"));
    if self.turnRightCartPedal.index ~= nil then
        self.turnRightCartPedal.origTrans = Utils.getRadiansFromString(getXMLString(self.xmlFile,  "vehicle.T174AnimationsV2.turnRightCartPedal#origTrans"), 3);
    end;

end;

function T174AnimationsV2:delete()

end;

function T174AnimationsV2:readStream(streamId, connection)
end;

function T174AnimationsV2:writeStream(streamId, connection)
end;

function T174AnimationsV2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function T174AnimationsV2:keyEvent(unicode, sym, modifier, isDown)
end;

function T174AnimationsV2:update(dt)
    if self:getIsActive() then
        if self.lastRoundPerMinute ~= 0 then
            if self.Throttle.index ~= nil then
                local ThrottleMovement = self.lastRoundPerMinute /1000 ;
                if ThrottleMovement < 0 then
                    ThrottleMovement = -ThrottleMovement;
                end;
                setRotation(self.Throttle.index, ThrottleMovement*6.5*self.Throttle.movementSpeed, 0, 0);
            end;
        end;

        -- workGear lever / Hebel Arbeitsgetriebe
        if self.isMotorStarted then
            setRotation(self.workGear.index,  unpack(self.workGear.speed1Rot));
        else
            setRotation(self.workGear.index,  unpack(self.workGear.origRot));
        end;

        -- mainArm lever / Hebel Hauptarm
        local inputXO = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FRONTLOADER_ARM);
        if InputBinding.isAxisZero(inputXO) then
                inputXO = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FRONTLOADER_ARM)/4;
        end;
        local x,y,z = unpack(self.mainArmLever.origRot);
        setRotation(self.mainArmLever.index, x*inputXO, y*inputXO, z*inputXO);

        -- frontArm lever / Hebel Frontarm
        local inputXO = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FRONTLOADER_ARM2);
        if InputBinding.isAxisZero(inputXO) then
                inputXO =InputBinding.getAnalogInputAxis(InputBinding.AXIS_FRONTLOADER_ARM2)/4 ;
        end;
        local x,y,z = unpack(self.frontArmLever.origRot);
        setRotation(self.frontArmLever.index, x*inputXO, y*inputXO, z*inputXO);

        -- turner lever / Hebel Dreher
        local inputXO = InputBinding.getDigitalInputAxis(InputBinding.DREHER);
        if InputBinding.isAxisZero(inputXO) then
                inputXO = InputBinding.getAnalogInputAxis(InputBinding.DREHER)/4;
        end;    
        local x,y,z = unpack(self.turnerLever.origRot);
        setRotation(self.turnerLever.index, x*inputXO, y*inputXO, z*inputXO);

        -- shovel and supportpart lever / Hebel Greifer/Schaufel und Gestelldrehteil
        local inputXO = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FRONTLOADER_TOOL2 or InputBinding.ZANGENDREHER);
        if InputBinding.isAxisZero(inputXO) then
                inputXO = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FRONTLOADER_TOOL2 or InputBinding.ZANGENDREHER)/4;
        end;
        local x,y,z = unpack(self.shovelLever.origRot);
        setRotation(self.shovelLever.index, x*inputXO, y*inputXO, z*inputXO);

        -- turnLeftCartPedal
        local inputXO = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FRONTLOADER_TOOL);
        if InputBinding.isAxisZero(inputXO) then
                inputXO = InputBinding.getAnalogInputAxis(InputBinding.AXIS_FRONTLOADER_TOOL)/4;
        end;
        local x,y,z = unpack(self.turnLeftCartPedal.origTrans);
        setTranslation(self.turnLeftCartPedal.index, -x*inputXO, -y*inputXO, -z*inputXO);

        -- turnRightCartPedal
        local inputXO = InputBinding.getDigitalInputAxis(InputBinding.AXIS_FRONTLOADER_TOOL);
        if InputBinding.isAxisZero(inputXO) then
                inputXO =InputBinding.getAnalogInputAxis(InputBinding.AXIS_FRONTLOADER_TOOL)/4 ;
        end;
        local x,y,z = unpack(self.turnRightCartPedal.origTrans);
        setTranslation(self.turnRightCartPedal.index, x*inputXO, y*inputXO, z*inputXO);

        -- Pedale
        if self.ignitionMode == nil or self.ignitionMode >= 1 then
        --                    Kupplung auslösen bei kmh > 0 und < 1         |                Kupplung auslösen bei kmh > 8 und < 11      |                Kupplung auslösen bei kmh > 16 und < 19     |                Kupplung auslösen bei kmh > 22 und < 26
            if self.lastSpeed*100 >= 0.0005 and self.lastSpeed*100 <= 0.08 or self.lastSpeed*100 >= 0.27 and self.lastSpeed*100 <= 0.34 or self.lastSpeed*100 >= 0.47 and self.lastSpeed*100 <= 0.55 or self.lastSpeed*100 >= 0.66 and self.lastSpeed*100 <= 0.72 then
                if self.clutchPedal.index ~= nil then
                    local transX, transY, transZ = getTranslation(self.clutchPedal.index);
                    if transY > self.clutchPedal.maxTrans then
                        setTranslation(self.clutchPedal.index, transX, transY - dt * self.clutchPedal.movementSpeed, transZ);
                    end;
                end;
            else
                if self.clutchPedal.index ~= nil then
                    local transX, transY, transZ = getTranslation(self.clutchPedal.index);
                    if transY < self.clutchPedal.minTrans then
                        setTranslation(self.clutchPedal.index, transX, transY + dt * self.clutchPedal.movementSpeed, transZ);
                    end;
                end;
            end;

            if (self.lastRoundPerMinute/1850)*self.movingDirection <= -0.005 or (self.lastRoundPerMinute/1850)*self.movingDirection >= 0.005 then
                if self.brakePedal.index ~= nil then
                    local transX1, transY1, transZ1 = getTranslation(self.brakePedal.index);
                    if transY1 < self.brakePedal.maxTrans then
                        setTranslation(self.brakePedal.index, transX1, transY1 + dt * self.brakePedal.movementSpeed, transZ1);
                    end;
                end;
            else
                if self.brakePedal.index ~= nil then
                    local transX1, transY1, transZ1 = getTranslation(self.brakePedal.index);
                    if transY1 > self.brakePedal.minTrans then
                        setTranslation(self.brakePedal.index, transX1, transY1 - dt * self.brakePedal.movementSpeed, transZ1);
                    end;
                end;
            end;
        end;

    end;
end;

function T174AnimationsV2:updateTick(dt)
end;

function T174AnimationsV2:draw()
end;