-- Origin by modelleicher, rewritten and adapted by ieg53i
-- Script zur Steuerung der Anzeigen
-- Date 24.12.2014

T174Animations = {};

function T174Animations.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function T174Animations:load(xmlFile)

	-- Tachozeiger / Speedometer animation
	self.tachoZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.T174Animations.TachoZeiger#zeigerIndex"));
	self.tachoZeigerMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.T174Animations.TachoZeiger#ScaleEnd"), 10);
	self.tachoZeigerMaxRotation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.T174Animations.TachoZeiger#maxRotation"), 245);

	-- Drehzahlzeiger / motorRpmMeter animation
	self.rpmZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.T174Animations.rpmMeterZeiger#zeigerIndex"));
	self.rpmZeigerMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.T174Animations.rpmMeterZeiger#ScaleEnd"), 10);
	self.rpmZeigerMaxRotation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.T174Animations.rpmMeterZeiger#maxRotation"), 245);
	
	-- Tankanzeige / Fuellevelmeter animation
	self.fuelZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.T174Animations.fuelZeiger#zeigerIndex"));
	self.fuelZeigerMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.T174Animations.fuelZeiger#ScaleEnd"), 10);
	self.fuelZeigerMaxRotation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.T174Animations.fuelZeiger#maxRotation"), 245);	

	-- Temperaturzeiger / Temperature Display animation
	self.temperaturZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.T174Animations.TemperaturZeiger#zeigerIndex"));
	self.temperaturZeigerMaxRot = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.T174Animations.TemperaturZeiger#maxRotation"));
	self.tempCnt = 0;

	-- Temperaturzeiger2 / Temperature Display animation
	self.temperaturZeiger2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.T174Animations.TemperaturZeiger2#zeigerIndex"));
	self.temperaturZeigerMaxRot2 = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.T174Animations.TemperaturZeiger2#maxRotation"));
	self.tempCnt2 = 0;
	
	-- Ladekontrollleuchte / Batterie load light
	self.ladeLeuchte = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.T174Animations.LadeKontrollLeuchte#index"));
	setVisibility(self.ladeLeuchte, false);
	self.ladeLeuchteOn = 0;
	self.ladeTimer = 20;
	
end;
function T174Animations:delete()
end;
function T174Animations:mouseEvent(posX, posY, isDown, isUp, button)
end;
function T174Animations:keyEvent(unicode, sym, modifier, isDown)
end;

function T174Animations:updateTick(dt)
end;

function T174Animations:update(dt)
	if self:getIsActive() then
		if self.isMotorStarted then
			-- Ladekontrollleuchte / Batterie load light
			if self.ladeLeuchteOn == 1 then
				setVisibility(self.ladeLeuchte, true);
				if self.movingDirection ~= 0 then
					self.timerTrue = true;
				end;
				if self.timerTrue then
					self.ladeTimer = math.max(self.ladeTimer - 0.1, 0);
				end;
				if self.ladeTimer == 0 then
					setVisibility(self.ladeLeuchte, false);
					self.timerTrue = nil;
					self.ladeLeuchteOn = 0;
					self.ladeTimer = 20;
				end;
			end;
			
			-- Tachozeiger / speedometer animation
			self.kmhMath = math.min(100, math.max(0, self.lastSpeed*self.speedDisplayScale*3600));
			local zeigerRotation = self.kmhMath * self.tachoZeigerMultiplicator;
			if zeigerRotation <= self.tachoZeigerMaxRotation then
				setRotation(self.tachoZeiger, 0, -Utils.degToRad(zeigerRotation), 0);
			else
				setRotation(self.tachoZeiger, 0, -Utils.degToRad(self.tachoZeigerMaxRotation), 0);	
			end;			

	        -- Drehzahlzeiger / motorRpmMeter animation
			self.rpmMath = ((self.lastRoundPerMinute*3.5)+(self.motor.minRpm*3.5)*self.speedDisplayScale);
			local zeigerRotation = self.rpmMath * self.rpmZeigerMultiplicator;
			if zeigerRotation <= self.rpmZeigerMaxRotation then
				setRotation(self.rpmZeiger, 0, -Utils.degToRad(zeigerRotation), 0);
			else
				setRotation(self.rpmZeiger, 0, -Utils.degToRad(self.rpmZeigerMaxRotation), 0);	
			end;

	        -- Tankanzeige / Fuellevelmeter animation
			self.fuelMath =  (self.fuelFillLevel*self.speedDisplayScale);
			local zeigerRotation = self.fuelMath * self.fuelZeigerMultiplicator;
			if zeigerRotation <= self.fuelZeigerMaxRotation then
				setRotation(self.fuelZeiger, 0, -Utils.degToRad(zeigerRotation), 0);
			else
				setRotation(self.fuelZeiger, 0, -Utils.degToRad(self.fuelZeigerMaxRotation), 0);	
			end;

			-- Temperaturanzeiger / temperature display animation und / and berechnung / calculation
			if self.tempCnt < 3000 then
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = self.tempCnt + 0.5;
			elseif self.tempCnt > 3000 and self.tempCnt < 6000 then
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = math.min(self.tempCnt + 0.2, 10000);			
			else
				setRotation(self.temperaturZeiger, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot/10000)*self.tempCnt), 0);
				self.tempCnt = math.min(self.tempCnt + 0.05, 10000);
			end;
			if self.tempCnt2 < 3000 then
				setRotation(self.temperaturZeiger2, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2), 0);
				self.tempCnt2 = self.tempCnt2 + 0.8;
			elseif self.tempCnt2 > 3000 and self.tempCnt2 < 6000 then
				setRotation(self.temperaturZeiger2, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2), 0);
				self.tempCnt2 = math.min(self.tempCnt2 + 0.3, 10000);			
			else
				setRotation(self.temperaturZeiger2, 0, Utils.degToRad(-(self.temperaturZeigerMaxRot2/10000)*self.tempCnt2), 0);
				self.tempCnt2 = math.min(self.tempCnt2 + 0.04, 10000);
			end;			
		end;
	else
		self.tempCnt = math.max(self.tempCnt - 0.08, 0);
		self.tempCnt2 = math.max(self.tempCnt2 - 0.1, 0);
	end;
end;
function T174Animations:draw()
end;

function T174Animations:onEnter()
	self.ladeLeuchteOn = 1;
end;
function T174Animations:onLeave()
	self.ladeLeuchteOn = 0;
end;