-- by ieg53i
-- Date: 24.12.2014
-- Script für Lastanzeiger   /   script four load indicator

T174AnimationsV1 = {};

function T174AnimationsV1.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function T174AnimationsV1:load(xmlFile)
	self.fillZeiger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.T174AnimationsV1.fillZeiger#zeigerIndex"));
	self.fillZeigerMultiplicator = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.T174AnimationsV1.fillZeiger#ScaleEnd"), 10);
	self.fillZeigerMaxRotation = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.T174AnimationsV1.fillZeiger#maxRotation"), 245);
	end;
function T174AnimationsV1:delete()
end;
function T174AnimationsV1:mouseEvent(posX, posY, isDown, isUp, button)
end;
function T174AnimationsV1:keyEvent(unicode, sym, modifier, isDown)
end;
function T174AnimationsV1:updateTick(dt)
end;

	-- Lastanzeige / fill indicator animation
function T174AnimationsV1:update(dt)

	if self:getIsActive() then
		    if self.isMotorStarted then
            local f, c = self:getAttachedTrailersFillLevelAndCapacity();
            local fillLevel = 0 ;
            local capacity = 0 ;
                if f ~= nil and c ~= nil then         -- (fillLevel / 3.2) + (capacity / 15)
                    fillLevel = f;                    -- Diese Difidenten sind auf die Greifer eingestellt
                    capacity = c;                     -- fillLevel = 1800 (kg) , capacity = Greifergewicht 147kg
                end;		
			self.fillMath = (self.speedDisplayScale * (fillLevel / 3.2) + (capacity / 15));
			local zeigerRotation = self.fillMath * self.fillZeigerMultiplicator;
			if zeigerRotation  <= self.fillZeigerMaxRotation then
			    setRotation(self.fillZeiger, 0, -Utils.degToRad(zeigerRotation), 0);
			else
			    setRotation(self.fillZeiger, 0, -Utils.degToRad(self.fillZeigerMaxRotation), 0);	
			end;			
		end;
	end;
end;

function T174AnimationsV1:draw()
end;
function T174AnimationsV1:onEnter()
end;
function T174AnimationsV1:onLeave()
end;