local metadata = {
"## Interface: FS15 1.3.0.1 1.3RC1",
"## Title: WaterFillTrigger",
"## Notes: WaterFillTrigger fr FabrikScript",
"## Author: Marhu",
"## Version: 1.0.1-107",
"## Date: 09.08.2015",
"## Web: http://marhu.net"
}

local DebugEbene = 0;
local function getmdata(v) v="## "..v..": "; for i=1,table.getn(metadata) do local _,n=string.find(metadata[i],v);if n then return (string.sub (metadata[i], n+1)); end;end;end;
--print("Script "..(getmdata("Title")).." v"..(getmdata("Version")).." by "..(getmdata("Author")).." loaded! Support on "..(getmdata("Web")));
local function Debug(printDebug,...)
    if printDebug <= DebugEbene then
        local m,t,s,ts = "",type,select,tostring;
        for i = 1, s("#", ...) do if t(s(i, ...)) == "boolean" then m = m..(s(i, ...) and "true" or "false").." "; else m = m..ts(s(i, ...) or "nil").." "; end; end;
        print((getmdata("Title")).." v"..(getmdata("Version"))..": "..m);
end; end;

local ModDir = g_currentModDirectory;
WaterFillTrigger = {}
local WaterFillTrigger_mt = Class(WaterFillTrigger);
InitObjectClass(WaterFillTrigger, "WaterFillTrigger");

function WaterFillTrigger:new(isServer, isClient)
    local self = {};
    setmetatable(self, WaterFillTrigger_mt)
    self.waterTrailers = {}
    self.isWaterTankFilling = false;
    self.WaterTankActivatable = WaterTankActivatable:new(self)
    self.isClient = isClient
    self.isServer = isServer
    
    return self;
end;

function WaterFillTrigger:load(id,silo)
    
    self.triggerId = id
    self.Silo = silo;

    addTrigger(self.triggerId, "triggerCallback", self)
        
    local fillTypesStr = Utils.getNoNil(getUserAttribute(id, "fillType"),"water")
    local fillType = Fillable.fillTypeNameToInt[fillTypesStr]
    if fillType then
        self.fillType = fillType;
    else
        Debug(-1,string.format("ERROR: unknown fillType %s in %s",tostring(fillTypesStr),getName(id)));
    end
    self.priceScale = Utils.getNoNil(getUserAttribute(id, "priceScale"), 0)
    
    if self.isClient then
        local SoundFile  = Utils.getFilename("$data/maps/sounds/refuel.wav",  ModDir);    
        self.SourceRefuel = createAudioSource("RefuelSound", SoundFile, 30, 15, 0, 1);
        self.sampleRefuel = getAudioSourceSample(self.SourceRefuel);
        link(id, self.SourceRefuel);
    end
    
    local Name = Utils.getNoNil(getUserAttribute(id, "L_Name"), "WaterFillTriggerName")
    self.WaterTankActivatable.WaterFillTriggerName =  g_i18n:hasText(Name) and g_i18n:getText(Name) or Name;
    
    self.IsFilling = false
    self.isEnabled = true
    
    g_currentMission:addUpdateable(self);
    return true;
end;

function WaterFillTrigger:delete()
    
    removeTrigger(self.triggerId)

end;

function WaterFillTrigger:update(dt)
    
    if self.isWaterTankFilling then
        local disableFilling = true;
        if self.waterTankFillTrailer then
            if self.isClient and self.waterTankFillTrailer.setOverloadPipe ~= nil then
                self.waterTankFillTrailer:setOverloadPipe(self.triggerId);
            end
            if self.isServer then
                local waterFillLevel = self.waterTankFillTrailer:getFillLevel(self.fillType)
                local delta = self.waterTankFillTrailer.fillLitersPerSecond*dt*0.001
                delta = math.min(delta, waterFillLevel, self:waterTankCapacity()-self:waterTankFillLevel())
                
                if delta > 0 then
                    disableFilling = false
                    self.waterTankFillTrailer:setFillLevel(waterFillLevel - delta, self.fillType, true);
                    self:setWaterTankFillLevel(self:waterTankFillLevel() + delta)
                end;
            end;
        end
        if self.isServer and disableFilling then
            self:setIsWaterTankFilling(false)
        end;
    end
    
    self.elapsed = (self.elapsed or 0) + dt;
    if self.elapsed >= 300 then self:updateTick(self.elapsed); end    
end;

function WaterFillTrigger:updateTick(dt)
    self.elapsed = self.elapsed - dt
end;

function WaterFillTrigger:addWaterTrailer(trailer)
    if table.getn(self.waterTrailers) == 0 then
        g_currentMission:addActivatableObject(self.WaterTankActivatable)
    end

    table.insert(self.waterTrailers, trailer)
end

function WaterFillTrigger:removeWaterTrailer(trailer)
    for i = 1, table.getn(self.waterTrailers), 1 do
        if self.waterTrailers[i] == trailer then
            table.remove(self.waterTrailers, i)
            break
        end
    end

    if table.getn(self.waterTrailers) == 0 then
        g_currentMission:removeActivatableObject(self.WaterTankActivatable)
    end
    
    if self.isServer and self.waterTankFillTrailer == trailer then
        self:setIsWaterTankFilling(false)
    end;
end

function WaterFillTrigger:waterTankCapacity() 
    return self.Silo.getCapacity(self.fillType)
end

function WaterFillTrigger:waterTankFillLevel()
    return self.Silo.getFillLevel(self.fillType)
end

function WaterFillTrigger:setWaterTankFillLevel(lvl)
    self.Silo.setFillLevel(lvl, self.fillType)
end

function WaterFillTrigger:setIsWaterTankFilling(isWaterTankFilling, trailer, noEventSend)
    WaterFillTriggerSetIsFillingEvent.sendEvent(self.Silo.Parent, self.WasserTriggerId, isWaterTankFilling, trailer, noEventSend)
    if self.isWaterTankFilling ~= isWaterTankFilling then
        self.isWaterTankFilling = isWaterTankFilling
        self.waterTankFillTrailer = trailer
    end

    if self.isClient and self.sampleRefuel ~= nil then
        if isWaterTankFilling then
            playSample(self.sampleRefuel,0,1,0)
        else
            stopSample(self.sampleRefuel)
        end
    end

    return 
end

function WaterFillTrigger:triggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
    local trailer = g_currentMission.objectToTrailer[otherShapeId]

    if trailer ~= nil and trailer.fillTypes ~= nil then
        if onEnter then
            self:addWaterTrailer(trailer)
        else
            self:removeWaterTrailer(trailer)
        end
    end
end

WaterTankActivatable = {}
local WaterTankActivatable_mt = Class(WaterTankActivatable)
function WaterTankActivatable:new(Trigger)
    local self = {}

    setmetatable(self, WaterTankActivatable_mt)

    self.Trigger = Trigger
    self.activateText = "unknown"
    self.currentTrailer = nil

    return self
end
function WaterTankActivatable:getIsActivatable()
    self.currentTrailer = nil

    if self.Trigger:waterTankCapacity() <= self.Trigger:waterTankFillLevel() then
        return false
    end

    for _, trailer in pairs(self.Trigger.waterTrailers) do
        if trailer.getIsActiveForInput(trailer) and 0 < trailer.getFillLevel(trailer, self.Trigger.fillType) then
            self.currentTrailer = trailer

            self.updateActivateText(self)

            return true
        end
    end

    return false
end
function WaterTankActivatable:onActivateObject()
    self.Trigger:setIsWaterTankFilling(not self.Trigger.isWaterTankFilling, self.currentTrailer)
    self.updateActivateText(self)
    g_currentMission:addActivatableObject(self)
end
function WaterTankActivatable:drawActivate()
end
function WaterTankActivatable:updateActivateText()
    if self.Trigger.isWaterTankFilling then
        self.activateText = string.format(g_i18n:getText("stop_refill_OBJECT"), self.WaterFillTriggerName)
    else
        self.activateText = string.format(g_i18n:getText("refill_OBJECT"), self.WaterFillTriggerName)
    end
end

WaterFillTriggerSetIsFillingEvent = {}
WaterFillTriggerSetIsFillingEvent_mt = Class(WaterFillTriggerSetIsFillingEvent, Event)
InitEventClass(WaterFillTriggerSetIsFillingEvent, "WaterFillTriggerSetIsFillingEvent")
function WaterFillTriggerSetIsFillingEvent:emptyNew()
    local self = Event:new(WaterFillTriggerSetIsFillingEvent_mt)
    return self
end
function WaterFillTriggerSetIsFillingEvent:new(object, WasserTriggerId, isFilling, trailer)
    local self = WaterFillTriggerSetIsFillingEvent:emptyNew()
    self.object = object
    self.WasserTriggerId = WasserTriggerId;
    self.isFilling = isFilling
    self.trailer = trailer
    return self
end
function WaterFillTriggerSetIsFillingEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId))
    self.WasserTriggerId = streamReadInt32(streamId);
    self.isFilling = streamReadBool(streamId)

    if self.isFilling then
        self.trailer = networkGetObject(streamReadInt32(streamId))
    end

    self:run(connection)
end
function WaterFillTriggerSetIsFillingEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object))
    streamWriteInt32(streamId, self.WasserTriggerId)
    streamWriteBool(streamId, self.isFilling)

    if self.isFilling then
        streamWriteInt32(streamId, networkGetObjectId(self.trailer))
    end
end
function WaterFillTriggerSetIsFillingEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.object)
    end
    if self.object ~= nil then
        self.object:setIsWaterTankFilling(self.WasserTriggerId, self.isFilling, self.trailer, true)
    end;
end
function WaterFillTriggerSetIsFillingEvent.sendEvent(object, WasserTriggerId, isFilling, trailer, noEventSend)
    if (noEventSend == nil or noEventSend == false) then
        if g_server ~= nil then
            g_server:broadcastEvent(WaterFillTriggerSetIsFillingEvent:new(object, WasserTriggerId, isFilling, trailer), nil, nil, object)
        else
            g_client:getServerConnection():sendEvent(WaterFillTriggerSetIsFillingEvent:new(object, WasserTriggerId, isFilling, trailer))
        end
    end
end