ShiftableMassEvent = {};
ShiftableMassEvent_mt = Class(ShiftableMassEvent, Event);
InitEventClass(ShiftableMassEvent, "ShiftableMassEvent");
function ShiftableMassEvent:emptyNew()
    local self = Event:new(ShiftableMassEvent_mt);
    self.className="ShiftableMassEvent";
    return self;
end;

function ShiftableMassEvent:new(object, numDiscs)
    local self = ShiftableMassEvent:emptyNew(); 
    self.object = object; 
	self.numDiscs = numDiscs;
    return self;
end;

function ShiftableMassEvent:writeStream(streamId, connection)
	local id = networkGetObjectId(self.object);
    streamWriteInt32(streamId, id);
    streamWriteInt8(streamId, self.numDiscs);
end;

function ShiftableMassEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.numDiscs = streamReadInt8(streamId);
    self:run(connection);
end;

function ShiftableMassEvent:run(connection)
	self.object:setActiveDisks(self.numDiscs, true); 
	if not connection:getIsServer() then
		g_server:broadcastEvent(ShiftableMassEvent:new(self.object, self.numDiscs), nil, connection, self.object);
	end; 
end;

function ShiftableMassEvent.sendEvent(object, numDiscs, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(ShiftableMassEvent:new(object, numDiscs), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(ShiftableMassEvent:new(object, numDiscs)); 
		end;
	end;
end;