--
-- SpeedJoystick
--
-- written by fruktor, visit: www.eifok-team.de
--

SpeedJoystick = {};

SpeedJoystick.modDir = g_currentModDirectory;

function SpeedJoystick.prerequisitesPresent(specializations)
    return true; 
end;

function SpeedJoystick:load(savegame)
    self.sj = {};
    self.sj.node = Utils.indexToObject( self.components, getXMLString(self.xmlFile, "vehicle.speedJoystick#node") );
    self.sj.rotF = math.rad( getXMLFloat(self.xmlFile, "vehicle.speedJoystick#rotFront") );
    self.sj.rotB = math.rad( getXMLFloat(self.xmlFile, "vehicle.speedJoystick#rotBack") );
    self.sj.rotT = 0;
    self.sj.rotC = 0;
end;

function SpeedJoystick:delete()

end;

function SpeedJoystick:readStream(streamId, connection)
end;

function SpeedJoystick:writeStream(streamId, connection)
end;

function SpeedJoystick:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SpeedJoystick:keyEvent(unicode, sym, modifier, isDown)
end;

function SpeedJoystick:update(dt)

    if self:getIsActive() then
        if self.isClient then
            
            local axisForward = 0;
            axisForward = InputBinding.getInputAxis(InputBinding.AXIS_ACCELERATE_VEHICLE);
            axisBackward = InputBinding.getInputAxis(InputBinding.AXIS_BRAKE_VEHICLE);
            
            if InputBinding.isAxisZero(axisForward) then
                axisForward = InputBinding.getInputAxis(InputBinding.AXIS_ACCELERATE_VEHICLE)
            end;
            
            if InputBinding.isAxisZero(axisBackward) then
                axisBackward = InputBinding.getInputAxis(InputBinding.AXIS_BRAKE_VEHICLE)
            end;
            
            --print("axisForward="..axisForward);
            if axisForward < 0 then
                self.sj.rotT = -self.sj.rotF*axisForward;
                --vorwärts;
            else
                if axisBackward < 0 then
                self.sj.rotT = -self.sj.rotB*axisBackward;
                else
                    self.sj.rotT = 0;
                end
            end
            
            if self.ESLimiter ~= nil and self.lastLevel ~= 0 and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
                local percentage = self.ESLimiter.percentage;
                if InputBinding.isPressed(InputBinding.ESLimiter_PLUS) and percentage[self.lastLevel] < 100 then                    
                    self.sj.rotT = self.sj.rotF/2;
                elseif InputBinding.isPressed(InputBinding.ESLimiter_MINUS) and percentage[self.lastLevel] > 10 then
                    self.sj.rotT = self.sj.rotB/2;
                end;
            end;            
            
            if self.sj.rotC < self.sj.rotT then
                self.sj.rotC = self.sj.rotC + dt/1000;
                if self.sj.rotC > self.sj.rotT then
                    self.sj.rotC = self.sj.rotT;
                end;
            elseif self.sj.rotC > self.sj.rotT then
                self.sj.rotC = self.sj.rotC - dt/1000;
                if self.sj.rotC < self.sj.rotT then
                    self.sj.rotC = self.sj.rotT;
                end;
            end;
            
            setRotation( self.sj.node, self.sj.rotC, 0, 0 );
            
        end;
    end;

    --print("axisForward="..tostring(axisForward).." self.movingDirection="..tostring(self.movingDirection).." "..tostring(self.lastSpeed).."   self.lastSpeedReal="..tostring(self.lastSpeedReal));

    if self.motor.speedLevel ~= 0 then
    end;
    
end;

function SpeedJoystick:updateTick(dt)

end;

function SpeedJoystick:onLeave()
end;

function SpeedJoystick:draw()
end;





--
--
--
--
--
