--
-- ControlPanelAttacher
-- Specialization for a ControlPanelAttacher functionality
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.0
-- @date  		15/10/10
-- @history:	v1.0 - Initial version
--				v2.0 - converted to 2011 and some bugfixes
--

ControlPanelAttacher = {};

function ControlPanelAttacher.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function ControlPanelAttacher:load(savegame)

	self.addControlPanel = SpecializationUtil.callSpecializationsFunction("addControlPanel");
	self.removeControlPanel = SpecializationUtil.callSpecializationsFunction("removeControlPanel");
	
	local controlPanelCount = Utils.getNoNil(getXMLInt(self.xmlFile, "vehicle.controlPanels#count"), 0);
	
	self.controlPanels = {};
	for i=1, controlPanelCount do	
		local controlPanelName = string.format("vehicle.controlPanels.controlPanel%d", i);	

		local controlPanel = {};
		controlPanel.node = Utils.indexToObject(self.components, getXMLString(self.xmlFile, controlPanelName .. "#index"));
		controlPanel.loaded = nil;
		controlPanel.implement = nil;
		table.insert(self.controlPanels, controlPanel);
	end;

end;

function ControlPanelAttacher:delete()
end;

function ControlPanelAttacher:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ControlPanelAttacher:keyEvent(unicode, sym, modifier, isDown)
end;

function ControlPanelAttacher:update(dt)		
end;

function ControlPanelAttacher:draw()
end;

function ControlPanelAttacher:addControlPanel(object, position)	
	if object ~= nil then
		local controlPanelAttacher = nil;
		if position ~= nil and position < table.getn(self.controlPanels) then
			if self.controlPanels[position].loaded == nil then
				controlPanelAttacher = self.controlPanels[position];
			end;
		else		
			for k,v in pairs(self.controlPanels) do
				if v.loaded == nil then
					controlPanelAttacher = v;
					break;
				end;
			end;
		end;
		
		if controlPanelAttacher ~= nil then
			-- link i3d-File
			unlink(object.controlPanel);
			link(controlPanelAttacher.node, object.controlPanel);
			controlPanelAttacher.loaded = object.controlPanel;
			controlPanelAttacher.implement = object;					
			if object.interactiveControlPanel ~= nil then
				table.insert(self.interactiveObjects, object.interactiveControlPanel);
				object.isControlingActive = true;
			end;
			return true;
		end;		
	end;
	
	return false;
end;

function ControlPanelAttacher:removeControlPanel(object)
	if object ~= nil then
		for k,v in pairs(self.controlPanels) do
			if v.implement == object then
				if v.loaded ~= nil then
					-- unlink controlpanel
					unlink(v.loaded);
					link(object.detachPosition, v.loaded);
				end;
				v.loaded = nil;
				v.implement = nil;				
				
				if object.interactiveControlPanel ~= nil then
					for l,w in pairs(self.interactiveObjects) do
						if w == object.interactiveControlPanel then
							table.remove(self.interactiveObjects, l);
							break;
						end;
					end;
				end;			
				object.isControlingActive = false;			
				
				return true;
			end;
		end;
	end;
	
	return false;
end;

