--
-- DoorOpener
--
-- written by fruktor, visit: www.eifok-team.de
--

DoorOpener = {};

DoorOpener.modDir = g_currentModDirectory;

function DoorOpener.prerequisitesPresent(specializations)
    return true; 
end;

function DoorOpener:load(savegame)

	self.fhW = false;
	self.ct = 2000;

--	leftDoor
	self.playerCallbackleftDoor = SpecializationUtil.callSpecializationsFunction("playerCallbackleftDoor"); 
	
	self.doorO = {};
	
	local trigger = Utils.indexToObject( self.components, getXMLString(self.xmlFile, string.format("vehicle.leftDoorOpener#trigger")) );
	if trigger == nil then
		print("[Error::leftDoorOpener] node is OK, but trigger could not be located. Check line "..tostring(i+1).." in your vehicle.xml");
	end;
	
	local icIndex = getXMLInt(self.xmlFile, string.format("vehicle.leftDoorOpener#icIndex", i));
	
	self.doorO.icIndex = icIndex;
	self.doorO.trigger = trigger;
	self.doorO.plIR = false;
		
	addTrigger( trigger, "playerCallbackleftDoor", self );	

--	rightDoor
	self.playerCallbackrightDoor = SpecializationUtil.callSpecializationsFunction("playerCallbackrightDoor"); 
	
	self.door1 = {};
	
	local trigger = Utils.indexToObject( self.components, getXMLString(self.xmlFile, string.format("vehicle.rightDoorOpener#trigger")) );
	if trigger == nil then
		print("[Error::rightDoorOpener] node is OK, but trigger could not be located. Check line "..tostring(i+1).." in your vehicle.xml");
	end;
	
	local icIndex = getXMLInt(self.xmlFile, string.format("vehicle.rightDoorOpener#icIndex", i));
	
	self.door1.icIndex = icIndex;
	self.door1.trigger = trigger;
	self.door1.plIR = false;
		
	addTrigger( trigger, "playerCallbackrightDoor", self );	
	
--	attacher
	self.playerCallbackattacher = SpecializationUtil.callSpecializationsFunction("playerCallbackattacher"); 
	
	self.doorA = {};
	
	local trigger = Utils.indexToObject( self.components, getXMLString(self.xmlFile, string.format("vehicle.attacherOpener#trigger")) );
	if trigger == nil then
		print("[Error::attacherOpener] node is OK, but trigger could not be located. Check line "..tostring(i+1).." in your vehicle.xml");
	end;
	
	local icIndex = getXMLInt(self.xmlFile, string.format("vehicle.attacherOpener#icIndex", i));
	
	self.doorA.icIndex = icIndex;
	self.doorA.trigger = trigger;
	self.doorA.plIR = false;
		
	addTrigger( trigger, "playerCallbackattacher", self );		

--	fh
	self.playerCallbackfh = SpecializationUtil.callSpecializationsFunction("playerCallbackfh"); 
	
	self.doorfh = {};
	
	local trigger = Utils.indexToObject( self.components, getXMLString(self.xmlFile, string.format("vehicle.fhOpener#trigger")) );
	if trigger == nil then
		print("[Error::fhOpener] node is OK, but trigger could not be located. Check line "..tostring(i+1).." in your vehicle.xml");
	end;
	
	local icIndex = getXMLInt(self.xmlFile, string.format("vehicle.fhOpener#icIndex", i));
	
	self.doorfh.icIndex = icIndex;
	self.doorfh.trigger = trigger;
	self.doorfh.plIR = false;
		
	addTrigger( trigger, "playerCallbackfh", self );	
	
--	fenders
	--[[ self.playerCallbackfenders = SpecializationUtil.callSpecializationsFunction("playerCallbackfenders"); 
	
	self.doorFS = {};
	
	local trigger = Utils.indexToObject( self.components, getXMLString(self.xmlFile, string.format("vehicle.fendersOpener#trigger")) );
	if trigger == nil then
		print("[Error::fendersOpener] node is OK, but trigger could not be located. Check line "..tostring(i+1).." in your vehicle.xml");
	end;
	
	local icIndex = getXMLInt(self.xmlFile, string.format("vehicle.fendersOpener#icIndex", i));
	
	self.doorFS.icIndex = icIndex;
	self.doorFS.trigger = trigger;
	self.doorFS.plIR = false;
		
	addTrigger( trigger, "playerCallbackfenders", self ); ]]		
	
--	FL
	--[[ self.playerCallbackFL = SpecializationUtil.callSpecializationsFunction("playerCallbackFL"); 
	
	self.door2 = {};
	
	local trigger = Utils.indexToObject( self.components, getXMLString(self.xmlFile, string.format("vehicle.FLOpener#trigger")) );
	if trigger == nil then
		print("[Error::FLOpener] node is OK, but trigger could not be located. Check line "..tostring(i+1).." in your vehicle.xml");
	end;
	
	local icIndex = getXMLInt(self.xmlFile, string.format("vehicle.FLOpener#icIndex", i));
	
	self.door2.icIndex = icIndex;
	self.door2.trigger = trigger;
	self.door2.plIR = false;
		
	addTrigger( trigger, "playerCallbackFL", self );	 ]]	
	

end;

function DoorOpener:delete()
--	leftDoor	
	if self.doorO.trigger ~= nil then
		removeTrigger(self.doorO.trigger);
	end;
--	rightDoor
	if self.door1.trigger ~= nil then
		removeTrigger(self.door1.trigger);
	end;
--  attacher
	if self.doorA.trigger ~= nil then
		removeTrigger(self.doorA.trigger);
	end;
--  fh
	if self.doorfh.trigger ~= nil then
		removeTrigger(self.doorfh.trigger);
	end;
--  fenders
	--[[ if self.doorFS.trigger ~= nil then
		removeTrigger(self.doorFS.trigger);
	end; ]]
--  FL
	--[[ if self.door2.trigger ~= nil then
		removeTrigger(self.door2.trigger);
	end; ]]

end;

function DoorOpener:readStream(streamId, connection)
end;

function DoorOpener:writeStream(streamId, connection)
end;

function DoorOpener:mouseEvent(posX, posY, isDown, isUp, button)
end;

function DoorOpener:keyEvent(unicode, sym, modifier, isDown)
end;

function DoorOpener:updateTick(dt)
		
	if self.fhW then
		self.ct = self.ct - dt;
		if self.ct <0 then
			self.fhW = false;
			self.ct = 2000;
		end;
	end;
	
end;

function DoorOpener:update(dt)
--	leftDoor	
	if self.doorO.plIR then
		g_currentMission:addHelpButtonText( g_i18n:getText("SET_DOOROPENER"), InputBinding.SET_DOOROPENER );	
		setTextColor(1.0, 1.0, 1.0, 1.0);
		setTextAlignment(RenderText.ALIGN_LEFT); 				
		renderText( 0.5, 0.06, 0.02, g_i18n:getText("SET_DOOROPENER") );
		if InputBinding.hasEvent(InputBinding.SET_DOOROPENER)then
			local obj = self.interactiveObjects[self.doorO.icIndex];
			if obj ~= nil then
				--self.setDoor(not obj.isOpen);
				self:doActionOnObject(self.doorO.icIndex);
			end;
			
			--self.vehicle:playAnimation(self.animation, dir, Utils.clamp(self.vehicle:getAnimationTime(self.animation), 0, 1), true);
		end
	end;
--	rightDoor	
	if self.door1.plIR then
		g_currentMission:addHelpButtonText( g_i18n:getText("SET_DOOROPENER"), InputBinding.SET_DOOROPENER );	
		setTextColor(1.0, 1.0, 1.0, 1.0);
		setTextAlignment(RenderText.ALIGN_LEFT); 				
		renderText( 0.5, 0.06, 0.02, g_i18n:getText("SET_DOOROPENER") );
		if InputBinding.hasEvent(InputBinding.SET_DOOROPENER)then
			local obj = self.interactiveObjects[self.door1.icIndex];
			if obj ~= nil then
				--self.setDoor(not obj.isOpen);
				self:doActionOnObject(self.door1.icIndex);
			end;
			
			--self.vehicle:playAnimation(self.animation, dir, Utils.clamp(self.vehicle:getAnimationTime(self.animation), 0, 1), true);
		end
	end;
--  attacher	
	if self.doorA.plIR then
		g_currentMission:addHelpButtonText( g_i18n:getText("SET_attacherOPENER"), InputBinding.SET_DOOROPENER );	
		setTextColor(1.0, 1.0, 1.0, 1.0);
		setTextAlignment(RenderText.ALIGN_LEFT); 				
		renderText( 0.5, 0.06, 0.02, g_i18n:getText("SET_attacherOPENER") );
		if InputBinding.hasEvent(InputBinding.SET_DOOROPENER)then
			local obj = self.interactiveObjects[self.doorA.icIndex];
			if obj ~= nil then
				self:doActionOnObject(self.doorA.icIndex);
			end;
		end
	end;
--  fh	
	if self.doorfh.plIR then
		g_currentMission:addHelpButtonText( g_i18n:getText("SET_fhOPENER"), InputBinding.SET_DOOROPENER );	
		setTextColor(1.0, 1.0, 1.0, 1.0);
		setTextAlignment(RenderText.ALIGN_LEFT); 				
		renderText( 0.5, 0.06, 0.02, g_i18n:getText("SET_fhOPENER") );
		if InputBinding.hasEvent(InputBinding.SET_DOOROPENER)then
			local obj = self.interactiveObjects[self.doorfh.icIndex];
			if obj ~= nil then
			
				local sum = table.getn(self.attachedImplements);
				if sum ~= 0 then
					for i=1, sum do
						local implement = self.attachedImplements[i];
						local jointDescIndex = implement.jointDescIndex;
						if jointDescIndex ==2 then
							self.fhW = true;
							g_currentMission:showBlinkingWarning(g_i18n:getText("6810_fh_warning"), 2000);
							break;
						end;
					end;
					if not self.fhW then
						self:doActionOnObject(self.doorfh.icIndex);
					end;
				else
					self:doActionOnObject(self.doorfh.icIndex);
				end;
			
				--self:doActionOnObject(self.doorfh.icIndex);
			end;
		end
	end;
--  fenders	
	--[[ if self.doorFS.plIR then
		g_currentMission:addHelpButtonText( g_i18n:getText("SET_fendersOPENER"), InputBinding.SET_DOOROPENER );	
		setTextColor(1.0, 1.0, 1.0, 1.0);
		setTextAlignment(RenderText.ALIGN_LEFT); 				
		renderText( 0.5, 0.06, 0.02, g_i18n:getText("SET_fendersOPENER") );
		if InputBinding.hasEvent(InputBinding.SET_DOOROPENER)then
			local obj = self.interactiveObjects[self.doorFS.icIndex];
			if obj ~= nil then
				self:doActionOnObject(self.doorFS.icIndex);
			end;
		end
	end; ]]

	--  FL	
	--[[ if self.door2.plIR then
		g_currentMission:addHelpButtonText( g_i18n:getText("SET_FLOPENER"), InputBinding.SET_DOOROPENER );	
		setTextColor(1.0, 1.0, 1.0, 1.0);
		setTextAlignment(RenderText.ALIGN_LEFT); 				
		renderText( 0.5, 0.06, 0.02, g_i18n:getText("SET_FLOPENER") );
		if InputBinding.hasEvent(InputBinding.SET_DOOROPENER)then
			local obj = self.interactiveObjects[self.door2.icIndex];
			if obj ~= nil then
				self:doActionOnObject(self.door2.icIndex);
			end;
		end
	end; ]]

end;



function DoorOpener:onLeave()
end;

function DoorOpener:draw()
end;
--	leftDoor
function DoorOpener:playerCallbackleftDoor(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.doorO.plIR = true;
	elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.doorO.plIR = false;
	end;
end;
--	rightDoor
function DoorOpener:playerCallbackrightDoor(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.door1.plIR = true;
	elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.door1.plIR = false;
	end;
end;
--  attacher
function DoorOpener:playerCallbackattacher(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.doorA.plIR = true;
	elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.doorA.plIR = false;
	end;
end;
--  fh
function DoorOpener:playerCallbackfh(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.doorfh.plIR = true;
	elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.doorfh.plIR = false;
	end;
end;
--  fenders
--[[ function DoorOpener:playerCallbackfenders(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.doorFS.plIR = true;
	elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.doorFS.plIR = false;
	end;
end; ]]
--  FL
--[[ function DoorOpener:playerCallbackFL(triggerId, otherId, onEnter, onLeave, onStay)
	if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.door2.plIR = true;
	elseif onLeave and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
		self.door2.plIR = false;
	end;
end; ]]


