--
-- HydraulicRef
--
-- @author:    	Xentro (Marcus@Xentro.se)
-- @website:	www.Xentro.se
-- @history:	v1.0  - 2015-02-22 - Initial implementation
-- 				v1.01 - 2015-09-09 - Minor fix
-- 

HydraulicRef = {};

HydraulicRef.hoseTypes = {};
HydraulicRef.hoseTypes["hydraulic"] = true;
HydraulicRef.hoseTypes["electric"] = true;
HydraulicRef.hoseTypes["air"] = true;

function HydraulicRef.prerequisitesPresent(specializations)
    return true;
end;

function HydraulicRef:load(savegame)
	self.hydraulicSupport = true;
	HydraulicRef.loadRefs(self, xmlFile, "trailerAttacherJoint", HydraulicRef.loadRefs(self, xmlFile, "attacherJoint", 1));
end;

function HydraulicRef.loadRefs(self, xmlFile, tag, jointTableId)
	local i = 0;
	while true do
		local key = string.format("vehicle." .. tag .. "s." .. tag .. "(%d)", i);
		if not hasXMLProperty(self.xmlFile, key) then break; end;
		local joint = self.attacherJoints[jointTableId];
		
		if joint ~= nil then
			local subi = 0;
			while true do
				local key2 = string.format(key .. ".HydraulicRef(%d)", subi);
				if not hasXMLProperty(self.xmlFile, key2) then break; end;
				local node = Utils.indexToObject(self.components, getXMLString(self.xmlFile, key2 .. "#index"));
				local hoseType = getXMLString(self.xmlFile, key2 .. "#hoseType") or "hydraulic";
				
				if hoseType ~= nil and HydraulicRef.hoseTypes[string.lower(hoseType)] then
					if node ~= nil then
						if joint.HydraulicRefs == nil then
							joint.HydraulicRefs = {};
							
							for t in pairs(HydraulicRef.hoseTypes) do
								joint.HydraulicRefs[t] = {};
							end;
						end;
						
						table.insert(joint.HydraulicRefs[string.lower(hoseType)], node);
						subi = subi + 1;
					else
						print("HydraulicRef - Error: index is nil in " .. self.configFileName);
						break;
					end;
				else
					print("HydraulicRef - Error: hoseType is invalid, choose one of these (hydraulic, electric or air) " .. self.configFileName);
					break;
				end;
			end;
		end;
		
		jointTableId = jointTableId + 1;
		i = i + 1;
	end;
	
	return jointTableId;
end;

function HydraulicRef:delete()
end;

function HydraulicRef:readStream(streamId, connection)
end;

function HydraulicRef:writeStream(streamId, connection)
end;

function HydraulicRef:mouseEvent(posX, posY, isDown, isUp, button)
end;

function HydraulicRef:keyEvent(unicode, sym, modifier, isDown)
end;

function HydraulicRef:update(dt)
end;

function HydraulicRef:updateTick(dt)
end;

function HydraulicRef:draw()
end;