-- версия 25.04.2016
-- Автор Кирюха Тельтевской
-- http://vk.com/besedka_fermera

mechanism = {};
mechanism.modDir = g_currentModDirectory;

local animator_input;

function mechanism.prerequisitesPresent(specializations)
    return true;
end;

function mechanism:load(savegame)
	self.rotator_count = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.rotators#rotatorCount"));
	if self.rotator_count ~= nil then
		self.table_rotator_index = {};
		self.table_rotator_axis = {};
		self.table_rotator_spin = {};
		self.table_rotator_speed = {};
		self.table_rotator_rpm_depend = {};
		local string_rot_parts;
		local rotator_index;
		local rotator_axis;
		local rotator_spin;
		local rotator_rpm_depend;
		for i = 1, self.rotator_count do
			string_rot_parts = string.format("vehicle.rotators.rotatorPart%d", i);
			rotator_index = Utils.indexToObject(self.components, getXMLString(self.xmlFile, string_rot_parts .. "#index"));
			rotator_axis = Utils.getNoNil(getXMLFloat(self.xmlFile, string_rot_parts .. "#rotatorAxis"));
			rotator_spin = Utils.getNoNil(getXMLFloat(self.xmlFile, string_rot_parts .. "#rotatorSpin"));
			rotator_speed = Utils.getNoNil(getXMLFloat(self.xmlFile, string_rot_parts .. "#rotatorSpeed"));
			rotator_rpm_depend = Utils.getNoNil(getXMLFloat(self.xmlFile, string_rot_parts .. "#rotatorRpmDepend"));
			table.insert(self.table_rotator_index, rotator_index);
			table.insert(self.table_rotator_axis, rotator_axis);
			table.insert(self.table_rotator_spin, rotator_spin);
			table.insert(self.table_rotator_speed, rotator_speed);
			table.insert(self.table_rotator_rpm_depend, rotator_rpm_depend);
			i = i + 1;
		end;
	end;
	
	self.animator_count = Utils.getNoNil(getXMLFloat(self.xmlFile, "vehicle.animators#animatorCount"));
	if self.animator_count ~= nil then
		self.table_animator_name = {};
		self.table_animator_state = {};
		self.table_animator_help = {};
		self.table_animator_loop = {};
		self.table_animator_engine = {};
		local string_animators;
		local animator_name;
		local animator_help;
		for a = 1, self.animator_count do
			string_animators = string.format("vehicle.animators.animator%d", a);
			animator_name = getXMLString(self.xmlFile, string_animators .. "#name");
			animator_help = getXMLBool(self.xmlFile, string_animators .. "#helpText");
			animator_loop = Utils.getNoNil(getXMLBool(self.xmlFile, string_animators .. "#animLoop"));
			animator_engine = Utils.getNoNil(getXMLBool(self.xmlFile, string_animators .. "#isEngine"));
			table.insert(self.table_animator_name, animator_name);
			table.insert(self.table_animator_state, false);
			table.insert(self.table_animator_help, animator_help);
			table.insert(self.table_animator_loop, animator_loop);
			table.insert(self.table_animator_engine, animator_engine);
			a = a + 1;
		end;
	end;
end;

function mechanism:delete()
end;

function mechanism:mouseEvent(posX, posY, isDown, isUp, button)
end;

function mechanism:keyEvent(unicode, sym, modifier, isDown)
end;

function mechanism:update(dt)
	if self.rotator_count ~= nil then
		if self.isMotorStarted then
			local rot_speed;
			local rot_axis;
			local rot_rpm_depend;
			for i = 1, self.rotator_count do
				rot_axis = self.table_rotator_axis[i];
				rot_rpm_depend = self.table_rotator_rpm_depend[i];
				if rot_rpm_depend == 1 then
					rot_speed = self.motor.lastMotorRpm*0.00003*self.table_rotator_spin[i]*self.table_rotator_speed[i];
				elseif rot_rpm_depend == 0 then
					rot_speed = dt*0.01*self.table_rotator_spin[i]*self.table_rotator_speed[i];
				end;
				if rot_axis == 1 then
					rotate(self.table_rotator_index[i], rot_speed, 0, 0);
				elseif rot_axis == 2 then
					rotate(self.table_rotator_index[i], 0, rot_speed, 0);
				elseif rot_axis == 3 then
					rotate(self.table_rotator_index[i], 0, 0, rot_speed);
				end;
				i = i + 1;
			end;
		end;
	end;
	
	if self.animator_count ~= nil then
		for a = 1, self.animator_count do
			animator_input = string.format("animator%d", a);
			if InputBinding.hasEvent(InputBinding[animator_input]) then
				if self.table_animator_loop[a] then
					if self.table_animator_state[a] then
						self.table_animator_state[a] = false;
					else
						self.table_animator_state[a] = true;
					end;
				else
					if self.table_animator_state[a] then
						self:playAnimation(self.table_animator_name[a], 1, nil, true);
						self.table_animator_state[a] = false;
					else
						self:playAnimation(self.table_animator_name[a], -1, nil, true);
						self.table_animator_state[a] = true;
					end;
				end;
			end;
			if self.table_animator_loop[a] then
				if self.table_animator_state[a] then
					self:playAnimation(self.table_animator_name[a], 1, nil, true);
				end;
			end;
			if self.table_animator_loop[a] and self.table_animator_engine[a] then
				if self.isMotorStarted then
					self:playAnimation(self.table_animator_name[a], 1, nil, true);
				end;
			end;
			a = a + 1;
		end;
	end;
end;

function mechanism:draw()
	if self.animator_count ~= nil then
		local help_text_button;
		for a = 1, self.animator_count do
			if self.table_animator_help[a] then
				help_text_button = string.format("animator%d", a);
				g_currentMission:addHelpButtonText(g_i18n:getText(help_text_button), InputBinding[help_text_button]);
			end;
		end;
	end;
end;