--
-- Author RivalBomb
-- 05.01.2016
--
-- rightDoor rightWindow frontWindow backWindow leftDoor leftWindow
--
noisesound = {};

function noisesound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function noisesound:load(xmlFile)

	if self.isClient then
		-- rightDoor
		self.sampleOpenrightDoor = Utils.loadSample(xmlFile, {}, 	"vehicle.openDoorSound", "sounds/door_open.ogg", self.baseDirectory, self.components[1].node);
		self.sampleCloserightDoor = Utils.loadSample(xmlFile, {}, 	"vehicle.closeDoorSound", "sounds/door_close.ogg", self.baseDirectory, self.components[1].node);
		
		-- rightWindow
		self.sampleOpenrightWindow = Utils.loadSample(xmlFile, {}, 	"vehicle.openWindowSound", "sounds/side_open.ogg", self.baseDirectory, self.components[1].node);
		self.sampleCloserightWindow = Utils.loadSample(xmlFile, {}, "vehicle.closeWindowSound", "sounds/side_close.ogg", self.baseDirectory, self.components[1].node);
		
		-- frontWindow
		self.sampleOpenfrontWindow = Utils.loadSample(xmlFile, {}, 	"vehicle.openWindowSound", "sounds/window_open.ogg", self.baseDirectory, self.components[1].node);
		self.sampleClosefrontWindow = Utils.loadSample(xmlFile, {}, "vehicle.closeWindowSound", "sounds/window_close.ogg", self.baseDirectory, self.components[1].node);
		
		-- backWindow
		self.sampleOpenbackWindow = Utils.loadSample(xmlFile, {}, 	"vehicle.openWindowSound", "sounds/window_open.ogg", self.baseDirectory, self.components[1].node);
		self.sampleClosebackWindow = Utils.loadSample(xmlFile, {}, 	"vehicle.closeWindowSound", "sounds/window_close.ogg", self.baseDirectory, self.components[1].node);
		
		-- leftDoor
		self.sampleOpenleftDoor = Utils.loadSample(xmlFile, {}, 	"vehicle.openDoorSound", "sounds/door_open.ogg", self.baseDirectory, self.components[1].node);
		self.sampleCloseleftDoor = Utils.loadSample(xmlFile, {}, 	"vehicle.closeDoorSound", "sounds/door_close.ogg", self.baseDirectory, self.components[1].node);
		
		-- leftWindow
		self.sampleOpenleftWindow = Utils.loadSample(xmlFile, {}, 	"vehicle.openWindowSound", "sounds/side_open.ogg", self.baseDirectory, self.components[1].node);
		self.sampleCloseleftWindow = Utils.loadSample(xmlFile, {}, 	"vehicle.closeWindowSound", "sounds/side_close.ogg", self.baseDirectory, self.components[1].node);
		
		-- fenders
		--[[ self.sampleMountfenders = Utils.loadSample(xmlFile, {}, "vehicle.MountfendersSound", "sounds/fendersunmount.ogg", self.baseDirectory, self.components[1].node);
		self.sampleUnmountfenders = Utils.loadSample(xmlFile, {}, "vehicle.UnmountfendersSound", "sounds/fendersmount.ogg", self.baseDirectory, self.components[1].node); ]]
		
		-- attacher & fh
		self.sampleMountattacher = Utils.loadSample(xmlFile, {}, "vehicle.MountattacherSound", "sounds/attacher.ogg", self.baseDirectory, self.components[1].node);
		self.sampleUnmountattacher = Utils.loadSample(xmlFile, {}, "vehicle.UnmountattacherSound", "sounds/attacher.ogg", self.baseDirectory, self.components[1].node);
		
		-- FL
		-- self.sampleMountFL = Utils.loadSample(xmlFile, {}, "vehicle.MountFLSound", "sounds/FLmount.ogg", self.baseDirectory, self.components[1].node);
		-- self.sampleUnmountFL = Utils.loadSample(xmlFile, {}, "vehicle.UnmountFLsound", "sounds/FLmount.ogg", self.baseDirectory, self.components[1].node);
	end;
end;

function noisesound:delete()
	-- rightDoor
	if self.sampleOpenrightDoor ~= nil then
		Utils.deleteSample(self.sampleOpenrightDoor);
	end;
	if self.sampleCloserightDoor ~= nil then
		Utils.deleteSample(self.sampleCloserightDoor);
	end;
	
	-- rightWindow
	if self.sampleOpenrightWindow ~= nil then
		Utils.deleteSample(self.sampleOpenrightWindow);
	end;
	if self.sampleCloserightWindow ~= nil then
		Utils.deleteSample(self.sampleCloserightWindow);
	end;
	
	-- frontWindow
	if self.sampleOpenfrontWindow ~= nil then
		Utils.deleteSample(self.sampleOpenfrontWindow);
	end;
	if self.sampleClosefrontWindow ~= nil then
		Utils.deleteSample(self.sampleClosefrontWindow);
	end;
	
	-- backWindow
	if self.sampleOpenbackWindow ~= nil then
		Utils.deleteSample(self.sampleOpenbackWindow);
	end;
	if self.sampleClosebackWindow ~= nil then
		Utils.deleteSample(self.sampleClosebackWindow);
	end;
	
	-- leftDoor
	if self.sampleOpenleftDoor ~= nil then
		Utils.deleteSample(self.sampleOpenleftDoor);
	end;
	if self.sampleCloseleftDoor ~= nil then
		Utils.deleteSample(self.sampleCloseleftDoor);
	end;
	
	-- leftWindow
	if self.sampleOpenleftWindow ~= nil then
		Utils.deleteSample(self.sampleOpenleftWindow);
	end;
	if self.sampleCloseleftWindow ~= nil then
		Utils.deleteSample(self.sampleCloseleftWindow);
	end;
	
	-- fenders
	--[[ if self.sampleMountfenders ~= nil then
		Utils.deleteSample(self.sampleMountfenders);
	end;
	if self.sampleUnmountfenders ~= nil then
		Utils.deleteSample(self.sampleUnmountfenders);
	end; ]]
	
	-- attacher
	if self.sampleMountattacher ~= nil then
		Utils.deleteSample(self.sampleMountattacher);
	end;
	if self.sampleUnmountattacher ~= nil then
		Utils.deleteSample(self.sampleUnmountattacher);
	end;
	
	-- FL
	--[[ if self.sampleMountFL ~= nil then
		Utils.deleteSample(self.sampleMountFL);
	end;
	if self.sampleUnmountFL ~= nil then
		Utils.deleteSample(self.sampleUnmountFL);
	end; ]]
end;

function noisesound:mouseEvent(posX, posY, isDown, isUp, button)
end;

function noisesound:keyEvent(unicode, sym, modifier, isDown)
end;

function noisesound:update(dt)
			-- rightDoor
			if self:getIsAnimationPlaying("rightDoor") then
				if self.animations["rightDoor"].currentSpeed > 0 then
					if (not Utils.isSamplePlaying(self.sampleOpenrightDoor, dt) and not Utils.isSamplePlaying(self.sampleCloserightDoor, dt)) then
						Utils.playSample(self.sampleOpenrightDoor,1,1,nil);
					end;
				elseif self.animations["rightDoor"].currentSpeed < 0 then
					if (not Utils.isSamplePlaying(self.sampleCloserightDoor, dt) and not Utils.isSamplePlaying(self.sampleOpenrightDoor, dt)) then
						Utils.playSample(self.sampleCloserightDoor,1,1,nil);
					end;
				end;
			end;
			
			-- rightWindow
			if self:getIsAnimationPlaying("rightWindow") then
				if self.animations["rightWindow"].currentSpeed > 0 then
					if (not Utils.isSamplePlaying(self.sampleOpenrightWindow, dt) and not Utils.isSamplePlaying(self.sampleCloserightWindow, dt)) and self:getIsActiveForSound() then
						Utils.playSample(self.sampleOpenrightWindow,1,1,nil);
					end;
				elseif self.animations["rightWindow"].currentSpeed < 0 then
					if (not Utils.isSamplePlaying(self.sampleCloserightWindow, dt) and not Utils.isSamplePlaying(self.sampleOpenrightWindow, dt)) and self:getIsActiveForSound() then
						Utils.playSample(self.sampleCloserightWindow,1,1,nil);
					end;
				end;
			end;
			
			-- frontWindow
			if self:getIsAnimationPlaying("frontWindow") then
				if self.animations["frontWindow"].currentSpeed > 0 then
					if (not Utils.isSamplePlaying(self.sampleOpenfrontWindow, dt) and not Utils.isSamplePlaying(self.sampleClosefrontWindow, dt)) and self:getIsActiveForSound() then
						Utils.playSample(self.sampleOpenfrontWindow,1,1,nil);
					end;
				elseif self.animations["frontWindow"].currentSpeed < 0 then
					if (not Utils.isSamplePlaying(self.sampleClosefrontWindow, dt) and not Utils.isSamplePlaying(self.sampleOpenfrontWindow, dt)) and self:getIsActiveForSound() then
						Utils.playSample(self.sampleClosefrontWindow,1,1,nil);
					end;
				end;
			end;
			
			-- backWindow
			if self:getIsAnimationPlaying("backWindow") then
				if self.animations["backWindow"].currentSpeed > 0 then
					if (not Utils.isSamplePlaying(self.sampleOpenbackWindow, dt) and not Utils.isSamplePlaying(self.sampleClosebackWindow, dt)) and self:getIsActiveForSound() then
						Utils.playSample(self.sampleOpenbackWindow,1,1,nil);
					end;
				elseif self.animations["backWindow"].currentSpeed < 0 then
					if (not Utils.isSamplePlaying(self.sampleClosebackWindow, dt) and not Utils.isSamplePlaying(self.sampleOpenbackWindow, dt)) and self:getIsActiveForSound() then
						Utils.playSample(self.sampleClosebackWindow,1,1,nil);
					end;
				end;
			end;
			
			-- leftDoor
			if self:getIsAnimationPlaying("leftDoor") then
				if self.animations["leftDoor"].currentSpeed > 0 then
					if (not Utils.isSamplePlaying(self.sampleOpenleftDoor, dt) and not Utils.isSamplePlaying(self.sampleCloseleftDoor, dt)) then
						Utils.playSample(self.sampleOpenleftDoor,1,1,nil);
					end;
				elseif self.animations["leftDoor"].currentSpeed < 0 then
					if (not Utils.isSamplePlaying(self.sampleCloseleftDoor, dt) and not Utils.isSamplePlaying(self.sampleOpenleftDoor, dt)) then
						Utils.playSample(self.sampleCloseleftDoor,1,1,nil);
					end;
				end;
			end;
			
			-- leftWindow
			if self:getIsAnimationPlaying("leftWindow") then
				if self.animations["leftWindow"].currentSpeed > 0 then
					if (not Utils.isSamplePlaying(self.sampleOpenleftWindow, dt) and not Utils.isSamplePlaying(self.sampleCloseleftWindow, dt)) and self:getIsActiveForSound() then
						Utils.playSample(self.sampleOpenleftWindow,1,1,nil);
					end;
				elseif self.animations["leftWindow"].currentSpeed < 0 then
					if (not Utils.isSamplePlaying(self.sampleCloseleftWindow, dt) and not Utils.isSamplePlaying(self.sampleOpenleftWindow, dt)) and self:getIsActiveForSound() then
						Utils.playSample(self.sampleCloseleftWindow,1,1,nil);
					end;
				end;
			end;
			
			-- fenders
			--[[ if self:getIsAnimationPlaying("fenders") then
				if self.animations["fenders"].currentSpeed > 0 then
					if (not Utils.isSamplePlaying(self.sampleMountfenders, dt) and not Utils.isSamplePlaying(self.sampleUnmountfenders, dt)) then
						Utils.playSample(self.sampleMountfenders,1,1,nil);
					end;
				elseif self.animations["fenders"].currentSpeed < 0 then
					if (not Utils.isSamplePlaying(self.sampleUnmountfenders, dt) and not Utils.isSamplePlaying(self.sampleMountfenders, dt)) then
						Utils.playSample(self.sampleUnmountfenders,1,1,nil);
					end;
				end;
			end; ]]
			
			-- attacher
			if self:getIsAnimationPlaying("attacher") then
				if self.animations["attacher"].currentSpeed > 0 then
					if (not Utils.isSamplePlaying(self.sampleMountattacher, dt) and not Utils.isSamplePlaying(self.sampleUnmountattacher, dt)) then
						Utils.playSample(self.sampleMountattacher,1,1,nil);
					end;
				elseif self.animations["attacher"].currentSpeed < 0 then
					if (not Utils.isSamplePlaying(self.sampleUnmountattacher, dt) and not Utils.isSamplePlaying(self.sampleMountattacher, dt)) then
						Utils.playSample(self.sampleUnmountattacher,1,1,nil);
					end;
				end;
			end;
			
			-- fh
			if self:getIsAnimationPlaying("fh") then
				if self.animations["fh"].currentSpeed > 0 then
					if (not Utils.isSamplePlaying(self.sampleMountattacher, dt) and not Utils.isSamplePlaying(self.sampleUnmountattacher, dt)) then
						Utils.playSample(self.sampleMountattacher,1,1,nil);
					end;
				elseif self.animations["fh"].currentSpeed < 0 then
					if (not Utils.isSamplePlaying(self.sampleUnmountattacher, dt) and not Utils.isSamplePlaying(self.sampleMountattacher, dt)) then
						Utils.playSample(self.sampleUnmountattacher,1,1,nil);
					end;
				end;
			end;
			
			-- FL
			--[[ if self:getIsAnimationPlaying("FL") then
				if self.animations["FL"].currentSpeed > 0 then
					if (not Utils.isSamplePlaying(self.sampleMountFL, dt) and not Utils.isSamplePlaying(self.sampleUnmountFL, dt)) then
						Utils.playSample(self.sampleMountFL,1,1,nil);
					end;
				elseif self.animations["FL"].currentSpeed < 0 then
					if (not Utils.isSamplePlaying(self.sampleUnmountFL, dt) and not Utils.isSamplePlaying(self.sampleMountFL, dt)) then
						Utils.playSample(self.sampleUnmountFL,1,1,nil);
					end;
				end;
			end; ]]
		end;

function noisesound:updateTick(dt)
end;

function noisesound:draw()	
end;