--
-- Blades
-- Specialization for Blades
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.5
-- @date  		10/07/16
-- @history:	v1.0 - Initial version
--				v1.5 - rewriten for fs15, removed some stuff @Michi77
--
-- free for noncommerical-usage
--

Blades = {};

function Blades.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function Blades:load(xmlFile)
	
	self.blades = {};
	local vertical = {};
	vertical.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blades#vertical"));
	vertical.max = getXMLFloat(xmlFile, "vehicle.blades#vertMax");
	vertical.speed = getXMLFloat(xmlFile, "vehicle.blades#vertSpeed") * 1000;	
	vertical.dir = 1;
	local horizontal = {};
	horizontal.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blades#horizontal"));
	horizontal.max = getXMLFloat(xmlFile, "vehicle.blades#horizMax");
	horizontal.speed = getXMLFloat(xmlFile, "vehicle.blades#horizSpeed") * 1000;
	horizontal.dir = 1;
	local horizontal2 = {};
	horizontal2.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blades#horizontal2"));
	horizontal2.max = getXMLFloat(xmlFile, "vehicle.blades#horizMax2");
	horizontal2.speed = getXMLFloat(xmlFile, "vehicle.blades#horizSpeed2") * 1000;
	horizontal2.dir = 1;
	
	
	self.blades.vertical = vertical;
	self.blades.horizontal = horizontal;
	self.blades.horizontal2 = horizontal2;
	
end;

function Blades:postLoad(xmlFile)
end;

function Blades:delete()
end;

function Blades:readStream(streamId, connection)
end;

function Blades:writeStream(streamId, connection)
end;

function Blades:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Blades:keyEvent(unicode, sym, modifier, isDown)
end;

function Blades:update(dt)
	if self:getIsActive() and self.reelStarted then
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / 11, 1.3));
		if self.blades.vertical.node ~= nil then
			local x1,y1,z1 = getTranslation(self.blades.vertical.node);
			if y1 < 0.005 or y1 > (self.blades.vertical.max - 0.005) then
				self.blades.vertical.dir = math.abs(self.blades.vertical.dir - 1);
			end;
			local newTrans = Utils.getMovedLimitedValues({y1}, {self.blades.vertical.max}, {0}, 1, self.blades.vertical.speed / percent, dt, self.blades.vertical.dir ~= 0);
			setTranslation(self.blades.vertical.node, x1, unpack(newTrans), z1);
		end;
		if self.blades.horizontal.node ~= nil then
			local x2,y2,z2 = getTranslation(self.blades.horizontal.node);
			if x2 < 0.005 or x2 > (self.blades.horizontal.max - 0.005) then
				self.blades.horizontal.dir = math.abs(self.blades.horizontal.dir - 1);
			end;
			local newTrans = Utils.getMovedLimitedValues({x2}, {self.blades.horizontal.max}, {0}, 1, self.blades.horizontal.speed / percent, dt, self.blades.horizontal.dir ~= 0);
			setTranslation(self.blades.horizontal.node, unpack(newTrans), y2, z2);
		end;
		if self.blades.horizontal2.node ~= nil then
			local x2,y2,z2 = getTranslation(self.blades.horizontal2.node);
			if x2 < 0.005 or x2 > (self.blades.horizontal2.max - 0.005) then
				self.blades.horizontal2.dir = math.abs(self.blades.horizontal2.dir - 1);
			end;
			local newTrans = Utils.getMovedLimitedValues({x2}, {self.blades.horizontal2.max}, {0}, 1, self.blades.horizontal2.speed / percent, dt, self.blades.horizontal2.dir ~= 0);
			setTranslation(self.blades.horizontal2.node, unpack(newTrans), y2, z2);
		end;
	end;
end;

function Blades:updateTick(dt)
end;

function Blades:draw()	
end;
