--
-- Blades2
-- Specialization for Blades2
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.5
-- @date  		10/07/16
-- @history:	v1.0 - Initial version
--				v1.5 - rewriten for fs15, removed some stuff @Michi77
--
-- free for noncommerical-usage
--

Blades2 = {};

function Blades2.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Cutter, specializations) and SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function Blades2:load(xmlFile)
	
	self.blades = {};
	local horizontal = {};
	horizontal.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.blades#horizontal"));
	horizontal.max = getXMLFloat(xmlFile, "vehicle.blades#horizMax");
	horizontal.speed = getXMLFloat(xmlFile, "vehicle.blades#horizSpeed") * 1000;
	horizontal.dir = 1;
	
	self.blades.horizontal = horizontal;
	
end;

function Blades2:postLoad(xmlFile)
end;

function Blades2:delete()
end;

function Blades2:readStream(streamId, connection)
end;

function Blades2:writeStream(streamId, connection)
end;

function Blades2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Blades2:keyEvent(unicode, sym, modifier, isDown)
end;

function Blades2:update(dt)
	if self:getIsActive() and self.reelStarted then
		local percent = math.max(0.85, math.min((self.lastSpeed*3600) / 11, 1.3));
		if self.blades.horizontal.node ~= nil then
			local x2,y2,z2 = getTranslation(self.blades.horizontal.node);
			if x2 < 0.005 or x2 > (self.blades.horizontal.max - 0.005) then
				self.blades.horizontal.dir = math.abs(self.blades.horizontal.dir - 1);
			end;
			local newTrans = Utils.getMovedLimitedValues({x2}, {self.blades.horizontal.max}, {0}, 1, self.blades.horizontal.speed / percent, dt, self.blades.horizontal.dir ~= 0);
			setTranslation(self.blades.horizontal.node, unpack(newTrans), y2, z2);
		end;
	end;
end;

function Blades2:updateTick(dt)
end;

function Blades2:draw()	
end;
