--
--	SwitchMouseControl
--
--	written by fruktor
--	visit: www.eifok-team.de
--
--
--	free of charge
--
--


local mod_directory = g_currentModDirectory;
source(Utils.getFilename("scripts/SetActiveMCEvent.lua", mod_directory));



SwitchMouseControl = {};

function SwitchMouseControl.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(MouseControlsVehicle, specializations);
end;

function SwitchMouseControl:load(xmlFile)
	self.setActiveMC = SpecializationUtil.callSpecializationsFunction("setActiveMC");

	self.isSelectable = true;
	
	self.updateOrig = Utils.overwrittenFunction(self.updateOrig, SwitchMouseControl.update);
	
	local cnt = getXMLInt(xmlFile, "vehicle.switchMouseControl#count");	
	self.activeMC			= 1;
	self.activeMCcnt		= cnt;

	self.mc = {};
	self.mcNames = {};
	
	for i=1,cnt do 
		
		self.mc[i] = {};
		
		local name = getXMLString(xmlFile, string.format("vehicle.switchMouseControl.mc%d#name", i) );
		if name == nil then
			print("Error: SwitchMouseControl could not find enough entries");
			break;
		end;
		self.mcNames[i] = name;
		r = 1;
		while true do
			local idx = getXMLInt(xmlFile, string.format("vehicle.switchMouseControl.mc%d#index%d", i, r) );
			if idx == nil then break;
			else
				table.insert( self.mc[i], idx );
			end;
			r = r + 1;
		end;		
	end;
	
	for i,tool in pairs(self.movingTools) do
		tool.rotSpeedBackup = nil;
		tool.transSpeedBackUp = nil;
		if tool.rotSpeed ~= nil then
			tool.rotSpeedBackup = tool.rotSpeed;
			tool.rotSpeed = nil;
		end;
		if tool.transSpeed ~= nil then
			tool.transSpeedBackup = tool.transSpeed;
			tool.transSpeed = nil;
		end;
	end;	

	for i,j in pairs(self.mc[self.activeMC]) do
		if self.movingTools[j].rotSpeedBackup ~= nil then
			self.movingTools[j].rotSpeed = self.movingTools[j].rotSpeedBackup;
		end;
		if self.movingTools[j].transSpeedBackup ~= nil then
			self.movingTools[j].transSpeed = self.movingTools[j].transSpeedBackUp;
		end;
	end;
	
	for axis,entry in pairs(self.mouseControlsIcons) do	
		entry.backUpIcon = entry.iconFilename;
		entry.iconFilename = nil;
	end;

	self:setActiveMC( self.activeMC );
	
	g_mouseControlsHelp.active = false;
end;


function SwitchMouseControl:delete()
end;
	
function SwitchMouseControl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function SwitchMouseControl:keyEvent(unicode, sym, modifier, isDown)
end;

function SwitchMouseControl:update(dt)
	g_mouseControlsHelp.active = false;
	if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
		if InputBinding.hasEvent(InputBinding.SWITCHMC) then
			local tmp = self.activeMC + 1;
			if tmp > self.activeMCcnt then 
				tmp = 1;
			end;
			self:setActiveMC( tmp );
		end;	
	end;
end;

function SwitchMouseControl:updateOrig(dt)	--
print(" function SwitchMouseControl:updateOrig(dt)	--");
	if self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then

		local foldAnimTime = self.foldAnimTime;
		local xFilename = "";
		local yFilename = "";
		for axis,entry in pairs(self.mouseControlsIcons) do
			local actionIndex = InputBinding[axis];
			if actionIndex ~= nil and (foldAnimTime == nil or (foldAnimTime <= entry.foldMaxLimit and foldAnimTime >= entry.foldMinLimit)) then
				if InputBinding.getIsInputMouseAxisTriggered(actionIndex) then
					if InputBinding.actions[actionIndex].mouseAxis == InputBinding.MOUSE_AXIS_X then
						xFilename = entry.iconFilename;
					elseif InputBinding.actions[actionIndex].mouseAxis == InputBinding.MOUSE_AXIS_Y then
						yFilename = entry.iconFilename;
					end
				end
				if not GS_IS_CONSOLE_VERSION then
					if InputBinding.actions[actionIndex].mouseAxis ~= InputBinding.MOUSE_AXIS_NONE then
						g_currentMission:setShowHasMouseButtonInput(true);
					end
				end
			end
		end
	end
end

function SwitchMouseControl:updateTick(dt)
end;

function SwitchMouseControl:draw()
	if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
		g_currentMission:addHelpButtonText( string.format( g_i18n:getText("SWITCHMC"), self.mcNames[self.activeMC]), InputBinding.SWITCHMC );
	end;
end;

function SwitchMouseControl:onDetach()
end;

function SwitchMouseControl:setActiveMC(idx, noEventSend)
	SetActiveMCEvent.sendEvent(self, idx, noEventSend);
	self.activeMC = idx;
	for i,j in pairs(self.mc) do
		for k,l in pairs(j) do 
			if i == idx then
				self.movingTools[l].rotSpeed = self.movingTools[l].rotSpeedBackup;
				self.movingTools[l].transSpeed = self.movingTools[l].transSpeedBackup;
			else
				self.movingTools[l].rotSpeed = nil;
				self.movingTools[l].transSpeed = nil;
			end;	
		end;
	end;	
end;