--
-- AloeBalefork
-- Specialization for  Aloe Ballengabel
--
-- @author  Stefan Maurus	
-- @date  03/08/13

-- Copyright  Stefan Maurus, www.stefanmaurus.de

AloeBalefork = {};

function AloeBalefork.prerequisitesPresent(specializations)
    return true;
end;

function AloeBalefork:load(xmlFile)
	self.setForkState = SpecializationUtil.callSpecializationsFunction("setForkState"); 

    self.forkSwitch = getXMLString(xmlFile, "vehicle.forkSwitch#name");
	self.forkState = false;
end;

function AloeBalefork:readStream(streamId, connection)
	self:setForkState(streamReadBool(streamId), true); 
end;

function AloeBalefork:writeStream(streamId, connection) 
	streamWriteBool(streamId, self.forkState); 
end;

function AloeBalefork:setForkState(bool, noEventSend)
	self.forkState = bool;
	if bool then
		self:playAnimation(self.forkSwitch, 1, nil, true);
	else
		self:playAnimation(self.forkSwitch, -1, nil, true);	
	end;
	SetForkStateEvent.sendEvent(self, bool, noEventSend);
end;

function AloeBalefork:delete()
end;

function AloeBalefork:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AloeBalefork:keyEvent(unicode, sym, modifier, isDown)
end;

function AloeBalefork:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self:setForkState(not self.forkState);
		end;	
	end;
end;

function AloeBalefork:updateTick(dt)
end;

function AloeBalefork:onAttach()
end;

function AloeBalefork:onDetach()	
end;

function AloeBalefork:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("ALOE_BALEFORK_SWITCH"), InputBinding.IMPLEMENT_EXTRA2);
end;

SetForkStateEvent = {};
SetForkStateEvent_mt = Class(SetForkStateEvent, Event);

InitEventClass(SetForkStateEvent, "SetForkStateEvent");

function SetForkStateEvent:emptyNew()
    local self = Event:new(SetForkStateEvent_mt);
    self.className="SetForkStateEvent";
    return self;
end;

function SetForkStateEvent:new(vehicle, forkState)
    local self = SetForkStateEvent:emptyNew()
    self.vehicle = vehicle;
	self.forkState = forkState;
    return self;
end;

function SetForkStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);

	self.forkState = streamReadBool(streamId);
	self.vehicle:setForkState(self.forkState, true);
	
	if not connection:getIsServer() then
        g_server:broadcastEvent(SetForkStateEvent:new(self.vehicle, self.forkState), nil, connection, self.vehicle);
    end;
end;

function SetForkStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.forkState);
end;


function SetForkStateEvent.sendEvent(vehicle, forkState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetForkStateEvent:new(vehicle, forkState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetForkStateEvent:new(vehicle, forkState));
		end;
	end;
end;