--
-- changeableWeight
-- Specialization for changing the weight
--
-- @author  Stefan Maurus	
-- @date  21/06/14

-- Copyright  Stefan Maurus, www.stefanmaurus.de

--[[
<!--xml stuff-->
	<changeableWeight basicWeight="WEIGHT">
		<part weight="WEIGHT" node="INDEX" />
		<part weight="WEIGHT" node="INDEX" />
	</changeableWeight>	
]]

changeableWeight = {};

function changeableWeight.prerequisitesPresent(specializations)
    return true;
end;

function changeableWeight:load(xmlFile)	
	self.setCurrentWeight = SpecializationUtil.callSpecializationsFunction("setCurrentWeight");
	
	self.currentWeight = 1;
	self.basicWeight = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.changeableWeight#basicWeight"), 150)/1000;
	self.currentWeightTo = basicWeight;
	
	local i = 0;
	self.changeableWeights = {};
	while true do
        local key = string.format("vehicle.changeableWeight.part(%d)", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		
		local weight = Utils.getNoNil(getXMLFloat(xmlFile, key.."#weight"), 250)/1000;	
		local node = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#node"));	

		table.insert(self.changeableWeights, {weight=weight,node=node});
		i = i + 1;
		self.numberOfParts = i;
	end;
	
	self:setCurrentWeight(self.currentWeight);	
end;

function changeableWeight:delete()
end;

function changeableWeight:readStream(streamId, connection)
	self:setCurrentWeight(streamReadInt8(streamId), true);
end;

function changeableWeight:writeStream(streamId, connection) 
	streamWriteInt8(streamId, self.currentWeight); 
end;

function changeableWeight:setCurrentWeight(cur, noEventSend)	
	if cur > self.numberOfParts+1 then
		cur = 1;
	end;
	self.currentWeight = cur;
	local weight = self.basicWeight;	
	for i, part in pairs(self.changeableWeights) do
		if i < cur then 
			setVisibility(self.changeableWeights[i].node, true);
			weight = weight + self.changeableWeights[i].weight;
		else
			setVisibility(self.changeableWeights[i].node, false);
		end;
	end;
	setMass(self.components[1].node, weight);
	self.currentWeightTo = weight;
	SetCurrentWeightEvent.sendEvent(self, cur, noEventSend);
end;

function changeableWeight:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local currentWeight = getXMLInt(xmlFile, key .. "#currentWeight");
	if currentWeight ~= nil then
		self:setCurrentWeight(currentWeight);	
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;
 
function changeableWeight:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'currentWeight="'..self.currentWeight..'" ';
	return attributes;
end;

function changeableWeight:mouseEvent(posX, posY, isDown, isUp, button)
end;

function changeableWeight:keyEvent(unicode, sym, modifier, isDown)
end;

function changeableWeight:update(dt)
	if self:getIsActiveForInput() then		
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA4) then
			self:setCurrentWeight(self.currentWeight+1);		
		end;			
	end;
end;

function changeableWeight:updateTick(dt)
end;

function changeableWeight:onAttach()	
end;

function changeableWeight:onDetach()		
end;

function changeableWeight:draw()
	g_currentMission:addHelpButtonText(string.format(g_i18n:getText("CHANGEABLEWEIGHT_CHANGE"), self.currentWeightTo*1000), InputBinding.IMPLEMENT_EXTRA4);
end;

SetCurrentWeightEvent = {};
SetCurrentWeightEvent_mt = Class(SetCurrentWeightEvent, Event);

InitEventClass(SetCurrentWeightEvent, "SetCurrentWeightEvent");

function SetCurrentWeightEvent:emptyNew()
    local self = Event:new(SetCurrentWeightEvent_mt);
    self.className="SetCurrentWeightEvent";
    return self;
end;

function SetCurrentWeightEvent:new(vehicle, currentWeight)
    local self = SetCurrentWeightEvent:emptyNew()
    self.vehicle = vehicle;
	self.currentWeight = currentWeight;
    return self;
end;

function SetCurrentWeightEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
    self.vehicle = networkGetObject(id);

	self.currentWeight = streamReadInt8(streamId);
	if self.vehicle ~= nil then
		self.vehicle:setCurrentWeight(self.currentWeight, true);
	end;
	
	if not connection:getIsServer() then
        g_server:broadcastEvent(SetCurrentWeightEvent:new(self.vehicle, self.currentWeight), nil, connection, self.vehicle);
    end;
end;

function SetCurrentWeightEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteInt8(streamId, self.currentWeight);
end;

function SetCurrentWeightEvent.sendEvent(vehicle, currentWeight, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetCurrentWeightEvent:new(vehicle, currentWeight), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetCurrentWeightEvent:new(vehicle, currentWeight));
		end;
	end;
end;