--
-- CardanShaft
-- Specialization for CardanShaft
--
-- fruktor, www.eifok-team.de
--

CardanShaft = {};

function CardanShaft.prerequisitesPresent(specializations)
    return true; --SpecializationUtil.hasSpecialization(Cylindered, specializations); 
end;

function CardanShaft:load(xmlFile)

	self.cShafts = {};	
	
	local i = -1;
	while true do
		i = i + 1;
		local index = getXMLString(xmlFile, string.format('vehicle.cardanShaft.shaft(%d)#index', i));
		if index == nil then break; end;
		local cs = {};
		cs.idx = Utils.indexToObject(self.components, index);
		cs.spd = getXMLFloat(xmlFile, string.format('vehicle.cardanShaft.shaft(%d)#speed', i));
		table.insert(self.cShafts, cs);
	end;
	
end;

function CardanShaft:delete()
end;

function CardanShaft:mouseEvent(posX, posY, isDown, isUp, button)
end;

function CardanShaft:keyEvent(unicode, sym, modifier, isDown)
end;

function CardanShaft:update(dt)
	
end;

function CardanShaft:updateTick(dt)
	--if not self.startedUpdating then
	--	self.updateInterval = self.time+10;
	--	self.startedUpdating = true;
	--end;
	local x,y,z = getRotation(self.wheels[1].driveNode);
	for i,shaft in pairs(self.cShafts) do
		setRotation(shaft.idx, x*shaft.spd, 0 ,0);			
	end;
	--setRotation(self.cShafts[2].idx, 0 ,0, x*self.cShafts[2].spd);
	--setRotation(self.cShafts[3].idx, 0 ,0, x*self.cShafts[3].spd);	
	--for _, part in pairs(self.movingParts) do
	--	part.isDirty = true;
	--end;
	--for _, part in pairs(self.movingTools) do
	--	part.isDirty = true;
	--end;
end;

function CardanShaft:draw()
end;
